/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.controls;

import de.elpro.ui.fx.controls.TimespanPicker;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class TimespanPickerTest
extends Application {
    public void start(Stage primaryStage) {
        primaryStage.setTitle("TimespanPicker Test");
        BorderPane pane = new BorderPane();
        Scene scene = new Scene((Parent)pane, 1500.0, 500.0);
        primaryStage.setScene(scene);
        ResizableCanvas canvas = new ResizableCanvas();
        pane.setCenter((Node)canvas);
        TimespanPicker picker = new TimespanPicker();
        picker.setPadding(new Insets(2.0));
        picker.getTimespans().add((Object)TimespanPickerTest.createTimespan("2010-05-14", "2010-08-16"));
        picker.getTimespans().add((Object)TimespanPickerTest.createTimespan("2010-08-16", "2010-10-20"));
        picker.getTimespans().add((Object)TimespanPickerTest.createTimespan("2012-02-09", "2012-06-02"));
        picker.getTimespans().add((Object)TimespanPickerTest.createTimespan("2013-02-20", "2013-10-11"));
        picker.getTimespans().add((Object)TimespanPickerTest.createTimespan("2014-03-27", "2014-10-07"));
        picker.getTimespans().add((Object)TimespanPickerTest.createTimespan("2015-02-12", "2015-10-22"));
        picker.getTimespans().add((Object)TimespanPickerTest.createTimespan("2016-01-21", "2016-09-27"));
        pane.setTop((Node)picker);
        SplitPane split = new SplitPane(new Node[]{new SplitPane(new Node[]{new SplitPane(new Node[]{new SplitPane(new Node[]{new SplitPane(new Node[]{new SplitPane(new Node[]{new Button(), new Button()}), new Button()}), new Button()}), new Button()}), new Button()}), new Button()});
        pane.setCenter((Node)split);
        primaryStage.show();
    }

    private static TimespanPicker.Timespan createTimespan(String fromStr, String toStr) {
        OffsetDateTime from = OffsetDateTime.of(LocalDateTime.of(LocalDate.parse(fromStr, DateTimeFormatter.ISO_DATE), LocalTime.of(0, 0)), ZoneOffset.UTC);
        OffsetDateTime to = OffsetDateTime.of(LocalDateTime.of(LocalDate.parse(toStr, DateTimeFormatter.ISO_DATE), LocalTime.of(0, 0)), ZoneOffset.UTC);
        return new TimespanPicker.Timespan(from, to, String.format("%s (%d)", DateTimeFormatter.ISO_DATE.format(from), Duration.between(from, to).toDays()));
    }

    public static void main(String[] args) {
        TimespanPickerTest.launch((String[])args);
    }

    class ResizableCanvas
    extends Canvas {
        ResizableCanvas() {
        }

        public double minHeight(double width) {
            return 64.0;
        }

        public double maxHeight(double width) {
            return 1000.0;
        }

        public double prefHeight(double width) {
            return this.minHeight(width);
        }

        public double minWidth(double height) {
            return 0.0;
        }

        public double maxWidth(double height) {
            return 10000.0;
        }

        public boolean isResizable() {
            return true;
        }

        public void resize(double width, double height) {
            super.setWidth(width);
            super.setHeight(height);
            GraphicsContext gc = this.getGraphicsContext2D();
            gc.clearRect(0.0, 0.0, width, height);
            gc.setStroke((Paint)Color.RED);
            gc.strokeLine(0.0, 0.0, width, height);
            gc.strokeLine(0.0, height, width, 0.0);
        }
    }
}

