/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.controls.skins;

import de.elpro.ui.fx.controls.FileChooserControl;
import java.io.File;
import javafx.beans.property.Property;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.FileChooser;

public class FileChooserControlSkin
extends SkinBase<FileChooserControl> {
    private HBox pane;
    private TextField path = new TextField();
    private Button browse = new Button("Durchsuchen ...");

    public FileChooserControlSkin(FileChooserControl control) {
        super((Control)control);
        HBox.setHgrow((Node)this.path, (Priority)Priority.ALWAYS);
        this.browse.setOnAction(event -> {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Datei ausw\u00e4hlen");
            File file = null;
            if (control.getPath() != null) {
                file = new File(control.getPath());
            }
            if (file != null && file.isDirectory()) {
                fileChooser.setInitialDirectory(file);
            } else if (file != null && file.isFile()) {
                fileChooser.setInitialDirectory(file.getParentFile());
                fileChooser.setInitialFileName(file.getName());
            } else {
                fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
            }
            File newFile = fileChooser.showOpenDialog(null);
            if (newFile != null) {
                control.setPath(newFile.getAbsolutePath());
            }
        });
        this.path.textProperty().bindBidirectional((Property)control.pathProperty());
        this.pane = new HBox(5.0, new Node[]{this.path, this.browse});
        this.getChildren().add((Object)this.pane);
    }
}

