/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.controls.skins;

import de.elpro.ui.fx.controls.LocaleTextField;
import de.elpro.ui.fx.utils.ComSunJavaFXUtilUtils;
import de.elpro.ui.text.LocaleDescriptor;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.PopupControl;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Skinnable;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.stage.WindowEvent;

public class LocaleTextFieldSkin
extends SkinBase<LocaleTextField> {
    private static final String COMBO_BOX_ROWS_TO_MEASURE_WIDTH_KEY = "comboBoxRowsToMeasureWidth";
    protected final LocaleTextField control;
    protected Node displayNode;
    protected StackPane arrowButton;
    protected Region arrow;
    protected PopupControl popup;
    protected ListView<Locale> listView;
    private boolean popupNeedsReconfiguring = true;
    private boolean showPopupOnMouseRelease = true;
    private boolean mouseInsideButton = false;
    private boolean listSelectionLock = false;
    private boolean listViewSelectionDirty = false;
    private boolean itemCountDirty;
    private final ListChangeListener<Locale> listViewItemsListener = new ListChangeListener<Locale>(){

        public void onChanged(ListChangeListener.Change<? extends Locale> c) {
            LocaleTextFieldSkin.this.itemCountDirty = true;
            ((LocaleTextField)LocaleTextFieldSkin.this.getSkinnable()).requestLayout();
        }
    };
    private boolean keyDown;
    private static final String PRESS_ACTION = "Press";
    private static final String RELEASE_ACTION = "Release";

    public LocaleTextFieldSkin(LocaleTextField control) {
        super((Control)control);
        this.control = control;
        this.control.getStyleClass().addAll((Object[])new String[]{"locale-text-field", "text-input", "text-field"});
        this.arrow = new Region();
        this.arrow.setFocusTraversable(false);
        this.arrow.getStyleClass().setAll((Object[])new String[]{"arrow"});
        this.arrow.setId("arrow");
        this.arrow.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.arrow.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.arrow.setMouseTransparent(true);
        this.arrowButton = new StackPane();
        this.arrowButton.setFocusTraversable(false);
        this.arrowButton.setId("arrow-button");
        this.arrowButton.getStyleClass().setAll((Object[])new String[]{"arrow-button"});
        this.arrowButton.getChildren().add((Object)this.arrow);
        control.focusedProperty().addListener((ov, t, hasFocus) -> ((FakeFocusTextField)this.displayNode).setFakeFocus((boolean)hasFocus));
        control.addEventFilter(KeyEvent.ANY, ke -> {
            if (this.displayNode != null) {
                if (ke.getTarget().equals(this.displayNode)) {
                    return;
                }
                this.displayNode.fireEvent((Event)ke.copyFor((Object)this.displayNode, (EventTarget)this.displayNode));
                ke.consume();
            }
        });
        this.listView = this.createListView();
        this.listView.setItems(control.getLocales());
        this.listView.setManaged(false);
        this.listView.getSelectionModel().select((Object)control.getLocale());
        this.listView.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> {
            control.setLocale((Locale)nv);
            this.updateArrowButton();
        });
        control.localeProperty().addListener((o, ov, nv) -> {
            if (nv != null && !nv.equals(this.listView.getSelectionModel().getSelectedItem())) {
                this.listView.getSelectionModel().select(nv);
                this.updateArrowButton();
            }
        });
        this.updateArrowButton();
        this.arrowButton.addEventHandler(MouseEvent.MOUSE_ENTERED, e -> this.mouseEntered((MouseEvent)e));
        this.arrowButton.addEventHandler(MouseEvent.MOUSE_PRESSED, e -> {
            this.mousePressed((MouseEvent)e);
            e.consume();
        });
        this.arrowButton.addEventHandler(MouseEvent.MOUSE_RELEASED, e -> {
            this.mouseReleased((MouseEvent)e);
            e.consume();
        });
        this.arrowButton.addEventHandler(MouseEvent.MOUSE_EXITED, e -> this.mouseExited((MouseEvent)e));
        this.getChildren().add((Object)this.arrowButton);
        this.getChildren().add(this.listView);
        control.showingProperty().addListener(il -> {
            if (control.isShowing()) {
                this.show();
            } else {
                this.hide();
            }
        });
    }

    private void updateArrowButton() {
        LocaleDescriptor descriptor = this.control.getLocaleDescriptor(this.control.getLocale());
        if (descriptor == null || descriptor.getFlagURL() == null) {
            if (!this.arrowButton.getChildren().contains((Object)this.arrow)) {
                this.arrowButton.getChildren().setAll((Object[])new Node[]{this.arrow});
            }
        } else {
            try {
                ImageView image = new ImageView(descriptor.getFlagURL());
                image.getStyleClass().add((Object)"flag-image");
                this.arrowButton.getChildren().setAll((Object[])new Node[]{image});
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    protected Node getPopupContent() {
        return this.listView;
    }

    protected PopupControl getPopup() {
        if (this.popup == null) {
            this.createPopup();
        }
        return this.popup;
    }

    public void show() {
        if (this.getSkinnable() == null) {
            throw new IllegalStateException("ComboBox is null");
        }
        Node content = this.getPopupContent();
        if (content == null) {
            throw new IllegalStateException("Popup node is null");
        }
        if (this.getPopup().isShowing()) {
            return;
        }
        this.positionAndShowPopup();
    }

    public void hide() {
        if (this.popup != null && this.popup.isShowing()) {
            this.popup.hide();
        }
    }

    public Node getDisplayNode() {
        if (this.displayNode == null) {
            FakeFocusTextField textField = new FakeFocusTextField();
            textField.setFocusTraversable(false);
            textField.textProperty().bindBidirectional((Property)this.control.textProperty());
            textField.promptTextProperty().bind((ObservableValue)this.control.promptTextProperty());
            textField.editableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.control.disabledProperty()));
            this.displayNode = textField;
        }
        return this.displayNode;
    }

    protected void updateDisplayArea() {
        ObservableList children = this.getChildren();
        Node oldDisplayNode = this.displayNode;
        this.displayNode = this.getDisplayNode();
        if (oldDisplayNode != null && oldDisplayNode != this.displayNode) {
            children.remove(oldDisplayNode);
        }
        if (this.displayNode != null && !children.contains(this.displayNode)) {
            children.add(this.displayNode);
            this.displayNode.applyCss();
        }
    }

    private Point2D getPrefPopupPosition() {
        return ComSunJavaFXUtilUtils.pointRelativeTo((Node)this.getSkinnable(), this.getPopupContent(), HPos.CENTER, VPos.BOTTOM, 0.0, 0.0, true);
    }

    private void positionAndShowPopup() {
        PopupControl _popup = this.getPopup();
        _popup.getScene().setNodeOrientation(((LocaleTextField)this.getSkinnable()).getEffectiveNodeOrientation());
        Node popupContent = this.getPopupContent();
        this.sizePopup();
        Point2D p = this.getPrefPopupPosition();
        this.popupNeedsReconfiguring = true;
        this.reconfigurePopup();
        LocaleTextField comboBoxBase = (LocaleTextField)this.getSkinnable();
        _popup.show(comboBoxBase.getScene().getWindow(), this.snapPosition(p.getX()), this.snapPosition(p.getY()));
        popupContent.requestFocus();
        this.sizePopup();
    }

    private void sizePopup() {
        Node popupContent = this.getPopupContent();
        if (popupContent instanceof Region) {
            Region r = (Region)popupContent;
            double prefHeight = this.snapSize(r.prefHeight(0.0));
            double minHeight = this.snapSize(r.minHeight(0.0));
            double maxHeight = this.snapSize(r.maxHeight(0.0));
            double h = this.snapSize(Math.min(Math.max(prefHeight, minHeight), Math.max(minHeight, maxHeight)));
            double prefWidth = this.snapSize(r.prefWidth(h));
            double minWidth = this.snapSize(r.minWidth(h));
            double maxWidth = this.snapSize(r.maxWidth(h));
            double w = this.snapSize(Math.min(Math.max(prefWidth, minWidth), Math.max(minWidth, maxWidth)));
            popupContent.resize(w, h);
        } else {
            popupContent.autosize();
        }
    }

    public void onAutoHide() {
        if (this.getControl().isShowing()) {
            this.getControl().hide();
        }
        this.showPopupOnMouseRelease = this.mouseInsideButton ? !this.showPopupOnMouseRelease : true;
    }

    private void createPopup() {
        this.popup = new PopupControl(){
            {
                this.setSkin((Skin)new Skin<Skinnable>(){

                    public Skinnable getSkinnable() {
                        return LocaleTextFieldSkin.this.getSkinnable();
                    }

                    public Node getNode() {
                        return LocaleTextFieldSkin.this.getPopupContent();
                    }

                    public void dispose() {
                    }
                });
            }

            public Styleable getStyleableParent() {
                return LocaleTextFieldSkin.this.getSkinnable();
            }
        };
        this.popup.getStyleClass().add((Object)"combo-box-popup");
        this.popup.setConsumeAutoHidingEvents(false);
        this.popup.setAutoHide(true);
        this.popup.setAutoFix(true);
        this.popup.setHideOnEscape(true);
        this.popup.setOnAutoHide(e -> this.onAutoHide());
        this.popup.addEventHandler(MouseEvent.MOUSE_CLICKED, t -> this.onAutoHide());
        this.popup.addEventHandler(WindowEvent.WINDOW_HIDDEN, t -> ((LocaleTextField)this.getSkinnable()).notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_NODE));
        InvalidationListener layoutPosListener = o -> {
            this.popupNeedsReconfiguring = true;
            this.reconfigurePopup();
        };
        ((LocaleTextField)this.getSkinnable()).layoutXProperty().addListener(layoutPosListener);
        ((LocaleTextField)this.getSkinnable()).layoutYProperty().addListener(layoutPosListener);
        ((LocaleTextField)this.getSkinnable()).widthProperty().addListener(layoutPosListener);
        ((LocaleTextField)this.getSkinnable()).heightProperty().addListener(layoutPosListener);
        ((LocaleTextField)this.getSkinnable()).sceneProperty().addListener(o -> {
            if (((ObservableValue)o).getValue() == null) {
                this.hide();
            }
        });
    }

    void reconfigurePopup() {
        double newHeight;
        if (this.popup == null) {
            return;
        }
        boolean isShowing = this.popup.isShowing();
        if (!isShowing) {
            return;
        }
        if (!this.popupNeedsReconfiguring) {
            return;
        }
        this.popupNeedsReconfiguring = false;
        Point2D p = this.getPrefPopupPosition();
        Node popupContent = this.getPopupContent();
        double minWidth = popupContent.prefWidth(-1.0);
        double minHeight = popupContent.prefHeight(-1.0);
        if (p.getX() > -1.0) {
            this.popup.setAnchorX(p.getX());
        }
        if (p.getY() > -1.0) {
            this.popup.setAnchorY(p.getY());
        }
        if (minWidth > -1.0) {
            this.popup.setMinWidth(minWidth);
        }
        if (minHeight > -1.0) {
            this.popup.setMinHeight(minHeight);
        }
        Bounds b = popupContent.getLayoutBounds();
        double currentWidth = b.getWidth();
        double currentHeight = b.getHeight();
        double newWidth = currentWidth < minWidth ? minWidth : currentWidth;
        double d = newHeight = currentHeight < minHeight ? minHeight : currentHeight;
        if (newWidth != currentWidth || newHeight != currentHeight) {
            popupContent.resize(newWidth, newHeight);
            if (popupContent instanceof Region) {
                ((Region)popupContent).setMinSize(newWidth, newHeight);
                ((Region)popupContent).setPrefSize(newWidth, newHeight);
            }
        }
    }

    private boolean isButton() {
        return false;
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        this.reconfigurePopup();
        return 50.0;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.displayNode == null) {
            this.updateDisplayArea();
        }
        double arrowWidth = this.snapSize(this.arrow.prefWidth(-1.0));
        double arrowButtonWidth = this.isButton() ? 0.0 : this.arrowButton.snappedLeftInset() + arrowWidth + this.arrowButton.snappedRightInset();
        double displayNodeWidth = this.displayNode == null ? 0.0 : this.displayNode.prefWidth(height);
        double totalWidth = displayNodeWidth + arrowButtonWidth;
        double superPrefWidth = leftInset + totalWidth + rightInset;
        double listViewWidth = this.listView.prefWidth(height);
        double pw = Math.max(superPrefWidth, listViewWidth);
        this.reconfigurePopup();
        return pw;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        this.reconfigurePopup();
        return ((LocaleTextField)this.getSkinnable()).prefWidth(height);
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        this.reconfigurePopup();
        return super.computeMinHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double ph;
        this.reconfigurePopup();
        if (this.displayNode == null) {
            this.updateDisplayArea();
        }
        if (this.displayNode == null) {
            double arrowHeight = this.isButton() ? 0.0 : this.arrowButton.snappedTopInset() + this.arrow.prefHeight(-1.0) + this.arrowButton.snappedBottomInset();
            ph = Math.max(21.0, arrowHeight);
        } else {
            ph = this.displayNode.prefHeight(width);
        }
        return topInset + ph + bottomInset;
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        this.reconfigurePopup();
        return ((LocaleTextField)this.getSkinnable()).prefHeight(width);
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double arrowButtonWidth;
        if (this.listViewSelectionDirty) {
            try {
                this.listSelectionLock = true;
                Locale item = this.control.getLocale();
                this.listView.getSelectionModel().clearSelection();
                this.listView.getSelectionModel().select((Object)item);
            }
            finally {
                this.listSelectionLock = false;
                this.listViewSelectionDirty = false;
            }
        }
        if (this.displayNode == null) {
            this.updateDisplayArea();
        }
        double arrowWidth = this.snapSize(this.arrow.prefWidth(-1.0));
        double d = arrowButtonWidth = this.isButton() ? 0.0 : this.arrowButton.snappedLeftInset() + arrowWidth + this.arrowButton.snappedRightInset();
        if (this.displayNode != null) {
            this.displayNode.resizeRelocate(x, y, w - arrowButtonWidth, h);
        }
        this.arrowButton.setVisible(!this.isButton());
        if (!this.isButton()) {
            this.arrowButton.resize(arrowButtonWidth, h);
            this.positionInArea((Node)this.arrowButton, x + w - arrowButtonWidth, y, arrowButtonWidth, h, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    protected double computeBaselineOffset(double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.displayNode == null) {
            this.updateDisplayArea();
        }
        if (this.displayNode != null) {
            return this.displayNode.getLayoutBounds().getMinY() + this.displayNode.getLayoutY() + this.displayNode.getBaselineOffset();
        }
        return super.computeBaselineOffset(topInset, rightInset, bottomInset, leftInset);
    }

    protected LocaleTextField getControl() {
        return this.control;
    }

    public void mousePressed(MouseEvent e) {
        this.arm(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.disarm();
        if (this.showPopupOnMouseRelease) {
            if (!this.getControl().isShowing()) {
                this.getControl().requestFocus();
                this.getControl().show();
            }
        } else {
            this.showPopupOnMouseRelease = true;
            if (this.getControl().isShowing()) {
                this.getControl().hide();
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
        EventTarget target = e.getTarget();
        this.mouseInsideButton = target instanceof Node && "arrow-button".equals(((Node)target).getId());
        this.arm();
    }

    public void mouseExited(MouseEvent e) {
        this.mouseInsideButton = false;
        this.disarm();
    }

    private void getFocus() {
        if (!this.getControl().isFocused() && this.getControl().isFocusTraversable()) {
            this.getControl().requestFocus();
        }
    }

    private void arm(MouseEvent e) {
        boolean valid;
        boolean bl = valid = e.getButton() == MouseButton.PRIMARY && !e.isMiddleButtonDown() && !e.isSecondaryButtonDown() && !e.isShiftDown() && !e.isControlDown() && !e.isAltDown() && !e.isMetaDown();
        if (!this.getControl().isArmed() && valid) {
            this.getControl().arm();
        }
    }

    public void arm() {
        if (this.getControl().isPressed()) {
            this.getControl().arm();
        }
    }

    public void disarm() {
        if (!this.keyDown && this.getControl().isArmed()) {
            this.getControl().disarm();
        }
    }

    private ListView<Locale> createListView() {
        ListView<Locale> _listView = new ListView<Locale>(){
            {
                this.getProperties().put((Object)"selectFirstRowByDefault", (Object)false);
            }

            protected double computeMinHeight(double width) {
                return 30.0;
            }

            protected double computePrefWidth(double height) {
                double pw = Math.max(100.0, LocaleTextFieldSkin.this.control.getWidth());
                if (this.getItems().isEmpty() && this.getPlaceholder() != null) {
                    pw = Math.max(super.computePrefWidth(height), pw);
                }
                return Math.max(50.0, pw);
            }

            protected double computePrefHeight(double width) {
                return LocaleTextFieldSkin.this.getListViewPrefHeight();
            }
        };
        _listView.setCellFactory(cf -> new LocaleCell());
        _listView.setId("list-view");
        _listView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        _listView.setFocusTraversable(false);
        _listView.addEventFilter(MouseEvent.MOUSE_RELEASED, t -> {
            ObservableList s;
            EventTarget target = t.getTarget();
            if (target instanceof Parent && ((s = ((Parent)target).getStyleClass()).contains("thumb") || s.contains("track") || s.contains("decrement-arrow") || s.contains("increment-arrow"))) {
                return;
            }
            this.control.hide();
        });
        _listView.setOnKeyPressed(t -> {
            if (t.getCode() == KeyCode.ENTER || t.getCode() == KeyCode.SPACE || t.getCode() == KeyCode.ESCAPE) {
                this.control.hide();
            }
        });
        return _listView;
    }

    private double getListViewPrefHeight() {
        double ch = this.control.getLocales().size() * 25 + this.control.getLocales().size();
        double ph = Math.min(ch, 200.0);
        return ph;
    }

    public static final class FakeFocusTextField
    extends TextField {
        public void requestFocus() {
            if (this.getParent() != null) {
                this.getParent().requestFocus();
            }
        }

        public void setFakeFocus(boolean b) {
            this.setFocused(b);
        }

        public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
            switch (attribute) {
                case FOCUS_ITEM: {
                    return this.getParent();
                }
            }
            return super.queryAccessibleAttribute(attribute, parameters);
        }
    }

    private class LocaleCell
    extends ListCell<Locale> {
        private LocaleCell() {
        }

        protected void updateItem(Locale item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item == null || empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                LocaleDescriptor ld = LocaleTextFieldSkin.this.control.getLocaleDescriptor(item);
                if (ld == null) {
                    this.setText(item.toString());
                    this.setGraphic(null);
                } else {
                    this.setText(ld.getName());
                    try {
                        this.setGraphic((Node)new ImageView(ld.getFlagURL()));
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

