/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.controls.tree;

import de.elpro.ui.fx.bundle.Activator;
import de.elpro.ui.fx.controls.tree.LazyTreeItemState;
import de.elpro.ui.fx.utils.TaskUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.concurrent.Task;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.control.TreeItem;
import org.eclipse.fx.core.log.Logger;

public class LazyTreeItem<T>
extends TreeItem<T> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(LazyTreeItem.class.getName());
    private static final EventType<?> PRE_ADD_LOADED_CHILDREN = new EventType(LazyTreeItem.treeNotificationEvent(), "PRE_ADD_LOADED_CHILDREN");
    private static final EventType<?> POST_ADD_LOADED_CHILDREN = new EventType(LazyTreeItem.treeNotificationEvent(), "POST_ADD_LOADED_CHILDREN");
    private volatile LazyTreeItemState state = LazyTreeItemState.New;
    private Function<TreeItem<T>, List<TreeItem<T>>> listCreator;
    private InvalidationListener branchExpandedEvent = eh -> {
        if (this.isExpanded() && this.state == LazyTreeItemState.New) {
            this.loadItems();
        }
    };

    public LazyTreeItem(T value, Function<TreeItem<T>, List<TreeItem<T>>> listCreator) {
        super(value);
        this.listCreator = listCreator;
        this.getChildren().add((Object)new TreeItem());
        if (value == null) {
            this.loadItems();
        }
        this.expandedProperty().addListener(this.branchExpandedEvent);
    }

    public LazyTreeItem(T value, Collection<TreeItem<T>> children, Function<TreeItem<T>, List<TreeItem<T>>> listCreator) {
        super(value);
        this.listCreator = listCreator;
        this.getChildren().addAll(children);
        this.state = LazyTreeItemState.Loaded;
        this.expandedProperty().addListener(this.branchExpandedEvent);
    }

    public LazyTreeItem(T value, T[] children, Function<TreeItem<T>, List<TreeItem<T>>> listCreator) {
        this(value, Arrays.stream(children).map(v -> new LazyTreeItem<Object>(v, listCreator)).collect(Collectors.toList()), listCreator);
    }

    public LazyTreeItemState getState() {
        return this.state;
    }

    private Future<?> loadItems() {
        this.state = LazyTreeItemState.Loading;
        this.getChildren().clear();
        Task task = new Task<List<TreeItem<T>>>(){

            protected void succeeded() {
                super.succeeded();
                List list = (List)this.getValue();
                LazyTreeItem.this.state = list == null ? LazyTreeItemState.Error : LazyTreeItemState.Loaded;
                LazyTreeItem root = LazyTreeItem.this;
                while (root.getParent() != null) {
                    root = root.getParent();
                }
                Event.fireEvent((EventTarget)root, (Event)new TreeItem.TreeModificationEvent(LazyTreeItem.preAddLoadedChildrenEvent(), (TreeItem)LazyTreeItem.this));
                try {
                    if (list != null) {
                        if (!list.isEmpty()) {
                            LazyTreeItem.this.getChildren().setAll((Collection)list);
                        } else if (!LazyTreeItem.this.getChildren().isEmpty()) {
                            LazyTreeItem.this.getChildren().clear();
                        } else {
                            LazyTreeItem.this.getChildren().add((Object)new TreeItem());
                            LazyTreeItem.this.getChildren().clear();
                        }
                    } else {
                        if (LazyTreeItem.this.getChildren().isEmpty()) {
                            LazyTreeItem.this.getChildren().add((Object)new TreeItem());
                        }
                        LazyTreeItem.this.getChildren().clear();
                    }
                }
                finally {
                    Event.fireEvent((EventTarget)root, (Event)new TreeItem.TreeModificationEvent(LazyTreeItem.postAddLoadedChildrenEvent(), (TreeItem)LazyTreeItem.this));
                }
            }

            protected List<TreeItem<T>> call() throws Exception {
                try {
                    return LazyTreeItem.this.listCreator.apply(LazyTreeItem.this);
                }
                catch (Throwable exc) {
                    Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), exc);
                    return null;
                }
            }
        };
        return TaskUtils.executeTask(task);
    }

    public Future<?> refreshChildren() {
        return this.loadItems();
    }

    static <T> EventType<TreeItem.TreeModificationEvent<T>> preAddLoadedChildrenEvent() {
        return PRE_ADD_LOADED_CHILDREN;
    }

    static <T> EventType<TreeItem.TreeModificationEvent<T>> postAddLoadedChildrenEvent() {
        return POST_ADD_LOADED_CHILDREN;
    }
}

