/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.controls.tree;

import de.elpro.ui.fx.controls.tree.LazyTreeItem;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.control.TreeView;

public class TreeViewUtils {
    public static <T> void installSelectionBugWorkaround(TreeView<T> tree) {
        EventHandler preAdd = event -> {
            event.consume();
            tree.getSelectionModel().clearSelection();
        };
        EventHandler postAdd = event -> event.consume();
        ChangeListener rootListener = (observable, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.removeEventHandler(LazyTreeItem.preAddLoadedChildrenEvent(), preAdd);
                oldValue.removeEventHandler(LazyTreeItem.postAddLoadedChildrenEvent(), postAdd);
            }
            if (newValue != null) {
                newValue.addEventHandler(LazyTreeItem.preAddLoadedChildrenEvent(), preAdd);
                newValue.addEventHandler(LazyTreeItem.postAddLoadedChildrenEvent(), postAdd);
            }
        };
        rootListener.changed((ObservableValue)tree.rootProperty(), null, (Object)tree.getRoot());
        tree.rootProperty().addListener(rootListener);
    }

    private TreeViewUtils() {
    }
}

