/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.dialog.utils;

import javafx.scene.control.Alert;
import javafx.stage.Window;
import org.controlsfx.dialog.ExceptionDialog;

public final class AlertDialogUtils {
    public static void showWaitAlert(Alert.AlertType type, Window window, String hTxt, String cTxt) {
        Alert alert = new Alert(type);
        alert.initOwner(window);
        if (hTxt != null && !hTxt.trim().isEmpty()) {
            alert.setHeaderText(hTxt);
        }
        alert.setContentText(cTxt);
        alert.showAndWait();
    }

    public static void showAlert(Alert.AlertType type, Window window, String hTxt, String cTxt) {
        Alert alert = new Alert(type);
        alert.initOwner(window);
        if (hTxt != null && !hTxt.trim().isEmpty()) {
            alert.setHeaderText(hTxt);
        }
        alert.setContentText(cTxt);
        alert.show();
    }

    public static void showExceptionAlert(Window window, Throwable exc, String hTxt, String cTxt) {
        ExceptionDialog alert = new ExceptionDialog(exc);
        alert.initOwner(window);
        if (hTxt != null && !hTxt.trim().isEmpty()) {
            alert.setHeaderText(hTxt);
        }
        alert.setContentText(cTxt);
        alert.show();
    }

    public static Alert getConfirmAlert(Window window, String title, String headMsg, String contentMsg) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.initOwner(window);
        alert.setTitle(title);
        alert.setHeaderText(headMsg);
        alert.setContentText(contentMsg);
        return alert;
    }
}

