/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.layout;

import de.elpro.ui.concurrent.CallableTask;
import javafx.concurrent.Task;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;

public class ProgressIndicatorPane
extends StackPane {
    private final ProgressIndicator progress = new ProgressIndicator();
    private final GridPane progressPane = new GridPane();
    private CallableTask<?> task = null;
    private final Node content;

    public ProgressIndicatorPane(Node content) {
        this.progressPane.setAlignment(Pos.CENTER);
        this.progressPane.add((Node)this.progress, 0, 0);
        this.progressPane.getStyleClass().add((Object)"timer-pane");
        this.content = content;
        this.getChildren().add((Object)content);
    }

    public void showIndicator(boolean show) {
        if (show) {
            if (!this.getChildren().contains((Object)this.progressPane)) {
                this.getChildren().add((Object)this.progressPane);
            }
        } else {
            this.getChildren().remove((Object)this.progressPane);
        }
    }

    public void showIndicator() {
        this.showIndicator(true);
    }

    public void hideIndicator() {
        this.showIndicator(false);
    }

    public void setProgress(double progress) {
        this.progress.setProgress(progress);
    }

    public void setProgress(double progress, double max) {
        this.progress.setProgress(progress / max);
    }

    public void showIndicator(CallableTask<?> task) {
        if (task != null) {
            if (!this.getChildren().contains((Object)this.progressPane)) {
                this.getChildren().add((Object)this.progressPane);
            }
        } else {
            this.getChildren().remove((Object)this.progressPane);
        }
        this.task = task;
        this.progress.setProgress(-1.0);
        Task taskDelegate = this.task.getUITask();
        if (taskDelegate != null) {
            taskDelegate.progressProperty().addListener((o, ov, nv) -> {
                if (nv != null) {
                    this.setProgress(nv.doubleValue());
                }
            });
        }
    }

    public void taskDone() {
        this.showIndicator(false);
    }

    public void taskDone(CallableTask<?> task) {
        if (this.task == task) {
            this.showIndicator(false);
            this.task = null;
        }
    }

    public Node getContent() {
        return this.content;
    }
}

