/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.propertysheet;

import de.elpro.ui.controlsfx.propertysheet.PropertyItem;
import de.elpro.ui.fx.propertysheet.editors.ChoicePropertyEditor;
import de.elpro.ui.model.UILabeledElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.util.Callback;
import org.controlsfx.property.editor.PropertyEditor;

public class ChoicePropertyItem<T>
extends PropertyItem<T> {
    private final ObservableList<T> choices;
    private boolean isNullable = true;
    private boolean showChoiceHints = false;
    private Callback<T, String> choiceTextCallback = null;
    private Callback<T, Node> choiceGrafikCallback = null;

    public ChoicePropertyItem(String name, ObservableValue<T> valueProperty) {
        this((String)null, name, (String)null, valueProperty);
    }

    public ChoicePropertyItem(String category, String name, ObservableValue<T> valueProperty) {
        this(category, name, (String)null, valueProperty);
    }

    public ChoicePropertyItem(String category, String name, String description, ObservableValue<T> valueProperty) {
        super(category, name, description, valueProperty);
        this.choices = FXCollections.observableArrayList();
        this.choices.add(valueProperty.getValue());
        this.setReadOnly(true);
    }

    public ChoicePropertyItem(String name, ObservableValue<T> valueProperty, Collection<? extends T> choices) {
        this((String)null, name, (ObservableValue<? extends T>)valueProperty, choices);
    }

    public ChoicePropertyItem(String name, ObservableValue<T> valueProperty, T ... choices) {
        this((String)null, name, (String)null, valueProperty, (Collection<T>)Arrays.asList(choices));
    }

    public ChoicePropertyItem(String category, String name, ObservableValue<T> valueProperty, Collection<? extends T> choices) {
        this(category, name, (String)null, (ObservableValue<? extends T>)valueProperty, choices);
    }

    public ChoicePropertyItem(String category, String name, ObservableValue<T> valueProperty, T ... choices) {
        this(category, name, (String)null, valueProperty, (Collection<T>)Arrays.asList(choices));
    }

    public ChoicePropertyItem(String category, String name, String description, ObservableValue<T> valueProperty, Collection<? extends T> choices) {
        super(category, name, description, valueProperty);
        this.choices = FXCollections.observableArrayList();
        this.choices.setAll(choices);
    }

    public ChoicePropertyItem(String name, ObservableValue<T> valueProperty, ObservableList<T> choices) {
        this((String)null, name, (String)null, valueProperty, choices);
    }

    public ChoicePropertyItem(String category, String name, ObservableValue<T> valueProperty, ObservableList<T> choices) {
        this(category, name, (String)null, valueProperty, choices);
    }

    public ChoicePropertyItem(String category, String name, String description, ObservableValue<T> valueProperty, ObservableList<T> choices) {
        super(category, name, description, valueProperty);
        this.choices = choices;
    }

    public Collection<T> getChoices() {
        return this.choices;
    }

    public void setChoices(Collection<? extends T> choices) {
        if (choices == null) {
            this.choices.clear();
        } else {
            this.choices.setAll(choices);
        }
    }

    public void setChoicesArray(T ... choices) {
        this.setChoices(Arrays.asList(choices));
    }

    public ObservableList<T> choicesProperty() {
        return this.choices;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }

    public boolean getShowChoiceHints() {
        return this.showChoiceHints;
    }

    public void setShowChoiceHints(boolean showChoiceHints) {
        this.showChoiceHints = showChoiceHints;
    }

    public Class<?> getType() {
        return null;
    }

    public final T getValue() {
        return (T)this.valueProperty().getValue();
    }

    public Optional<Class<? extends PropertyEditor<?>>> getPropertyEditorClass() {
        return Optional.of(ChoicePropertyEditor.class);
    }

    public void setTextCallback(Callback<T, String> callback) {
        this.choiceTextCallback = callback;
    }

    public void setGrafikCallback(Callback<T, Node> callback) {
        this.choiceGrafikCallback = callback;
    }

    public Node getValueGrafik(Object o) {
        if (o == PropertyItem.NULL_OBJECT || o == null) {
            return null;
        }
        if (this.choiceGrafikCallback != null) {
            return (Node)this.choiceGrafikCallback.call(o);
        }
        if (o instanceof UILabeledElement) {
            return ((UILabeledElement)o).getGraphic();
        }
        return null;
    }

    public String getValueText(Object o) {
        if (o == PropertyItem.NULL_OBJECT) {
            return null;
        }
        if (this.choiceTextCallback != null) {
            return (String)this.choiceTextCallback.call(o);
        }
        if (o != null) {
            return o.toString();
        }
        return null;
    }
}

