/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.propertysheet;

import de.elpro.ui.controlsfx.propertysheet.PropertyItem;
import java.util.Collection;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import org.controlsfx.control.PropertySheet;

public class PropertyItemsHelper {
    public static ObservableBooleanValue createHasChangesProperty(Collection<PropertySheet.Item> items) {
        SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
        for (PropertySheet.Item item : items) {
            if (!(item instanceof PropertyItem)) continue;
            PropertyItem propertyItem = (PropertyItem)item;
            hasChanges = Bindings.or((ObservableBooleanValue)hasChanges, (ObservableBooleanValue)propertyItem.hasChangesProperty());
        }
        return hasChanges;
    }

    public static <T extends PropertySheet.Item> void resetHasChangesProperties(Collection<T> items) {
        for (PropertySheet.Item item : items) {
            if (!(item instanceof PropertyItem)) continue;
            PropertyItem propertyItem = (PropertyItem)item;
            propertyItem.resetChanges();
        }
    }

    public static ObservableBooleanValue createHasErrorsProperty(Collection<PropertySheet.Item> items) {
        SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
        for (PropertySheet.Item item : items) {
            if (!(item instanceof PropertyItem)) continue;
            PropertyItem propertyItem = (PropertyItem)item;
            hasErrors = Bindings.or((ObservableBooleanValue)hasErrors, (ObservableBooleanValue)propertyItem.invalidProperty());
        }
        return hasErrors;
    }

    public static void setReadOnly(Collection<PropertySheet.Item> items) {
        for (PropertySheet.Item item : items) {
            if (!(item instanceof PropertyItem)) continue;
            PropertyItem propertyItem = (PropertyItem)item;
            propertyItem.setReadOnly(true);
        }
    }

    public static void addPropertyItems(ObservableList<PropertySheet.Item> itemsContainer, String category, PropertyItem<?> ... items) {
        PropertyItem<?>[] propertyItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyItem<?> item = propertyItemArray[n2];
            item.setCategory(category);
            ++n2;
        }
        itemsContainer.addAll((Object[])items);
    }
}

