/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.propertysheet.editors;

import de.elpro.ui.controlsfx.propertysheet.PropertyItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.model.UILabeledElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.TextField;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.util.StringConverter;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.property.editor.AbstractPropertyEditor;

public class ChoicePropertyEditor
extends AbstractPropertyEditor<Object, ComboBox<Object>> {
    public ChoicePropertyEditor(PropertySheet.Item property) {
        super(property, (Node)new ComboBox(), false);
        ChoicePropertyItem choiceItem = (ChoicePropertyItem)property;
        ((ComboBox)this.getEditor()).disableProperty().bind((ObservableValue)choiceItem.readOnlyProperty());
        if (choiceItem.isNullable()) {
            ((ComboBox)this.getEditor()).getItems().add(PropertyItem.NULL_OBJECT);
        }
        ((ComboBox)this.getEditor()).getItems().addAll(choiceItem.getChoices());
        choiceItem.choicesProperty().addListener(il -> {
            Object choiceValue = null;
            Collection choices = choiceItem.getChoices();
            Object itemVal = choiceItem.getValue();
            if (itemVal != null) {
                for (Object nvObj : choices) {
                    if (!itemVal.equals(nvObj)) continue;
                    choiceValue = nvObj;
                    break;
                }
            }
            ArrayList<Object> newItems = new ArrayList<Object>();
            if (choiceItem.isNullable()) {
                newItems.add(PropertyItem.NULL_OBJECT);
            }
            newItems.addAll(choices);
            ((ComboBox)this.getEditor()).getItems().setAll(newItems);
            if (choiceValue != null) {
                ((ComboBox)this.getEditor()).setValue(choiceValue);
                ((ComboBox)this.getEditor()).getSelectionModel().select(choiceValue);
            } else {
                ((ComboBox)this.getEditor()).setValue(null);
                ((ComboBox)this.getEditor()).getSelectionModel().clearSelection();
            }
        });
        ((ComboBox)this.getEditor()).setButtonCell((ListCell)new ChoiceListCell(choiceItem));
        ((ComboBox)this.getEditor()).setCellFactory(listview -> new ChoiceListCell(choiceItem));
        ((ComboBox)this.getEditor()).promptTextProperty().bind((ObservableValue)choiceItem.promptTextProperty());
        if (choiceItem.getShowChoiceHints()) {
            this.attachAutoCompletition();
        }
    }

    protected void attachAutoCompletition() {
        final ChoicePropertyItem choiceItem = (ChoicePropertyItem)this.getProperty();
        StringConverter<Object> stringConverter = new StringConverter<Object>(){

            public String toString(Object object) {
                return choiceItem.getValueText(object);
            }

            public Object fromString(String string) {
                Object foundObject = choiceItem.isNullable() ? PropertyItem.NULL_OBJECT : null;
                for (Object o : ((ComboBox)ChoicePropertyEditor.this.getEditor()).getItems()) {
                    String stringRepresentation = choiceItem.getValueText(o);
                    if (stringRepresentation == null || !stringRepresentation.trim().equals(string.trim())) continue;
                    return o;
                }
                return foundObject;
            }
        };
        ((ComboBox)this.getEditor()).setEditable(true);
        ((ComboBox)this.getEditor()).setConverter((StringConverter)stringConverter);
        AutoCompletionBinding autoCompletion = TextFields.bindAutoCompletion((TextField)((ComboBox)this.getEditor()).getEditor(), arg_0 -> this.lambda$2((StringConverter)stringConverter, choiceItem, arg_0), (StringConverter)stringConverter);
        autoCompletion.setOnAutoCompleted(event -> {
            Object completion = event.getCompletion();
            if (completion == PropertyItem.NULL_OBJECT) {
                completion = null;
            }
            choiceItem.setValue(completion);
        });
    }

    public void setValue(Object arg0) {
        ((ComboBox)this.getEditor()).setValue(arg0);
    }

    protected ObservableValue<Object> getObservableValue() {
        return ((ComboBox)this.getEditor()).valueProperty();
    }

    private /* synthetic */ Collection lambda$2(StringConverter stringConverter, ChoicePropertyItem choicePropertyItem, AutoCompletionBinding.ISuggestionRequest request) {
        LinkedList suggestions = new LinkedList();
        if (request.getUserText().trim().isEmpty()) {
            return suggestions;
        }
        Object convertHint = stringConverter.fromString(request.getUserText());
        if (convertHint != null && convertHint != PropertyItem.NULL_OBJECT) {
            return suggestions;
        }
        int count = 0;
        for (Object o : ((ComboBox)this.getEditor()).getItems()) {
            String stringRepresentation;
            if (o.toString() == null || !(stringRepresentation = choicePropertyItem.getValueText(o)).toLowerCase().contains(request.getUserText().toLowerCase())) continue;
            suggestions.add(o);
            if (++count >= 10) break;
        }
        return suggestions;
    }

    private class ChoiceListCell
    extends ListCell<Object> {
        private final ChoicePropertyItem<?> choiceItem;
        private final Font defaultFont = this.getFont();

        public ChoiceListCell(ChoicePropertyItem<?> choiceItem) {
            this.choiceItem = choiceItem;
            this.choiceItem.promptTextProperty().addListener(il -> {
                if (this.getItem() == null || this.getItem().equals(PropertyItem.NULL_OBJECT)) {
                    this.setGraphic(null);
                    this.setText(choiceItem.getPromptText());
                    this.setTextFill((Paint)Color.GRAY);
                }
            });
        }

        protected void updateItem(Object item, boolean empty) {
            super.updateItem(item, empty);
            if (item == null || empty || item.equals(PropertyItem.NULL_OBJECT)) {
                this.setGraphic(null);
                this.setText(this.choiceItem.getPromptText());
                this.setTextFill((Paint)Color.GRAY);
            } else {
                this.setGraphic(this.choiceItem.getValueGrafik(item));
                this.setText(this.choiceItem.getValueText(item));
                if (item instanceof UILabeledElement) {
                    UILabeledElement lItem = (UILabeledElement)item;
                    this.setTextFill(lItem.getTextFill());
                    this.setFont(Font.font((String)this.defaultFont.getFamily(), (FontWeight)lItem.getFontWeight(), (double)this.defaultFont.getSize()));
                } else {
                    this.setTextFill((Paint)Color.BLACK);
                    this.setFont(this.defaultFont);
                }
            }
        }
    }
}

