/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.propertysheet.editors;

import de.elpro.ui.controlsfx.propertysheet.PropertyItem;
import de.elpro.ui.fx.controls.LocaleTextField;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.text.LocaleDescriptor;
import de.elpro.ui.text.LocaleDescriptors;
import java.util.Locale;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.AbstractPropertyEditor;

public class LocaleTextPropertyEditor
extends AbstractPropertyEditor<String, LocaleTextField> {
    public LocaleTextPropertyEditor(PropertySheet.Item property) {
        super(property, (Node)new LocaleTextField(LocaleTextPropertyEditor.getItemDefautLocale(property), LocaleTextPropertyEditor.getItemLocaleDescriptors(property)), false);
        if (property instanceof PropertyItem) {
            PropertyItem propertyItem = (PropertyItem)property;
            ((LocaleTextField)this.getEditor()).setPromptText(propertyItem.getPromptText());
            ((LocaleTextField)this.getEditor()).disableProperty().bind((ObservableValue)propertyItem.readOnlyProperty());
        } else {
            ((LocaleTextField)this.getEditor()).setDisable(!property.isEditable());
        }
    }

    private static Locale getItemDefautLocale(PropertySheet.Item item) {
        if (item instanceof LocaleStringPropertyItem) {
            return ((LocaleStringPropertyItem)item).getDefaultLocale();
        }
        return Locale.getDefault();
    }

    private static LocaleDescriptor[] getItemLocaleDescriptors(PropertySheet.Item item) {
        if (item instanceof LocaleStringPropertyItem) {
            return ((LocaleStringPropertyItem)item).getLocaleDescriptors();
        }
        return LocaleDescriptors.getDescriptors();
    }

    protected ObservableValue<String> getObservableValue() {
        return ((LocaleTextField)this.getEditor()).localeTextProperty();
    }

    public void setValue(String value) {
        ((LocaleTextField)this.getEditor()).setLocaleText(value);
    }
}

