/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.propertysheet.editors;

import de.elpro.ui.fx.propertysheet.MultChoicesPropertyItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.StringConverter;
import org.controlsfx.control.CheckComboBox;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.PropertyEditor;

public class MultChoicesPropertyEditor
implements PropertyEditor<Collection<Object>> {
    private final CheckComboBox<Object> editor;
    private final HBox container;

    public MultChoicesPropertyEditor(final PropertySheet.Item property) {
        final MultChoicesPropertyItem choiceItem = (MultChoicesPropertyItem)property;
        this.editor = new CheckComboBox(FXCollections.observableArrayList(choiceItem.getChoices()));
        this.editor.setDisable(!property.isEditable());
        this.container = new HBox(new Node[]{this.editor});
        GridPane.setHgrow(this.editor, (Priority)Priority.SOMETIMES);
        GridPane.setHalignment(this.editor, (HPos)HPos.LEFT);
        choiceItem.choicesProperty().addListener((o, ov, nv) -> {
            ObservableList checkedItems = this.editor.getCheckModel().getCheckedItems();
            ArrayList<Integer> checkedIndexes = new ArrayList<Integer>();
            int index = 0;
            for (Object onv : nv) {
                if (checkedItems.contains(onv)) {
                    checkedIndexes.add(index);
                }
                ++index;
            }
            this.editor.getCheckModel().clearChecks();
            this.editor.getItems().setAll(nv);
            if (!checkedIndexes.isEmpty()) {
                int[] indices = new int[checkedIndexes.size()];
                int i = 0;
                while (i < checkedIndexes.size()) {
                    indices[i] = (Integer)checkedIndexes.get(i);
                    ++i;
                }
                this.editor.getCheckModel().checkIndices(indices);
            }
        });
        boolean allValuesPresent = true;
        for (Object o2 : (Collection)choiceItem.getValue()) {
            if (this.editor.getItems().contains(o2)) {
                this.editor.getCheckModel().check(o2);
                continue;
            }
            allValuesPresent = false;
        }
        this.editor.getCheckModel().getCheckedItems().addListener((ListChangeListener)new ListChangeListener<Object>(){

            public void onChanged(ListChangeListener.Change<?> c) {
                property.setValue(MultChoicesPropertyEditor.this.getValue());
            }
        });
        if (!allValuesPresent) {
            property.setValue(this.getValue());
        }
        this.editor.setConverter((StringConverter)new StringConverter<Object>(){

            public String toString(Object object) {
                return choiceItem.getValueText(object);
            }

            public Object fromString(String string) {
                return null;
            }
        });
    }

    public Node getEditor() {
        return this.container;
    }

    public Set<Object> getValue() {
        HashSet<Object> checkedItems = new HashSet<Object>();
        for (Object c : this.editor.getCheckModel().getCheckedItems()) {
            checkedItems.add(c);
        }
        return checkedItems;
    }

    public void setValue(Collection<Object> value) {
    }
}

