/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.propertysheet.editors;

import de.elpro.ui.controlsfx.propertysheet.PropertyItem;
import de.elpro.ui.fx.propertysheet.StringOptionPropertyItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.property.editor.AbstractPropertyEditor;

public class StringOptionPropertyEditor
extends AbstractPropertyEditor<Object, ComboBox<Object>> {
    public StringOptionPropertyEditor(PropertySheet.Item property) {
        super(property, (Node)new ComboBox(), false);
        StringOptionPropertyItem choiceItem = (StringOptionPropertyItem)property;
        ((ComboBox)this.getEditor()).disableProperty().bind((ObservableValue)choiceItem.readOnlyProperty());
        if (choiceItem.isNullable()) {
            ((ComboBox)this.getEditor()).getItems().add(PropertyItem.NULL_OBJECT);
        }
        ((ComboBox)this.getEditor()).getItems().addAll(choiceItem.getOptions());
        choiceItem.choicesProperty().addListener(il -> {
            String choiceValue = null;
            Collection<String> choices = choiceItem.getOptions();
            String itemVal = choiceItem.getValue();
            if (itemVal != null) {
                for (String nvObj : choices) {
                    if (!itemVal.equals(nvObj)) continue;
                    choiceValue = nvObj;
                    break;
                }
            }
            ArrayList<Object> newItems = new ArrayList<Object>();
            if (choiceItem.isNullable()) {
                newItems.add(PropertyItem.NULL_OBJECT);
            }
            newItems.addAll(choices);
            ((ComboBox)this.getEditor()).getItems().setAll(newItems);
            if (choiceValue != null) {
                ((ComboBox)this.getEditor()).setValue((Object)choiceValue);
                ((ComboBox)this.getEditor()).getSelectionModel().select((Object)choiceValue);
            } else {
                ((ComboBox)this.getEditor()).setValue(null);
                ((ComboBox)this.getEditor()).getSelectionModel().clearSelection();
            }
        });
        ((ComboBox)this.getEditor()).promptTextProperty().bind((ObservableValue)choiceItem.promptTextProperty());
        this.attachAutoCompletition();
    }

    protected void attachAutoCompletition() {
        final StringOptionPropertyItem choiceItem = (StringOptionPropertyItem)this.getProperty();
        StringConverter<Object> stringConverter = new StringConverter<Object>(){

            public String toString(Object object) {
                return choiceItem.getValueText(object);
            }

            public Object fromString(String string) {
                if (string != null) {
                    return string;
                }
                return choiceItem.isNullable() ? PropertyItem.NULL_OBJECT : null;
            }
        };
        ((ComboBox)this.getEditor()).setEditable(true);
        ((ComboBox)this.getEditor()).setConverter((StringConverter)stringConverter);
        ((ComboBox)this.getEditor()).getEditor().setOnKeyTyped(e -> ((ComboBox)this.getEditor()).commitValue());
        AutoCompletionBinding autoCompletion = TextFields.bindAutoCompletion((TextField)((ComboBox)this.getEditor()).getEditor(), request -> {
            LinkedList suggestions = new LinkedList();
            if (request.getUserText() == null || request.getUserText().trim().isEmpty() || ((ComboBox)this.getEditor()).getItems().contains((Object)request.getUserText())) {
                return suggestions;
            }
            int count = 0;
            for (Object o : ((ComboBox)this.getEditor()).getItems()) {
                String stringRepresentation;
                if (o.toString() == null || !(stringRepresentation = choiceItem.getValueText(o)).toLowerCase().contains(request.getUserText().toLowerCase())) continue;
                suggestions.add(o);
                if (++count >= 10) break;
            }
            return suggestions;
        }, (StringConverter)stringConverter);
        autoCompletion.setOnAutoCompleted(event -> {
            Object completion = event.getCompletion();
            if (completion == PropertyItem.NULL_OBJECT) {
                completion = null;
            }
            choiceItem.setValue(completion);
        });
    }

    public void setValue(Object arg0) {
        ((ComboBox)this.getEditor()).setValue(arg0);
    }

    protected ObservableValue<Object> getObservableValue() {
        return ((ComboBox)this.getEditor()).valueProperty();
    }
}

