/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.propertysheet.editors;

import de.elpro.ui.controlsfx.propertysheet.PropertyItem;
import de.elpro.ui.fx.binding.Bindings;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextArea;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.AbstractPropertyEditor;

public class TextAreaEditor
extends AbstractPropertyEditor<String, TextArea> {
    public TextAreaEditor(PropertySheet.Item property) {
        super(property, (Node)new TextArea(), false);
        ((TextArea)this.getEditor()).getStyleClass().add((Object)"text-field");
        if (property instanceof PropertyItem) {
            PropertyItem propertyItem = (PropertyItem)property;
            ObservableObjectValue propmptTextBinding = Bindings.map(propertyItem.promptTextProperty(), s -> {
                if (s == null || !s.contains("\n")) {
                    return s;
                }
                return s.replace("\n", " ");
            });
            ((TextArea)this.getEditor()).promptTextProperty().bind(propmptTextBinding);
            ((TextArea)this.getEditor()).editableProperty().bind((ObservableValue)javafx.beans.binding.Bindings.not((ObservableBooleanValue)propertyItem.readOnlyProperty()));
        } else {
            ((TextArea)this.getEditor()).setEditable(property.isEditable());
        }
    }

    protected StringProperty getObservableValue() {
        return ((TextArea)this.getEditor()).textProperty();
    }

    public void setValue(String value) {
        ((TextArea)this.getEditor()).setText(value);
    }
}

