/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.providers;

import de.elpro.ui.fx.bundle.Activator;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.paint.Paint;
import org.eclipse.fx.core.URI;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.services.resources.GraphicNodeProvider;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.IkonHandler;
import org.kordamp.ikonli.Ikonli;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.javafx.IkonResolver;
import org.osgi.service.component.annotations.Component;

@Component
public class FontIconGraphicNodeProvider
implements GraphicNodeProvider {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(FontIconGraphicNodeProvider.class.getName());
    public static final String SUFFIX_FONT = "font";
    public static final String SUFFIX_IKONLI = "ikonli";
    public static final String SUFFIX_ICON = "icon";
    public static final String PROTOCOL = "icon:";
    public static final String IKONLI_PACK = "ikonli";
    public static final String PARAMS_ICON_COLOR = "color";
    public static final String PARAMS_ICON_SIZE = "size";
    public static final String PARAMS_ICON_PADDING = "padding";

    public String getName() {
        return "fx.fonticon";
    }

    public List<String> getFileSuffix() {
        return Arrays.asList(SUFFIX_FONT, "ikonli", SUFFIX_ICON);
    }

    public Node getGraphicNode(URI uri) throws IOException {
        Ikon icon;
        IkonHandler handler;
        String packName = uri.segment(0);
        if (!"ikonli".equals(packName)) {
            logger.warning(String.format("Pack '%s' ist not supported", packName));
            return FontIcon.of((Ikon)Ikonli.NONE);
        }
        String iconName = uri.segment(1);
        iconName = iconName.substring(0, iconName.lastIndexOf(46));
        try {
            handler = IkonResolver.getInstance().resolve(iconName);
        }
        catch (Exception exception) {
            logger.warning(String.format("No ikonli handler found for id '%s'", iconName));
            return FontIcon.of((Ikon)Ikonli.NONE);
        }
        try {
            icon = handler.resolve(iconName);
        }
        catch (Exception exc) {
            logger.error(String.format("No font found for id '%s'", iconName), (Throwable)exc);
            return FontIcon.of((Ikon)Ikonli.NONE);
        }
        FontIcon v = FontIcon.of((Ikon)icon, (int)16);
        String style = "";
        if (uri.hasQuery()) {
            String[] pvPairs;
            String[] stringArray = pvPairs = uri.query().split("&");
            int n = pvPairs.length;
            int n2 = 0;
            while (n2 < n) {
                String pvPair = stringArray[n2];
                String[] pvi = pvPair.split("=");
                if (pvi.length == 2) {
                    if (PARAMS_ICON_COLOR.equals(pvi[0])) {
                        try {
                            Paint p = Paint.valueOf((String)pvi[1]);
                            v.setFill(p);
                        }
                        catch (Exception exception) {}
                    } else if (PARAMS_ICON_SIZE.equals(pvi[0])) {
                        try {
                            int size = Integer.parseInt(pvi[1]);
                            v.setIconSize(size);
                        }
                        catch (Exception exception) {}
                    } else {
                        PARAMS_ICON_PADDING.equals(pvi[0]);
                    }
                }
                ++n2;
            }
        }
        if (!style.isEmpty()) {
            v.setStyle(style);
        }
        return v;
    }
}

