/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.providers;

import de.elpro.ui.fx.bundle.Activator;
import de.elpro.ui.fx.providers.FontIconGraphicNodeProvider;
import java.io.IOException;
import javafx.scene.Node;
import org.eclipse.fx.core.URI;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.controls.image.GraphicNodeProvider;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.Ikonli;
import org.kordamp.ikonli.javafx.FontIcon;
import org.osgi.service.component.annotations.Component;

@Component(service={GraphicNodeProvider.class})
public class StyledIconGraphicNodeProvider
implements GraphicNodeProvider {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(StyledIconGraphicNodeProvider.class.getName());
    public static final String PROTOCOL = "icon:";

    public String getName() {
        return "fx.styledicon";
    }

    public boolean handles(String url) {
        return url.startsWith(PROTOCOL);
    }

    public Node getGraphicNode(String uri) {
        try {
            return new FontIconGraphicNodeProvider().getGraphicNode(URI.create((String)uri));
        }
        catch (IOException exc) {
            logger.error(String.format("Error parsing font icon uri %s", uri), (Throwable)exc);
            return FontIcon.of((Ikon)Ikonli.NONE);
        }
    }
}

