/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.utils;

import de.elpro.ui.fx.utils.TreeViewState;
import de.elpro.ui.fx.utils.ViewClickEvent;
import de.elpro.ui.model.UILabeledElement;
import de.elpro.ui.model.UIModelElement;
import java.awt.Color;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.TreeView;
import javafx.scene.paint.Paint;

public class FXUtils {
    /*
     * Unable to fully structure code
     */
    public static <S> Integer getTreeTableViewItemIndex(TreeTableView<S> view, TreeItem<S> item) {
        currentItem = view.getRoot();
        i = 0;
        while (currentItem != null) {
            if (currentItem == item) break;
            ++i;
            if (!currentItem.isExpanded() || currentItem.getChildren().size() <= 0) ** GOTO lbl15
            currentItem = (TreeItem)currentItem.getChildren().get(0);
            continue;
lbl-1000:
            // 1 sources

            {
                neighbours = currentItem.getParent().getChildren();
                myIndex = neighbours.indexOf(currentItem);
                if (neighbours.size() - 1 > myIndex) {
                    currentItem = (TreeItem)neighbours.get(myIndex + 1);
                    break;
                }
                currentItem = currentItem.getParent();
lbl15:
                // 2 sources

                ** while (currentItem.getParent() != null)
            }
lbl16:
            // 2 sources

            if (currentItem != view.getRoot()) continue;
            return null;
        }
        return view.showRootProperty().getValue() != false ? i : i - 1;
    }

    /*
     * Unable to fully structure code
     */
    public static <S> Integer getTreeViewItemIndex(TreeView<S> view, TreeItem<S> item) {
        currentItem = view.getRoot();
        i = 0;
        while (currentItem != null) {
            if (currentItem == item) break;
            ++i;
            if (!currentItem.isExpanded() || currentItem.getChildren().size() <= 0) ** GOTO lbl15
            currentItem = (TreeItem)currentItem.getChildren().get(0);
            continue;
lbl-1000:
            // 1 sources

            {
                neighbours = currentItem.getParent().getChildren();
                myIndex = neighbours.indexOf(currentItem);
                if (neighbours.size() - 1 > myIndex) {
                    currentItem = (TreeItem)neighbours.get(myIndex + 1);
                    break;
                }
                currentItem = currentItem.getParent();
lbl15:
                // 2 sources

                ** while (currentItem.getParent() != null)
            }
lbl16:
            // 2 sources

            if (currentItem != view.getRoot()) continue;
            return null;
        }
        return view.showRootProperty().getValue() != false ? i : i - 1;
    }

    public static <T> void addOnMouseDoubleClickListener(TreeTableView<?> treeTableView, Class<T> targetType, ViewClickEvent<T> doubleClickEvent) {
        EventHandler oldHandler = treeTableView.getOnMouseClicked();
        treeTableView.setOnMouseClicked(event -> {
            TreeTableCell cell;
            if (oldHandler != null) {
                oldHandler.handle(event);
            }
            if (event.getClickCount() >= 2 && FXUtils.nestedInNodeType(event.getPickResult().getIntersectedNode(), TreeTableCell.class) && (cell = FXUtils.findParent(event.getPickResult().getIntersectedNode(), TreeTableCell.class)).getTreeTableRow().getItem() != null && targetType.isAssignableFrom(((UILabeledElement)cell.getTreeTableRow().getItem()).getClass())) {
                doubleClickEvent.onClick(cell.getTreeTableRow().getItem());
            }
        });
    }

    public static <T> void addOnMouseDoubleClickListener(TableView<?> tableView, Class<T> targetItemType, ViewClickEvent<T> doubleClickEvent) {
        EventHandler oldHandler = tableView.getOnMouseClicked();
        tableView.setOnMouseClicked(event -> {
            if (oldHandler != null) {
                oldHandler.handle(event);
            }
            if (event.getClickCount() >= 2 && FXUtils.nestedInNodeType(event.getPickResult().getIntersectedNode(), TableCell.class)) {
                Object rowItem;
                TableCell cell = FXUtils.findParent(event.getPickResult().getIntersectedNode(), TableCell.class);
                if (cell.getItem() != null && targetItemType.isAssignableFrom(cell.getItem().getClass())) {
                    doubleClickEvent.onClick(cell.getItem());
                } else if (cell.getTableRow() != null && cell.getTableRow().getItem() != null && targetItemType.isAssignableFrom((rowItem = cell.getTableRow().getItem()).getClass())) {
                    doubleClickEvent.onClick(rowItem);
                }
            }
        });
    }

    public static <T> void addOnMouseDoubleClickListener(ListView<?> listView, Class<T> targetItemType, ViewClickEvent<T> doubleClickEvent) {
        EventHandler oldHandler = listView.getOnMouseClicked();
        listView.setOnMouseClicked(event -> {
            if (oldHandler != null) {
                oldHandler.handle(event);
            }
            if (event.getClickCount() >= 2 && FXUtils.nestedInNodeType(event.getPickResult().getIntersectedNode(), ListCell.class)) {
                Object rowItem;
                ListCell cell = FXUtils.findParent(event.getPickResult().getIntersectedNode(), ListCell.class);
                if (cell.getItem() != null && targetItemType.isAssignableFrom(cell.getItem().getClass())) {
                    doubleClickEvent.onClick(cell.getItem());
                } else if (cell.getItem() != null && targetItemType.isAssignableFrom((rowItem = cell.getItem()).getClass())) {
                    doubleClickEvent.onClick(rowItem);
                }
            }
        });
    }

    public static <T> void bindFocusedProperty(TreeTableView<? super T> treeTableView, Property<T> focusedProperty) {
        EventHandler oldHandler = treeTableView.getOnMouseClicked();
        treeTableView.setOnMouseClicked(mouseEvent -> {
            if (oldHandler != null) {
                oldHandler.handle(mouseEvent);
            }
            if (FXUtils.nestedInNodeType(mouseEvent.getPickResult().getIntersectedNode(), TreeTableCell.class)) {
                TreeTableCell cell = FXUtils.findParent(mouseEvent.getPickResult().getIntersectedNode(), TreeTableCell.class);
                try {
                    Object item = cell.getTreeTableRow().getItem();
                    focusedProperty.setValue(item);
                }
                catch (Exception exception) {
                    focusedProperty.setValue(null);
                }
            }
        });
    }

    public static boolean nestedInNodeType(Node node, Class<?> parentClass) {
        if (node == null) {
            return false;
        }
        if (parentClass.isAssignableFrom(node.getClass())) {
            return true;
        }
        return FXUtils.nestedInNodeType((Node)node.getParent(), parentClass);
    }

    public static <T extends Node> T findParent(Node node, Class<T> parentClass) {
        return FXUtils.findParent(node, parentClass, -1);
    }

    public static <T extends Node> T findParent(Node node, Class<T> parentClass, int maxIterations) {
        if (node == null) {
            return null;
        }
        if (parentClass.isAssignableFrom(node.getClass())) {
            return (T)node;
        }
        if (maxIterations == 0) {
            return null;
        }
        return FXUtils.findParent((Node)node.getParent(), parentClass, maxIterations - 1);
    }

    public static <T extends Node> T findChild(Node node, Class<T> childClass) {
        if (node == null) {
            return null;
        }
        if (childClass.isAssignableFrom(node.getClass())) {
            return (T)node;
        }
        if (node instanceof Parent) {
            for (Node child : ((Parent)node).getChildrenUnmodifiable()) {
                T item = FXUtils.findChild(child, childClass);
                if (item == null) continue;
                return item;
            }
        }
        return null;
    }

    public static <T extends Node> Set<T> findChildren(Node node, Class<T> childClass) {
        return FXUtils.findChildren(node, childClass, e -> true);
    }

    public static <T extends Node> Set<T> findChildren(Node node, Class<T> childClass, Predicate<T> matcher) {
        Node foundElement;
        LinkedHashSet<Object> elements = new LinkedHashSet<Object>();
        if (node == null) {
            return null;
        }
        if (childClass.isAssignableFrom(node.getClass()) && matcher.test(foundElement = node)) {
            elements.add(foundElement);
        }
        if (node instanceof Parent) {
            for (Node child : ((Parent)node).getChildrenUnmodifiable()) {
                elements.addAll(FXUtils.findChildren(child, childClass, matcher));
            }
        }
        return elements;
    }

    public static void addKeySearcher(final TreeView<?> view) {
        final KeySearcherParams ksp = new KeySearcherParams();
        Thread resetThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LocalDateTime resetTs = null;
                while (true) {
                    KeySearcherParams keySearcherParams = ksp;
                    synchronized (keySearcherParams) {
                        resetTs = ksp.resetTs == null ? null : ksp.resetTs.plusNanos(0L);
                    }
                    if (resetTs != null && LocalDateTime.now().isAfter(resetTs)) {
                        keySearcherParams = ksp;
                        synchronized (keySearcherParams) {
                            ksp.resetTs = null;
                            ksp.filterText = "";
                        }
                    }
                    try {
                        Thread.sleep(300L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        resetThread.start();
        view.setOnKeyTyped(event -> {
            TreeItem treeItem;
            String filter = null;
            KeySearcherParams keySearcherParams2 = ksp;
            synchronized (keySearcherParams2) {
                filter = keySearcherParams.filterText = String.valueOf(keySearcherParams.filterText) + event.getCharacter();
                keySearcherParams.resetTs = LocalDateTime.now().plusSeconds(1L);
            }
            filter = filter.trim().toLowerCase();
            if (!filter.trim().isEmpty() && (treeItem = FXUtils.findTreeItem(view.getRoot(), filter)) != null) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Integer index = FXUtils.getTreeViewItemIndex(view, treeItem);
                        if (index != null) {
                            view.scrollTo(index.intValue());
                        }
                        view.getSelectionModel().select((Object)treeItem);
                    }
                });
            }
        });
    }

    public static void addKeySearcher(final TreeTableView<?> view) {
        final KeySearcherParams ksp = new KeySearcherParams();
        Thread resetThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LocalDateTime resetTs = null;
                while (true) {
                    KeySearcherParams keySearcherParams = ksp;
                    synchronized (keySearcherParams) {
                        resetTs = ksp.resetTs == null ? null : ksp.resetTs.plusNanos(0L);
                    }
                    if (resetTs != null && LocalDateTime.now().isAfter(resetTs)) {
                        keySearcherParams = ksp;
                        synchronized (keySearcherParams) {
                            ksp.resetTs = null;
                            ksp.filterText = "";
                        }
                    }
                    try {
                        Thread.sleep(300L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        resetThread.start();
        view.setOnKeyTyped(event -> {
            TreeItem treeItem;
            String filter = null;
            KeySearcherParams keySearcherParams2 = ksp;
            synchronized (keySearcherParams2) {
                filter = keySearcherParams.filterText = String.valueOf(keySearcherParams.filterText) + event.getCharacter();
                keySearcherParams.resetTs = LocalDateTime.now().plusSeconds(1L);
            }
            filter = filter.trim().toLowerCase();
            if (!filter.trim().isEmpty() && (treeItem = FXUtils.findTreeItem(view.getRoot(), filter)) != null) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Integer index = FXUtils.getTreeTableViewItemIndex(view, treeItem);
                        if (index != null) {
                            view.scrollTo(index.intValue());
                        }
                        view.getSelectionModel().select((Object)treeItem);
                    }
                });
            }
        });
    }

    public static <T> TreeItem<T> findTreeItem(TreeItem<T> rootItem, String containsText) {
        if (rootItem.getValue() != null && rootItem.getValue().toString() != null && rootItem.getValue().toString().trim().toLowerCase().startsWith(containsText)) {
            return rootItem;
        }
        for (TreeItem child : rootItem.getChildren()) {
            TreeItem<T> childResult = FXUtils.findTreeItem(child, containsText);
            if (childResult == null) continue;
            return childResult;
        }
        return null;
    }

    public static <T extends UILabeledElement> void sortTreeItems(List<TreeItem<T>> treeItems) {
        Collections.sort(treeItems, new Comparator<TreeItem<T>>(){

            @Override
            public int compare(TreeItem<T> o1, TreeItem<T> o2) {
                if (o1.getValue() instanceof UIModelElement) {
                    return ((UIModelElement)o1.getValue()).compareTo(o2.getValue());
                }
                if (o2.getValue() instanceof UIModelElement) {
                    return ((UIModelElement)o2.getValue()).compareTo(o1.getValue()) * -1;
                }
                return ((UILabeledElement)o1.getValue()).toString().compareTo(((UILabeledElement)o2.getValue()).toString());
            }
        });
    }

    public static <T extends UILabeledElement> void sortTreeItemsTree(TreeItem<T> treeItem) {
        FXUtils.sortTreeItems(treeItem.getChildren());
        treeItem.getChildren().forEach(c -> FXUtils.sortTreeItemsTree(c));
    }

    public static void runAndWait(Runnable run) throws InterruptedException, ExecutionException {
        FXUtils.runAndWait(() -> {
            run.run();
            return null;
        });
    }

    public static <V> V runAndWait(final Callable<V> run) throws InterruptedException, ExecutionException {
        final ExecutionResultHolder resultHolder = new ExecutionResultHolder();
        if (Platform.isFxApplicationThread()) {
            try {
                resultHolder.result = run.call();
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
        final ReentrantLock lock = new ReentrantLock();
        final Condition condition = lock.newCondition();
        final ThrowableWrapper throwableWrapper = new ThrowableWrapper();
        lock.lock();
        try {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    lock.lock();
                    try {
                        try {
                            resultHolder.result = run.call();
                        }
                        catch (Throwable e) {
                            throwableWrapper.t = e;
                            try {
                                condition.signal();
                            }
                            finally {
                                lock.unlock();
                            }
                        }
                    }
                    finally {
                        try {
                            condition.signal();
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }
            });
            condition.await();
            if (throwableWrapper.t != null) {
                throw new ExecutionException(throwableWrapper.t);
            }
        }
        finally {
            lock.unlock();
        }
        return resultHolder.result;
    }

    public static <T> TreeViewState<T> getViewState(TreeView<T> treeView) {
        TreeViewState<Object> state = new TreeViewState<Object>();
        if (treeView.getRoot() == null) {
            return state;
        }
        for (TreeItem selectedItem : treeView.getSelectionModel().getSelectedItems()) {
            if (selectedItem == null) continue;
            state.addSelectedItem(selectedItem.getValue());
        }
        LinkedList pool = new LinkedList();
        while (!pool.isEmpty()) {
            TreeItem treeItem = (TreeItem)pool.remove();
            if (!treeItem.isExpanded()) continue;
            state.addExpandedItem(treeItem.getValue());
            pool.addAll(treeItem.getChildren());
        }
        return state;
    }

    public static <T> void restoreViewState(TreeView<T> treeView, TreeViewState<T> state) {
        treeView.getSelectionModel().clearSelection();
        LinkedList<TreeItem> pool = new LinkedList<TreeItem>();
        pool.add(treeView.getRoot());
        while (!pool.isEmpty()) {
            TreeItem parentItem;
            TreeItem treeItem = (TreeItem)pool.remove();
            pool.addAll((Collection<TreeItem>)treeItem.getChildren());
            if (treeItem.getValue() == null) continue;
            if (state.isExpanded(treeItem.getValue())) {
                treeItem.setExpanded(true);
                parentItem = treeItem.getParent();
                while (parentItem != null && !parentItem.isExpanded()) {
                    parentItem.setExpanded(true);
                    parentItem = parentItem.getParent();
                }
            }
            if (!state.isSelected(treeItem.getValue())) continue;
            parentItem = treeItem.getParent();
            while (parentItem != null && !parentItem.isExpanded()) {
                parentItem.setExpanded(true);
                parentItem = parentItem.getParent();
            }
            treeView.getSelectionModel().select((Object)treeItem);
        }
    }

    public static Color getAwtColor(Paint paint) {
        if (paint instanceof javafx.scene.paint.Color) {
            javafx.scene.paint.Color color = (javafx.scene.paint.Color)paint;
            return new Color((int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0), (int)(color.getOpacity() * 255.0));
        }
        return Color.BLACK;
    }

    public static javafx.scene.paint.Color getFXColor(java.awt.Paint paint) {
        if (paint instanceof Color) {
            Color color = (Color)paint;
            return new javafx.scene.paint.Color((double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0, (double)color.getAlpha() / 255.0);
        }
        return javafx.scene.paint.Color.BLACK;
    }

    public static String toHexColor(javafx.scene.paint.Color color) {
        return String.format("rgba(%d, %d, %d, %s)", (int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0), new Formatter(Locale.US).format("%f", color.getOpacity()));
    }

    private static class ExecutionResultHolder<V> {
        private volatile V result;

        private ExecutionResultHolder() {
        }
    }

    private static class KeySearcherParams {
        public String filterText = "";
        public LocalDateTime resetTs = null;

        private KeySearcherParams() {
        }
    }

    private static class ThrowableWrapper {
        Throwable t;

        private ThrowableWrapper() {
        }
    }
}

