/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.utils;

import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.thread.NamedThreadFactory;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import org.controlsfx.control.TaskProgressView;

public class TaskUtils {
    private static final int CORES_COUNT = Math.max(Runtime.getRuntime().availableProcessors(), 1);
    private static TaskProgressView<Task<?>> taskProgressView;
    private static final ExecutorService EXECUTORS;

    static {
        EXECUTORS = Executors.newFixedThreadPool(CORES_COUNT <= 4 ? CORES_COUNT * 2 : Math.max(8, CORES_COUNT), (ThreadFactory)new NamedThreadFactory("callable-task-thread-"));
    }

    public static <T> Future<?> executeTask(Task<T> task) {
        return EXECUTORS.submit((Runnable)task);
    }

    public static <T> ConsumableFuture<T> executeTask(CallableTask<T> callableTask) {
        Future<T> future = EXECUTORS.submit(callableTask);
        return new ConsumableFuture<T>(future, callableTask);
    }

    public static <T> ConsumableFuture<T> executeUITask(CallableTask<T> callableTask) {
        Future<T> future = EXECUTORS.submit(callableTask);
        if (callableTask.getUITask() != null) {
            Platform.runLater(() -> TaskUtils.getTaskProgressView().getTasks().add((Object)callableTask.getUITask()));
        }
        return new ConsumableFuture<T>(future, callableTask);
    }

    public static <T> ConsumableFuture<T> executeUITask(ProgressIndicatorPane indicatorPane, CallableTask<T> callableTask) {
        if (indicatorPane != null) {
            Platform.runLater(() -> indicatorPane.showIndicator(callableTask));
        }
        Future<T> future = EXECUTORS.submit(callableTask);
        ConsumableFuture<Object> consumableFuture = new ConsumableFuture<Object>(future, callableTask);
        if (indicatorPane != null) {
            consumableFuture.consumeResult((s, r) -> Platform.runLater(() -> indicatorPane.taskDone(callableTask)));
        }
        return consumableFuture;
    }

    public static TaskProgressView<Task<?>> getTaskProgressView() {
        if (taskProgressView == null) {
            taskProgressView = new TaskProgressView();
        }
        return taskProgressView;
    }

    public static <T> void removeTaskFromView(CallableTask<T> callableTask) {
        if (callableTask != null && callableTask.getUITask() != null) {
            Platform.runLater(() -> {
                boolean bl = TaskUtils.getTaskProgressView().getTasks().remove((Object)callableTask.getUITask());
            });
        }
    }

    public static class ConsumableFuture<T> {
        private final Future<T> future;
        private final CallableTask<T> task;

        public ConsumableFuture(Future<T> future, CallableTask<T> task) {
            this.future = future;
            this.task = task;
        }

        public Future<T> consumeResult(TaskFinishCallback<T> callback) {
            EXECUTORS.submit(() -> {
                try {
                    T result = this.future.get();
                    Worker.State state = this.future.isCancelled() || this.task.getState() == Worker.State.CANCELLED ? Worker.State.CANCELLED : Worker.State.SUCCEEDED;
                    callback.finish(state, result);
                }
                catch (CancellationException cancellationException) {
                    callback.finish(Worker.State.CANCELLED, null);
                }
                catch (Exception e) {
                    callback.finish(Worker.State.FAILED, null);
                    if (this.task.getUITask() != null) {
                        Thread currentThread = Thread.currentThread();
                        Platform.runLater(() -> Thread.getDefaultUncaughtExceptionHandler().uncaughtException(currentThread, e));
                    }
                    e.printStackTrace();
                }
            });
            return this.future;
        }

        public Future<T> consumeResult(Consumer<T> consumer) {
            return this.consumeResult((Worker.State state, T result) -> {
                if (state == Worker.State.SUCCEEDED) {
                    consumer.accept(result);
                }
            });
        }

        public Future<T> getFuture() {
            return this.future;
        }

        public void cancel(boolean mayInterruptIfRunning) {
            if (mayInterruptIfRunning) {
                this.future.cancel(true);
            }
            this.task.cancel(mayInterruptIfRunning);
        }
    }

    public static interface TaskFinishCallback<T> {
        public void finish(Worker.State var1, T var2);
    }
}

