/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.utils;

import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ScaleTransition;
import javafx.animation.Timeline;
import javafx.animation.TranslateTransition;
import javafx.scene.Node;
import javafx.util.Duration;

public final class TransitionUtils {
    public static FadeTransition getFadeTransition(Node node, double fromValue, double toValue, int delay, int duration) {
        FadeTransition ft = new FadeTransition(Duration.seconds((double)duration), node);
        ft.setDelay(Duration.seconds((double)delay));
        ft.setFromValue(fromValue);
        ft.setToValue(toValue);
        return ft;
    }

    public static void playFadeInTransition(Node node, int duration, double fromVal, double toVal) {
        FadeTransition fITrans = new FadeTransition();
        fITrans.setDuration(Duration.seconds((double)duration));
        fITrans.setFromValue(fromVal);
        fITrans.setToValue(toVal);
        fITrans.setNode(node);
        fITrans.play();
    }

    public static TranslateTransition getTranslateTransition(Node node, int delay, int duration, int toX, int toY) {
        TranslateTransition translTrans = new TranslateTransition();
        translTrans.setDelay(Duration.seconds((double)delay));
        translTrans.setDuration(Duration.seconds((double)duration));
        translTrans.setNode(node);
        translTrans.setToX((double)toX);
        translTrans.setToY((double)toY);
        return translTrans;
    }

    public static TranslateTransition getSetByXTranslateTransition(Node node, int delay, int duration, int xPosition, int yPosition) {
        TranslateTransition translate = new TranslateTransition();
        translate.setDelay(Duration.seconds((double)delay));
        translate.setByX((double)xPosition);
        translate.setByY((double)yPosition);
        translate.setDuration(Duration.seconds((double)duration));
        translate.setNode(node);
        return translate;
    }

    public static ScaleTransition getScaleTransition(Node node, int delay, int duration, double toX, double toY) {
        ScaleTransition sTrans = new ScaleTransition(Duration.seconds((double)duration), node);
        sTrans.setDelay(Duration.seconds((double)delay));
        sTrans.setToX(toX);
        sTrans.setToY(toY);
        return sTrans;
    }

    public static void playTimeline(Node node1, int delay, int duration) {
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)duration), event -> node1.setVisible(true), new KeyValue[0])});
        timeline.setDelay(Duration.seconds((double)delay));
        timeline.play();
    }
}

