/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.concurrent;

import java.util.concurrent.Callable;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;

public abstract class CallableTask<V>
implements Callable<V> {
    private static boolean isUiCappable = false;
    private final TaskDelegate uiTask = isUiCappable ? new TaskDelegate() : null;

    static {
        try {
            Platform.runLater(() -> System.out.println("INFORMATION: JavaFX Toolkit running. Using FX styled Tasks"));
            isUiCappable = true;
        }
        catch (Exception exception) {
            System.out.println("INFORMATION: JavaFX Toolkit not running. Using OSGI styled Tasks");
        }
    }

    protected final void updateTitle(String title) {
        if (this.uiTask != null) {
            this.uiTask.updateTitle(title);
        }
    }

    protected final void updateMessage(String message) {
        if (this.uiTask != null) {
            this.uiTask.updateMessage(message);
        }
    }

    protected final void updateProgress(double workDone, double max) {
        if (this.uiTask != null) {
            this.uiTask.updateProgress(workDone, max);
        }
    }

    protected final void updateProgress(long workDone, long max) {
        if (this.uiTask != null) {
            this.uiTask.updateProgress(workDone, max);
        }
    }

    public final void cancel(boolean mayInterruptIfRunning) {
        this.cancelled();
        if (this.uiTask != null) {
            this.uiTask.cancel(mayInterruptIfRunning);
        }
    }

    protected void cancelled() {
    }

    public Worker.State getState() {
        if (this.uiTask != null) {
            return this.uiTask.getState();
        }
        return Worker.State.READY;
    }

    @Override
    public abstract V call() throws Exception;

    public final Task<V> getUITask() {
        return this.uiTask;
    }

    public static CallableTask<Void> create(final RunnableTask runnable) {
        return new CallableTask<Void>(){

            @Override
            public Void call() throws Exception {
                runnable.run();
                return null;
            }
        };
    }

    public static <R> CallableTask<R> create(final Callable<R> supplier) {
        return new CallableTask<R>(){

            @Override
            public R call() throws Exception {
                return supplier.call();
            }
        };
    }

    public static interface RunnableTask {
        public void run() throws Exception;
    }

    private final class TaskDelegate
    extends Task<V> {
        private TaskDelegate() {
        }

        public void updateTitle(String title) {
            super.updateTitle(title);
        }

        public void updateMessage(String message) {
            super.updateMessage(message);
        }

        public void updateProgress(double workDone, double max) {
            super.updateProgress(workDone, max);
        }

        public void updateProgress(long workDone, long max) {
            super.updateProgress(workDone, max);
        }

        protected void cancelled() {
            CallableTask.this.cancelled();
        }

        protected V call() throws Exception {
            return null;
        }
    }
}

