/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.formats;

import java.text.DecimalFormat;

public final class NumberFormats {
    public static final String SIMPLE_INTEGER_PATTERN = "0";
    public static final DecimalFormat SIMPLE_INTEGER = new DecimalFormat("0");
    public static final String INTEGER_PATTERN = "0";
    public static final DecimalFormat INTEGER = new DecimalFormat("0");
    public static final String CURRENCY_PATTERN = "0.00 \u20ac";
    public static final DecimalFormat CURRENCY = new DecimalFormat("0.00 \u20ac");
    public static final String DEFAULT_DOUBLE_PATTERN = "0.#";
    public static final DecimalFormat DEFAULT_DOUBLE = new DecimalFormat("0.#");
    public static final DecimalFormat F0 = new DecimalFormat("###,###,###,###,##0");
    public static final DecimalFormat F0_0 = new DecimalFormat("###,###,###,###,##0.0");
    public static final DecimalFormat F0_00 = new DecimalFormat("###,###,###,###,##0.00");
    public static final DecimalFormat F0_000 = new DecimalFormat("###,###,###,###,##0.000");
    public static final DecimalFormat FE0 = new DecimalFormat("0E0");
    public static final DecimalFormat FE0_0 = new DecimalFormat("0.0E0");
    public static final DecimalFormat FE0_00 = new DecimalFormat("0.00E0");
    public static final DecimalFormat FE0_000 = new DecimalFormat("0.000E0");
    public static final DecimalFormat PERCENT_F0_0 = new DecimalFormat("###,###,###,###,##0.0%");
    public static final DecimalFormat PERCENT_F0_00 = new DecimalFormat("###,###,###,###,##0.00%");

    public static final DecimalFormat getOptimalFormat(double value) {
        if (NumberFormats.isNearInteger(value) && Math.abs(value) >= 1.0E7) {
            return FE0;
        }
        if (Math.abs(value) >= 10000.0 || value == 0.0) {
            return F0;
        }
        if (Math.abs(value) >= 1000.0) {
            return F0_0;
        }
        if (Math.abs(value) >= 100.0) {
            return F0_00;
        }
        if (Math.abs(value) >= 0.005) {
            return F0_000;
        }
        return FE0_000;
    }

    public static final DecimalFormat getOptimalShortFormat(double value) {
        if (NumberFormats.isNearInteger(value) && Math.abs(value) >= 1.0E7) {
            return FE0;
        }
        if (Math.abs(value) >= 100.0 || value == 0.0) {
            return F0;
        }
        if (Math.abs(value) >= 10.0) {
            return F0_0;
        }
        if (Math.abs(value) >= 1.0) {
            return F0_00;
        }
        if (Math.abs(value) >= 0.005) {
            return F0_000;
        }
        return FE0_000;
    }

    public static final DecimalFormat getOptimalShortestFormat(double value) {
        if (NumberFormats.isNearInteger(value) && Math.abs(value) >= 1.0E7) {
            return FE0;
        }
        if (Math.abs(value) >= 100.0 || value == 0.0 || (double)Math.round(value) == value) {
            return F0;
        }
        if (Math.abs(value) >= 10.0 || (double)Math.round(value * 10.0) == value * 10.0) {
            return F0_0;
        }
        if (Math.abs(value) >= 1.0) {
            return F0_00;
        }
        if (Math.abs(value) >= 0.005) {
            return F0_000;
        }
        return FE0_000;
    }

    private static boolean isNearInteger(double value) {
        if (value == 0.0) {
            return true;
        }
        double diff = Math.abs((value = Math.abs(value)) - (double)Math.round(value));
        return diff < 1.0E-7 && value >= 0.9999999;
    }
}

