/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.formats;

import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;

public enum TimeFormatType {
    TimeHMsMs,
    TimeHMs,
    TimeHM,
    TimeMs,
    DateTimeHMsMs,
    DateTimeHMs,
    DateTimeHM,
    Date,
    Year,
    YearMonth,
    YearWeek,
    Week;

    private static final String TIME_HMSMS_PATTERN = "HH:mm:ss.SSS";
    private static final DateTimeFormatter TIME_HMSMS_FORMATTER;
    private static final String TIME_HMS_PATTERN = "HH:mm:ss";
    private static final DateTimeFormatter TIME_HMS_FORMATTER;
    private static final String TIME_HM_PATTERN = "HH:mm";
    private static final DateTimeFormatter TIME_HM_FORMATTER;
    private static final String TIME_MS_PATTERN = "mm:ss";
    private static final DateTimeFormatter TIME_MS_FORMATTER;
    private static final String DATE_PATTERN = "dd.MM.yyyy";
    private static final DateTimeFormatter DATE_FORMATTER;
    private static final String DATE_TIME_HMSMS_PATTERN = "dd.MM.yyyy HH:mm:ss.SSS";
    private static final DateTimeFormatter DATE_TIME_HMSMS_FORMATTER;
    private static final String DATE_TIME_HMS_PATTERN = "dd.MM.yyyy HH:mm:ss";
    private static final DateTimeFormatter DATE_TIME_HMS_FORMATTER;
    private static final String DATE_TIME_HM_PATTERN = "dd.MM.yyyy HH:mm";
    private static final DateTimeFormatter DATE_TIME_HM_FORMATTER;
    private static final String YEAR_WEEK_PATTERN = "ww YYYY";
    private static final DateTimeFormatter YEAR_WEEK_FORMATTER;
    private static final String WEEK_PATTERN = "ww";
    private static final DateTimeFormatter WEEK_FORMATTER;
    private static final String YEAR_MONTH_PATTERN = "MMM yyyy";
    private static final DateTimeFormatter YEAR_MONTH_FORMATTER;
    private static final String YEAR_PATTERN = "yyyy";
    private static final DateTimeFormatter YEAR_FORMATTER;

    static {
        TIME_HMSMS_FORMATTER = DateTimeFormatter.ofPattern(TIME_HMSMS_PATTERN);
        TIME_HMS_FORMATTER = DateTimeFormatter.ofPattern(TIME_HMS_PATTERN);
        TIME_HM_FORMATTER = DateTimeFormatter.ofPattern(TIME_HM_PATTERN);
        TIME_MS_FORMATTER = DateTimeFormatter.ofPattern(TIME_MS_PATTERN);
        DATE_FORMATTER = DateTimeFormatter.ofPattern(DATE_PATTERN);
        DATE_TIME_HMSMS_FORMATTER = DateTimeFormatter.ofPattern(DATE_TIME_HMSMS_PATTERN);
        DATE_TIME_HMS_FORMATTER = DateTimeFormatter.ofPattern(DATE_TIME_HMS_PATTERN);
        DATE_TIME_HM_FORMATTER = DateTimeFormatter.ofPattern(DATE_TIME_HM_PATTERN);
        YEAR_WEEK_FORMATTER = DateTimeFormatter.ofPattern(YEAR_WEEK_PATTERN);
        WEEK_FORMATTER = DateTimeFormatter.ofPattern(WEEK_PATTERN);
        YEAR_MONTH_FORMATTER = DateTimeFormatter.ofPattern(YEAR_MONTH_PATTERN);
        YEAR_FORMATTER = DateTimeFormatter.ofPattern(YEAR_PATTERN);
    }

    public String getPattern() {
        switch (this) {
            case TimeHMsMs: {
                return TIME_HMSMS_PATTERN;
            }
            case TimeHMs: {
                return TIME_HMS_PATTERN;
            }
            case TimeHM: {
                return TIME_HM_PATTERN;
            }
            case TimeMs: {
                return TIME_MS_PATTERN;
            }
            case DateTimeHMsMs: {
                return DATE_TIME_HMSMS_PATTERN;
            }
            case DateTimeHMs: {
                return DATE_TIME_HMS_PATTERN;
            }
            case DateTimeHM: {
                return DATE_TIME_HM_PATTERN;
            }
            case Date: {
                return DATE_PATTERN;
            }
            case Year: {
                return YEAR_PATTERN;
            }
            case YearMonth: {
                return YEAR_MONTH_PATTERN;
            }
            case YearWeek: {
                return YEAR_WEEK_PATTERN;
            }
            case Week: {
                return WEEK_PATTERN;
            }
        }
        return null;
    }

    public DateTimeFormatter getFormatter() {
        switch (this) {
            case TimeHMsMs: {
                return TIME_HMSMS_FORMATTER;
            }
            case TimeHMs: {
                return TIME_HMS_FORMATTER;
            }
            case TimeHM: {
                return TIME_HM_FORMATTER;
            }
            case TimeMs: {
                return TIME_MS_FORMATTER;
            }
            case DateTimeHMsMs: {
                return DATE_TIME_HMSMS_FORMATTER;
            }
            case DateTimeHMs: {
                return DATE_TIME_HMS_FORMATTER;
            }
            case DateTimeHM: {
                return DATE_TIME_HM_FORMATTER;
            }
            case Date: {
                return DATE_FORMATTER;
            }
            case Year: {
                return YEAR_FORMATTER;
            }
            case YearMonth: {
                return YEAR_MONTH_FORMATTER;
            }
            case YearWeek: {
                return YEAR_WEEK_FORMATTER;
            }
            case Week: {
                return WEEK_FORMATTER;
            }
        }
        return null;
    }

    public String format(TemporalAccessor temporal) {
        if (temporal == null) {
            return null;
        }
        return this.getFormatter().format(temporal);
    }

    public String toString() {
        switch (this) {
            case TimeHMsMs: {
                return "Time (Hour, Minute, Second, Millisecond)";
            }
            case TimeHMs: {
                return "Time (Hour, Minute, Second)";
            }
            case TimeHM: {
                return "Time (Hour, Minute)";
            }
            case TimeMs: {
                return "Time (Minute, Second)";
            }
            case DateTimeHMsMs: {
                return "Date and Time (Hour, Minute, Second, Millisecond)";
            }
            case DateTimeHMs: {
                return "Date and Time (Hour, Minute, Second)";
            }
            case DateTimeHM: {
                return "Date and Time (Hour, Minute)";
            }
            case Date: {
                return "Date";
            }
            case Year: {
                return "Year";
            }
            case YearMonth: {
                return "Month of year";
            }
            case YearWeek: {
                return "Week of year";
            }
            case Week: {
                return "Week";
            }
        }
        return null;
    }
}

