/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.json;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Base64;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class JsonReadWriteHelper {
    public static final String NaN = "NaN";
    public static final String PositiveInfinity = "+Inf";
    public static final String NegativeInfinity = "-Inf";

    public static void readName(String expectedName, JsonReader reader) throws IOException {
        String name = reader.nextName();
        if (expectedName != null && !expectedName.equals(name)) {
            throw new IOException(String.format("%s does not match expected token %s", name, expectedName));
        }
    }

    public static Integer readInteger(String expectedName, JsonReader reader) throws IOException {
        JsonReadWriteHelper.readName(expectedName, reader);
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return reader.nextInt();
    }

    public static Integer readInteger(JsonReader reader) throws IOException {
        return JsonReadWriteHelper.readInteger(null, reader);
    }

    public static int readInt(String expectedName, JsonReader reader) throws IOException {
        JsonReadWriteHelper.readName(expectedName, reader);
        return reader.nextInt();
    }

    public static int readInt(JsonReader reader) throws IOException {
        return JsonReadWriteHelper.readInt(null, reader);
    }

    public static long readLong(String expectedName, JsonReader reader) throws IOException {
        JsonReadWriteHelper.readName(expectedName, reader);
        return reader.nextLong();
    }

    public static long readLong(JsonReader reader) throws IOException {
        return JsonReadWriteHelper.readLong(null, reader);
    }

    public static Long readLongObj(String expectedName, JsonReader reader) throws IOException {
        JsonReadWriteHelper.readName(expectedName, reader);
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return reader.nextLong();
    }

    public static Long readLongObj(JsonReader reader) throws IOException {
        return JsonReadWriteHelper.readLongObj(null, reader);
    }

    public static double readDouble(String expectedName, JsonReader reader) throws IOException {
        Double d = JsonReadWriteHelper.readDoubleObj(expectedName, reader);
        if (d == null) {
            return Double.NaN;
        }
        return d;
    }

    public static double readDouble(JsonReader reader) throws IOException {
        return JsonReadWriteHelper.readDouble(null, reader);
    }

    public static Double readDoubleObj(String expectedName, JsonReader reader) throws IOException {
        JsonReadWriteHelper.readName(expectedName, reader);
        JsonToken jt = reader.peek();
        switch (jt) {
            case STRING: {
                String fs;
                switch (fs = reader.nextString()) {
                    case "NaN": {
                        return Double.NaN;
                    }
                    case "+Inf": {
                        return Double.POSITIVE_INFINITY;
                    }
                    case "-Inf": {
                        return Double.NEGATIVE_INFINITY;
                    }
                }
                reader.nextNull();
                return null;
            }
            case NUMBER: {
                return reader.nextDouble();
            }
        }
        reader.nextNull();
        return null;
    }

    public static Double readDoubleObj(JsonReader reader) throws IOException {
        return JsonReadWriteHelper.readDoubleObj(null, reader);
    }

    public static float readFloat(JsonReader reader) throws IOException {
        Float f = JsonReadWriteHelper.readFloatObj(reader);
        if (f == null) {
            return Float.NaN;
        }
        return f.floatValue();
    }

    public static Float readFloatObj(JsonReader reader) throws IOException {
        reader.nextName();
        JsonToken jt = reader.peek();
        switch (jt) {
            case STRING: {
                String fs;
                switch (fs = reader.nextString()) {
                    case "NaN": {
                        return Float.valueOf(Float.NaN);
                    }
                    case "+Inf": {
                        return Float.valueOf(Float.POSITIVE_INFINITY);
                    }
                    case "-Inf": {
                        return Float.valueOf(Float.NEGATIVE_INFINITY);
                    }
                }
                reader.nextNull();
                return null;
            }
            case NUMBER: {
                return Float.valueOf(((Number)reader.nextDouble()).floatValue());
            }
        }
        reader.nextNull();
        return null;
    }

    public static String readString(String expectedName, JsonReader reader) throws IOException {
        JsonReadWriteHelper.readName(expectedName, reader);
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return reader.nextString();
    }

    public static String readString(JsonReader reader) throws IOException {
        return JsonReadWriteHelper.readString(null, reader);
    }

    public static <T extends Enum<T>> T readEnum(String expectedName, JsonReader reader, Class<T> clazz) throws IOException {
        JsonReadWriteHelper.readName(expectedName, reader);
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return Enum.valueOf(clazz, reader.nextString());
    }

    public static <T extends Enum<T>> T readEnum(JsonReader reader, Class<T> clazz) throws IOException {
        return JsonReadWriteHelper.readEnum(null, reader, clazz);
    }

    public static boolean readBool(String expectedName, JsonReader reader) throws IOException {
        JsonReadWriteHelper.readName(expectedName, reader);
        return reader.nextBoolean();
    }

    public static boolean readBool(JsonReader reader) throws IOException {
        reader.nextName();
        return reader.nextBoolean();
    }

    public static Boolean readBoolean(String expectedName, JsonReader reader) throws IOException {
        JsonReadWriteHelper.readName(expectedName, reader);
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return reader.nextBoolean();
    }

    public static Boolean readBoolean(JsonReader reader) throws IOException {
        reader.nextName();
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return reader.nextBoolean();
    }

    public static LocalDate readLocalDate(JsonReader reader) throws IOException {
        reader.nextName();
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return LocalDate.parse(reader.nextString());
    }

    public static LocalDateTime readLocalDateTime(JsonReader reader) throws IOException {
        reader.nextName();
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return LocalDateTime.parse(reader.nextString());
    }

    public static Instant readInstant(String expectedName, JsonReader reader) throws IOException {
        JsonReadWriteHelper.readName(expectedName, reader);
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return Instant.ofEpochMilli(reader.nextLong());
    }

    public static Instant readInstant(JsonReader reader) throws IOException {
        reader.nextName();
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return Instant.ofEpochMilli(reader.nextLong());
    }

    public static Color readColor(JsonReader reader) throws IOException {
        String str = JsonReadWriteHelper.readString(reader);
        if (str == null) {
            return null;
        }
        return (Color)Paint.valueOf((String)str);
    }

    public static Byte readByte(JsonReader reader) throws IOException {
        reader.nextName();
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return Integer.valueOf(reader.nextInt()).byteValue();
    }

    public static byte[] readBytes(String expectedName, JsonReader reader) throws IOException {
        JsonReadWriteHelper.readName(expectedName, reader);
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return Base64.getDecoder().decode(reader.nextString());
    }

    public static byte[] readBytes(JsonReader reader) throws IOException {
        return JsonReadWriteHelper.readBytes(null, reader);
    }

    public static void writeValue(JsonWriter writer, String name, Integer value) throws IOException {
        writer.name(name);
        if (value != null) {
            writer.value((Number)value);
        } else {
            writer.nullValue();
        }
    }

    public static void writeValue(JsonWriter writer, String name, Long value) throws IOException {
        writer.name(name);
        if (value != null) {
            writer.value((Number)value);
        } else {
            writer.nullValue();
        }
    }

    public static void writeValue(JsonWriter writer, String name, Double value) throws IOException {
        writer.name(name);
        if (value != null) {
            if (value.isNaN()) {
                writer.value(NaN);
            } else if (value == Double.POSITIVE_INFINITY) {
                writer.value(PositiveInfinity);
            } else if (value == Double.NEGATIVE_INFINITY) {
                writer.value(NegativeInfinity);
            } else {
                writer.value((Number)value);
            }
        } else {
            writer.nullValue();
        }
    }

    public static void writeValue(JsonWriter writer, String name, Float value) throws IOException {
        writer.name(name);
        if (value != null) {
            if (value.isNaN()) {
                writer.value(NaN);
            } else if (value.floatValue() == Float.POSITIVE_INFINITY) {
                writer.value(PositiveInfinity);
            } else if (value.floatValue() == Float.NEGATIVE_INFINITY) {
                writer.value(NegativeInfinity);
            } else {
                writer.value((Number)value);
            }
        } else {
            writer.nullValue();
        }
    }

    public static <T extends Enum<T>> void writeValue(JsonWriter writer, String name, Enum<T> value) throws IOException {
        writer.name(name);
        if (value != null) {
            writer.value(value.name());
        } else {
            writer.nullValue();
        }
    }

    public static void writeValue(JsonWriter writer, String name, String value) throws IOException {
        writer.name(name);
        if (value != null) {
            writer.value(value);
        } else {
            writer.nullValue();
        }
    }

    public static void writeValue(JsonWriter writer, String name, Boolean value) throws IOException {
        writer.name(name);
        if (value != null) {
            writer.value(value);
        } else {
            writer.nullValue();
        }
    }

    public static void writeValue(JsonWriter writer, String name, LocalDate value) throws IOException {
        writer.name(name);
        if (value != null) {
            writer.value(value.toString());
        } else {
            writer.nullValue();
        }
    }

    public static void writeValue(JsonWriter writer, String name, LocalDateTime value) throws IOException {
        writer.name(name);
        if (value != null) {
            writer.value(value.toString());
        } else {
            writer.nullValue();
        }
    }

    public static void writeValue(JsonWriter writer, String name, Instant value) throws IOException {
        writer.name(name);
        if (value != null) {
            writer.value((Number)value.toEpochMilli());
        } else {
            writer.nullValue();
        }
    }

    public static void writeValue(JsonWriter writer, String name, Color color) throws IOException {
        JsonReadWriteHelper.writeValue(writer, name, color != null ? color.toString() : null);
    }

    public static void writeValue(JsonWriter writer, String name, Byte value) throws IOException {
        writer.name(name);
        if (value != null) {
            writer.value((long)((Number)value).intValue());
        } else {
            writer.nullValue();
        }
    }

    public static void writeValue(JsonWriter writer, String name, byte[] value) throws IOException {
        writer.name(name);
        if (value != null) {
            writer.value(Base64.getEncoder().encodeToString(value));
        } else {
            writer.nullValue();
        }
    }

    public static void writeNullValue(JsonWriter writer, String name) throws IOException {
        writer.name(name);
        writer.nullValue();
    }
}

