/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.text;

import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class LocaleText {
    private static final boolean ENGIN_MODE = false;
    private static final Locale ENGIN_LOCALE = Locale.GERMANY;
    private static Locale fallbackLocale = null;
    private static final GsonBuilder builder = new GsonBuilder();
    private final Map<Locale, String> text = new HashMap<Locale, String>();

    static {
        builder.registerTypeAdapter(LocaleText.class, (Object)new TypeAdapter<LocaleText>(){

            public void write(JsonWriter out, LocaleText value) throws IOException {
                out.beginObject();
                for (Map.Entry<Locale, String> entry : value.text.entrySet()) {
                    out.name(entry.getKey().toString());
                    out.value(entry.getValue());
                }
                out.endObject();
            }

            public LocaleText read(JsonReader in) throws IOException {
                in.beginObject();
                LocaleText localeText = new LocaleText();
                while (in.hasNext()) {
                    String localeString = in.nextName();
                    String[] parts = localeString.split("_");
                    Locale locale = parts.length == 3 ? new Locale(parts[0], parts[1], parts[2]) : (parts.length == 2 ? new Locale(parts[0], parts[1]) : (parts.length == 1 ? new Locale(parts[0]) : null));
                    localeText.setText(locale, in.nextString());
                }
                in.endObject();
                return localeText;
            }
        });
    }

    public static Locale getFallbackLocale() {
        return fallbackLocale;
    }

    public static void setFallbackLocale(Locale fallbackLocale) {
        LocaleText.fallbackLocale = fallbackLocale;
    }

    public String getText(Locale locale) {
        String text = this.text.get(locale);
        return text;
    }

    public String getTextOrDefault() {
        return this.getTextOrDefault(Locale.getDefault());
    }

    public String getTextOrDefault(Locale locale) {
        Locale currentLocale = locale;
        boolean fallbackLocaleCecked = false;
        while (currentLocale != null) {
            String text = this.getText(currentLocale);
            if (text != null && !text.isEmpty()) {
                return text;
            }
            fallbackLocaleCecked |= fallbackLocale != null && fallbackLocale.equals(currentLocale);
            currentLocale = LocaleText.getParentLocale(currentLocale);
        }
        if (fallbackLocale != null && !fallbackLocaleCecked) {
            return this.getTextOrDefault(fallbackLocale);
        }
        return null;
    }

    private static Locale getParentLocale(Locale locale) {
        Locale retValue = null;
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (!"".equals(variant)) {
            retValue = new Locale(language, country);
        } else if (!"".equals(country)) {
            retValue = new Locale(language);
        } else if (!"".equals(language)) {
            retValue = null;
        }
        return retValue;
    }

    public void setText(Locale locale, String text) {
        this.text.put(locale, text);
    }

    public void removeText(Locale locale) {
        this.text.remove(locale);
    }

    public LocaleText copy() {
        LocaleText copy = new LocaleText();
        for (Map.Entry<Locale, String> entry : this.text.entrySet()) {
            copy.text.put(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    public String toJson() {
        return builder.create().toJson((Object)this);
    }

    public static LocaleText tryParse(String text) {
        return LocaleText.tryParse(Locale.getDefault(), text);
    }

    public static LocaleText tryParse(Locale defaultLocale, String text) {
        if (text == null || text.trim().isEmpty()) {
            LocaleText localeText = new LocaleText();
            localeText.setText(defaultLocale, text);
            return localeText;
        }
        try {
            return LocaleText.parse(text);
        }
        catch (Exception exception) {
            LocaleText localeText = new LocaleText();
            localeText.setText(defaultLocale, text);
            return localeText;
        }
    }

    public static LocaleText parse(String text) {
        return (LocaleText)builder.create().fromJson(text, LocaleText.class);
    }

    public String toString() {
        return this.toJson();
    }
}

