/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx;

import eu.hansolo.applefx.MacosCheckBoxSwitch;
import eu.hansolo.applefx.tools.MacosAccentColor;
import eu.hansolo.applefx.tools.MacosSystemColor;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class MacosCheckBoxSwitchSkin
extends SkinBase<MacosCheckBoxSwitch> {
    private static final double WIDTH = 38.0;
    private static final double HEIGHT = 21.0;
    private static final double THUMB_RADIUS = 9.0;
    private static final double THUMB_INSET = 1.5;
    private static final double THUMB_CENTER_Y = 10.5;
    private static final Duration DURATION = Duration.millis((double)250.0);
    private static final Duration HALF_DURATION = Duration.millis((double)125.0);
    private final MacosCheckBoxSwitch control;
    private final Timeline timeline;
    private Circle thumb;
    private Circle zero;
    private Rectangle one;
    private Pane pane;
    private EventHandler<MouseEvent> mouseHandler;
    private ChangeListener<Boolean> selectionListener;
    private ChangeListener<Color> bkgColorListener;
    private ChangeListener<MacosAccentColor> accentColorListener;
    private ChangeListener<Boolean> showDescriptionListener;

    public MacosCheckBoxSwitchSkin(MacosCheckBoxSwitch control) {
        super((Control)control);
        this.control = control;
        this.timeline = new Timeline();
        this.mouseHandler = e -> control.setSelected(!control.isSelected());
        this.selectionListener = (o, ov, nv) -> {
            if (nv.booleanValue()) {
                this.animateToSelected();
            } else {
                this.animateToDeselected();
            }
        };
        this.bkgColorListener = (o, ov, nv) -> this.pane.setStyle("-bkg-color: " + nv.toString().replace("0x", "#"));
        this.accentColorListener = (o, ov, nv) -> {
            if (control.isSelected()) {
                control.setBkgColor(control.isDark() ? nv.getColorDark() : nv.getColorAqua());
            }
        };
        this.showDescriptionListener = (o, ov, nv) -> {
            this.one.setVisible(nv.booleanValue());
            this.zero.setVisible(nv.booleanValue());
        };
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        this.control.setPrefSize(38.0, 21.0);
        this.thumb = new Circle(this.control.isSelected() ? 27.5 : 10.5, 10.5, 9.0);
        this.thumb.getStyleClass().setAll((Object[])new String[]{"switch-thumb"});
        this.thumb.toFront();
        this.thumb.setMouseTransparent(true);
        this.one = new Rectangle(7.0, 7.0, 0.7, 7.5);
        this.one.getStyleClass().addAll((Object[])new String[]{"switch-one"});
        this.one.setMouseTransparent(true);
        this.one.setVisible(this.control.getShowDescriptions());
        this.zero = new Circle(30.0, 10.75, 3.75);
        this.zero.getStyleClass().addAll((Object[])new String[]{"switch-zero"});
        this.zero.setMouseTransparent(true);
        this.zero.setVisible(this.control.getShowDescriptions());
        this.pane = new Pane();
        this.pane.setMinSize(38.0, 21.0);
        this.pane.setMaxSize(38.0, 21.0);
        this.pane.setPrefSize(38.0, 21.0);
        this.pane.getStyleClass().setAll((Object[])new String[]{"switch-background"});
        this.pane.getChildren().addAll((Object[])new Node[]{this.one, this.zero, this.thumb});
        this.getChildren().add((Object)this.pane);
    }

    private void registerListeners() {
        this.pane.addEventFilter(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
        this.control.selectedProperty().addListener(this.selectionListener);
        this.control.bkgColorProperty().addListener(this.bkgColorListener);
        this.control.accentColorProperty().addListener(this.accentColorListener);
        this.control.showDescriptionsProperty().addListener(this.showDescriptionListener);
    }

    private void animateToSelected() {
        KeyValue kvBackgroundFillStart = new KeyValue(this.control.bkgColorProperty(), (Object)(this.control.isDark() ? MacosSystemColor.CTRL_BACKGROUND.dark() : MacosSystemColor.CTRL_BACKGROUND.aqua()), Interpolator.EASE_BOTH);
        KeyValue kvBackgroundFillEnd = new KeyValue(this.control.bkgColorProperty(), (Object)(this.control.isDark() ? this.control.getAccentColor().getColorDark() : this.control.getAccentColor().getColorAqua()), Interpolator.EASE_BOTH);
        KeyValue kvThumbXStart = new KeyValue((WritableValue)this.thumb.centerXProperty(), (Object)10.5, Interpolator.EASE_BOTH);
        KeyValue kvThumbXEnd = new KeyValue((WritableValue)this.thumb.centerXProperty(), (Object)27.5, Interpolator.EASE_BOTH);
        KeyValue kvOneOpacityStart = new KeyValue((WritableValue)this.one.opacityProperty(), (Object)0, Interpolator.EASE_BOTH);
        KeyValue kvOneOpacityEnd = new KeyValue((WritableValue)this.one.opacityProperty(), (Object)1, Interpolator.EASE_BOTH);
        KeyValue kvZeroOpacityStart = new KeyValue((WritableValue)this.zero.opacityProperty(), (Object)this.zero.getOpacity(), Interpolator.EASE_BOTH);
        KeyValue kvZeroOpacityEnd = new KeyValue((WritableValue)this.zero.opacityProperty(), (Object)0, Interpolator.EASE_BOTH);
        KeyFrame kf0 = new KeyFrame(Duration.ZERO, new KeyValue[]{kvBackgroundFillStart, kvThumbXStart, kvOneOpacityStart, kvZeroOpacityStart});
        KeyFrame kf1 = new KeyFrame(HALF_DURATION, new KeyValue[]{kvZeroOpacityEnd});
        KeyFrame kf2 = new KeyFrame(DURATION, new KeyValue[]{kvBackgroundFillEnd, kvThumbXEnd, kvOneOpacityEnd});
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{kf0, kf1, kf2});
        this.timeline.play();
    }

    private void animateToDeselected() {
        KeyValue kvBackgroundFillStart = new KeyValue(this.control.bkgColorProperty(), (Object)(this.control.isDark() ? this.control.getAccentColor().getColorDark() : this.control.getAccentColor().getColorAqua()), Interpolator.EASE_BOTH);
        KeyValue kvBackgroundFillEnd = new KeyValue(this.control.bkgColorProperty(), (Object)(this.control.isDark() ? MacosSystemColor.CTRL_BACKGROUND.dark() : MacosSystemColor.CTRL_BACKGROUND.aqua()), Interpolator.EASE_BOTH);
        KeyValue kvThumbXStart = new KeyValue((WritableValue)this.thumb.centerXProperty(), (Object)27.5, Interpolator.EASE_BOTH);
        KeyValue kvThumbXEnd = new KeyValue((WritableValue)this.thumb.centerXProperty(), (Object)10.5, Interpolator.EASE_BOTH);
        KeyValue kvOneOpacityStart = new KeyValue((WritableValue)this.one.opacityProperty(), (Object)this.one.getOpacity(), Interpolator.EASE_BOTH);
        KeyValue kvOneOpacityEnd = new KeyValue((WritableValue)this.one.opacityProperty(), (Object)0, Interpolator.EASE_BOTH);
        KeyValue kvZeroOpacityStart = new KeyValue((WritableValue)this.zero.opacityProperty(), (Object)0, Interpolator.EASE_BOTH);
        KeyValue kvZeroOpacityEnd = new KeyValue((WritableValue)this.zero.opacityProperty(), (Object)1, Interpolator.EASE_BOTH);
        KeyFrame kf0 = new KeyFrame(Duration.ZERO, new KeyValue[]{kvBackgroundFillStart, kvThumbXStart, kvOneOpacityStart, kvZeroOpacityStart});
        KeyFrame kf1 = new KeyFrame(HALF_DURATION, new KeyValue[]{kvOneOpacityEnd});
        KeyFrame kf2 = new KeyFrame(DURATION, new KeyValue[]{kvBackgroundFillEnd, kvThumbXEnd, kvZeroOpacityEnd});
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{kf0, kf1, kf2});
        this.timeline.play();
    }

    public void dispose() {
        super.dispose();
        this.pane.removeEventFilter(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
        this.control.selectedProperty().removeListener(this.selectionListener);
        this.control.bkgColorProperty().removeListener(this.bkgColorListener);
        this.control.accentColorProperty().removeListener(this.accentColorListener);
        this.control.showDescriptionsProperty().removeListener(this.showDescriptionListener);
    }
}

