/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx;

import eu.hansolo.applefx.MacosComboBoxCell;
import eu.hansolo.applefx.MacosControlWithAccentColor;
import eu.hansolo.applefx.tools.Helper;
import eu.hansolo.applefx.tools.MacosAccentColor;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;

public class MacosComboBox<T>
extends ComboBox<T>
implements MacosControlWithAccentColor {
    private static final PseudoClass DARK_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dark");
    private BooleanBinding showing;
    private BooleanProperty dark;
    private ObjectProperty<MacosAccentColor> accentColor;

    public MacosComboBox() {
        this(FXCollections.observableArrayList());
    }

    public MacosComboBox(ObservableList<T> items) {
        super(items);
        this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, Helper.isDarkMode());
        this.init();
        this.registerListeners();
    }

    private void init() {
        this.dark = new BooleanPropertyBase(Helper.isDarkMode()){

            protected void invalidated() {
                MacosComboBox.this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this.get());
            }

            public Object getBean() {
                return MacosComboBox.this;
            }

            public String getName() {
                return "dark";
            }
        };
        this.accentColor = new ObjectPropertyBase<MacosAccentColor>(Helper.getMacosAccentColor()){

            protected void invalidated() {
                String style = MacosComboBox.this.isDark() ? "-accent-color-dark: " + ((MacosAccentColor)((Object)this.get())).getDarkStyleClass() + ";" + "-arrow-button-color: " + ((MacosAccentColor)((Object)this.get())).getDarkStyleClass() : "-accent-color: " + ((MacosAccentColor)((Object)this.get())).getAquaStyleClass() + ";" + "-arrow-button-color: " + ((MacosAccentColor)((Object)this.get())).getAquaStyleClass();
                MacosComboBox.this.setStyle(style);
            }

            public Object getBean() {
                return MacosComboBox.this;
            }

            public String getName() {
                return "accentColor";
            }
        };
        this.setCellFactory(param -> new MacosComboBoxCell(this));
        this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this.isDark());
    }

    private void registerListeners() {
        if (this.getScene() != null) {
            this.setupBinding();
        } else {
            this.sceneProperty().addListener((o1, ov1, nv1) -> {
                if (nv1 == null) {
                    return;
                }
                if (this.getScene().getWindow() != null) {
                    this.setupBinding();
                } else {
                    ((Scene)this.sceneProperty().get()).windowProperty().addListener((o2, ov2, nv2) -> {
                        if (nv2 == null) {
                            return;
                        }
                        this.setupBinding();
                    });
                }
            });
        }
    }

    private void setupBinding() {
        this.showing = Bindings.createBooleanBinding(() -> {
            if (this.getScene() != null && this.getScene().getWindow() != null) {
                return this.getScene().getWindow().isShowing();
            }
            return false;
        }, (Observable[])new Observable[]{this.sceneProperty(), this.getScene().windowProperty(), this.getScene().getWindow().showingProperty()});
        this.showing.addListener(o -> {
            if (this.showing.get()) {
                this.setStyle();
            }
        });
    }

    @Override
    public final boolean isDark() {
        return this.dark.get();
    }

    @Override
    public final void setDark(boolean dark) {
        this.dark.set(dark);
    }

    @Override
    public final BooleanProperty darkProperty() {
        return this.dark;
    }

    @Override
    public MacosAccentColor getAccentColor() {
        return (MacosAccentColor)((Object)this.accentColor.get());
    }

    @Override
    public void setAccentColor(MacosAccentColor accentColor) {
        this.accentColor.set((Object)accentColor);
    }

    @Override
    public ObjectProperty<MacosAccentColor> accentColorProperty() {
        return this.accentColor;
    }

    private void setStyle() {
        MacosAccentColor accentColor = this.getAccentColor();
        String style = this.isDark() ? "-accent-color-dark: " + accentColor.getDarkStyleClass() + ";" + "-arrow-button-color: " + accentColor.getDarkStyleClass() : "-accent-color: " + accentColor.getAquaStyleClass() + ";" + "-arrow-button-color: " + accentColor.getAquaStyleClass();
        this.setStyle(style);
    }

    public String getUserAgentStylesheet() {
        return MacosComboBox.class.getResource("apple.css").toExternalForm();
    }
}

