/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx;

import eu.hansolo.applefx.MacosControlWithAccentColor;
import eu.hansolo.applefx.tools.Helper;
import eu.hansolo.applefx.tools.MacosAccentColor;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.css.PseudoClass;
import javafx.scene.control.RadioButton;

public class MacosRadioButton
extends RadioButton
implements MacosControlWithAccentColor {
    private static final PseudoClass DARK_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dark");
    private boolean _dark;
    private BooleanProperty dark;
    private MacosAccentColor _accentColor;
    private ObjectProperty<MacosAccentColor> accentColor;

    public MacosRadioButton() {
        this.init();
    }

    public MacosRadioButton(String text) {
        super(text);
        this.init();
    }

    private void init() {
        this.getStyleClass().add((Object)"macos-radio-button");
        this._dark = Helper.isDarkMode();
        this._accentColor = Helper.getMacosAccentColor();
    }

    @Override
    public final boolean isDark() {
        return this.dark == null ? this._dark : this.dark.get();
    }

    @Override
    public final void setDark(boolean dark) {
        if (this.dark == null) {
            this._dark = dark;
            this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, dark);
        } else {
            this.dark.set(dark);
        }
    }

    @Override
    public final BooleanProperty darkProperty() {
        if (this.dark == null) {
            this.dark = new BooleanPropertyBase(){

                protected void invalidated() {
                    MacosRadioButton.this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this.get());
                }

                public Object getBean() {
                    return MacosRadioButton.this;
                }

                public String getName() {
                    return "dark";
                }
            };
        }
        return this.dark;
    }

    @Override
    public MacosAccentColor getAccentColor() {
        return this.accentColor == null ? this._accentColor : (MacosAccentColor)((Object)this.accentColor.get());
    }

    @Override
    public void setAccentColor(MacosAccentColor accentColor) {
        if (this.accentColor == null) {
            this._accentColor = accentColor;
            this.setStyle(this.isDark() ? "-dot-fill: " + accentColor.getDarkStyleClass() + ";" : "-dot-fill: " + accentColor.getAquaStyleClass() + ";");
        } else {
            this.accentColor.set((Object)accentColor);
        }
    }

    @Override
    public ObjectProperty<MacosAccentColor> accentColorProperty() {
        if (this.accentColor == null) {
            this.accentColor = new ObjectPropertyBase<MacosAccentColor>(this._accentColor){

                protected void invalidated() {
                    MacosRadioButton.this.setStyle(MacosRadioButton.this.isDark() ? "-dot-fill: " + ((MacosAccentColor)((Object)this.get())).getDarkStyleClass() + ";" : "-dot-fill: " + ((MacosAccentColor)((Object)this.get())).getAquaStyleClass() + ";");
                }

                public Object getBean() {
                    return MacosRadioButton.this;
                }

                public String getName() {
                    return "accentColor";
                }
            };
            this._accentColor = null;
        }
        return this.accentColor;
    }

    public String getUserAgentStylesheet() {
        return MacosRadioButton.class.getResource("apple.css").toExternalForm();
    }
}

