/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx;

import eu.hansolo.applefx.MacosControl;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.util.Duration;

public class MacosScrollPane
extends ScrollPane
implements MacosControl {
    private static final PseudoClass DARK_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dark");
    private boolean _dark;
    private BooleanProperty dark;
    private SequentialTransition fadeInSequence;
    private SequentialTransition fadeOutSequence;

    public MacosScrollPane() {
        this.init();
    }

    public MacosScrollPane(Node node) {
        super(node);
        this.init();
    }

    private void init() {
        this.getStyleClass().add((Object)"macos-scroll-pane");
        this._dark = false;
        this.fadeInSequence = new SequentialTransition();
        this.fadeOutSequence = new SequentialTransition();
        this.registerListeners();
    }

    private void registerListeners() {
        this.setOnScrollStarted(e -> this.fadeInScrollBars());
        this.setOnScrollFinished(e -> this.fadeOutScrollBars());
        this.getChildren().addListener(c -> {
            for (Node node : this.lookupAll(".scroll-bar")) {
                if (!(node instanceof ScrollBar)) continue;
                ScrollBar scrollBar = (ScrollBar)node;
                scrollBar.setOpacity(0.0);
            }
        });
    }

    @Override
    public final boolean isDark() {
        return this.dark == null ? this._dark : this.dark.get();
    }

    @Override
    public final void setDark(boolean dark) {
        if (this.dark == null) {
            this._dark = dark;
            this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, dark);
        } else {
            this.dark.set(dark);
        }
    }

    @Override
    public final BooleanProperty darkProperty() {
        if (this.dark == null) {
            this.dark = new BooleanPropertyBase(){

                protected void invalidated() {
                    MacosScrollPane.this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this.get());
                }

                public Object getBean() {
                    return MacosScrollPane.this;
                }

                public String getName() {
                    return "dark";
                }
            };
        }
        return this.dark;
    }

    private void fadeInScrollBars() {
        this.fadeInSequence.stop();
        for (Node node : this.lookupAll(".scroll-bar")) {
            if (!(node instanceof ScrollBar)) continue;
            ScrollBar scrollBar = (ScrollBar)node;
            FadeTransition fadeIn = new FadeTransition(Duration.millis((double)300.0));
            fadeIn.setFromValue(0.0);
            fadeIn.setToValue(1.0);
            fadeIn.setNode((Node)scrollBar);
            this.fadeInSequence.setNode((Node)scrollBar);
            this.fadeInSequence.getChildren().setAll((Object[])new Animation[]{fadeIn});
            this.fadeInSequence.play();
        }
    }

    private void fadeOutScrollBars() {
        this.fadeOutSequence.stop();
        for (Node node : this.lookupAll(".scroll-bar")) {
            if (!(node instanceof ScrollBar)) continue;
            ScrollBar scrollBar = (ScrollBar)node;
            FadeTransition fadeOut = new FadeTransition(Duration.millis((double)300.0));
            fadeOut.setFromValue(1.0);
            fadeOut.setToValue(0.0);
            fadeOut.setNode((Node)scrollBar);
            this.fadeOutSequence.setNode((Node)scrollBar);
            this.fadeOutSequence.getChildren().setAll((Object[])new Animation[]{new PauseTransition(Duration.millis((double)1000.0)), fadeOut});
            this.fadeOutSequence.play();
        }
    }

    public String getUserAgentStylesheet() {
        return MacosScrollPane.class.getResource("apple.css").toExternalForm();
    }
}

