/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx;

import eu.hansolo.applefx.MacosControlWithAccentColor;
import eu.hansolo.applefx.MacosSliderSkin;
import eu.hansolo.applefx.tools.Helper;
import eu.hansolo.applefx.tools.MacosAccentColor;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.css.PseudoClass;
import javafx.scene.control.Skin;
import javafx.scene.control.Slider;

public class MacosSlider
extends Slider
implements MacosControlWithAccentColor {
    private static final PseudoClass BALANCE_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"balance");
    private static final PseudoClass DARK_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dark");
    private BooleanProperty balance = new BooleanPropertyBase(false){

        protected void invalidated() {
            MacosSlider.this.pseudoClassStateChanged(BALANCE_PSEUDO_CLASS, this.get());
        }

        public Object getBean() {
            return MacosSlider.this;
        }

        public String getName() {
            return "balance";
        }
    };
    private BooleanProperty dark;
    private ObjectProperty<MacosAccentColor> accentColor;

    public MacosSlider() {
        this.init();
    }

    public MacosSlider(double min, double max, double value) {
        super(min, max, value);
        this.init();
    }

    private void init() {
        this.getStyleClass().add((Object)"macos-slider");
        this.dark = new BooleanPropertyBase(Helper.isDarkMode()){

            protected void invalidated() {
                MacosSlider.this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this.get());
            }

            public Object getBean() {
                return MacosSlider.this;
            }

            public String getName() {
                return "dark";
            }
        };
        this.accentColor = new ObjectPropertyBase<MacosAccentColor>(Helper.getMacosAccentColor()){

            protected void invalidated() {
                MacosSlider.this.setStyle("-track-progress-fill: " + (MacosSlider.this.isDark() ? ((MacosAccentColor)((Object)this.get())).getDarkStyleClass() : ((MacosAccentColor)((Object)this.get())).getAquaStyleClass()) + ";");
            }

            public Object getBean() {
                return MacosSlider.this;
            }

            public String getName() {
                return "accentColor";
            }
        };
        this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this.isDark());
    }

    public boolean getBalance() {
        return this.balance.get();
    }

    public void setBalance(boolean balance) {
        this.balance.set(balance);
    }

    public BooleanProperty balanceProperty() {
        return this.balance;
    }

    @Override
    public final boolean isDark() {
        return this.dark.get();
    }

    @Override
    public final void setDark(boolean dark) {
        this.dark.set(dark);
    }

    @Override
    public final BooleanProperty darkProperty() {
        return this.dark;
    }

    @Override
    public MacosAccentColor getAccentColor() {
        return (MacosAccentColor)((Object)this.accentColor.get());
    }

    @Override
    public void setAccentColor(MacosAccentColor accentColor) {
        this.accentColor.set((Object)accentColor);
    }

    @Override
    public ObjectProperty<MacosAccentColor> accentColorProperty() {
        return this.accentColor;
    }

    public void setWindowFocusLost(boolean windowFocusLost) {
        if (windowFocusLost) {
            this.setStyle(this.isDark() ? "-track-progress-fill: #6A6968;" : "-track-progress-fill: #D8D8D8;");
        } else {
            this.setStyle("-track-progress-fill: " + (this.isDark() ? this.getAccentColor().getDarkStyleClass() : this.getAccentColor().getAquaStyleClass()) + ";");
        }
    }

    public double getRange() {
        return this.getMax() - this.getMin();
    }

    public double getBalanceValue() {
        return this.getValue() - this.getRange() * 0.5;
    }

    protected Skin<?> createDefaultSkin() {
        return new MacosSliderSkin(this);
    }

    public String getUserAgentStylesheet() {
        return MacosSlider.class.getResource("apple.css").toExternalForm();
    }
}

