/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx;

import eu.hansolo.applefx.MacosSlider;
import eu.hansolo.toolbox.Helper;
import javafx.animation.Transition;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Side;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.chart.NumberAxis;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Slider;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Line;
import javafx.util.Duration;
import javafx.util.StringConverter;

public class MacosSliderSkin
extends SkinBase<MacosSlider> {
    private Slider slider;
    private NumberAxis tickLine = null;
    private double trackToTickGap = 2.0;
    private boolean showTickMarks;
    private double thumbWidth;
    private double thumbHeight;
    private double trackStart;
    private double trackLength;
    private double thumbTop;
    private double thumbLeft;
    private double preDragThumbPos;
    private Point2D dragStart;
    private StackPane thumb;
    private StackPane track;
    private StackPane trackProgress;
    private Line centerLine;
    private boolean trackClicked = false;
    private StringConverter<Number> stringConverterWrapper;

    public MacosSliderSkin(final MacosSlider slider) {
        super((Control)slider);
        this.slider = slider;
        this.init();
        slider.requestLayout();
        this.registerChangeListener((ObservableValue)slider.minProperty(), e -> {
            if (this.showTickMarks && this.tickLine != null) {
                this.tickLine.setLowerBound(slider.getMin());
            }
            slider.requestLayout();
        });
        this.registerChangeListener((ObservableValue)slider.maxProperty(), e -> {
            if (this.showTickMarks && this.tickLine != null) {
                this.tickLine.setUpperBound(slider.getMax());
            }
            slider.requestLayout();
        });
        this.registerChangeListener((ObservableValue)slider.valueProperty(), e -> this.positionThumb(this.trackClicked));
        this.registerChangeListener((ObservableValue)slider.orientationProperty(), e -> {
            if (this.showTickMarks && this.tickLine != null) {
                boolean isVertical;
                boolean bl = isVertical = slider.getOrientation() == Orientation.VERTICAL;
                this.tickLine.setSide(isVertical ? Side.RIGHT : (slider.getOrientation() == null ? Side.RIGHT : Side.BOTTOM));
            }
            slider.requestLayout();
        });
        this.registerChangeListener((ObservableValue)slider.showTickMarksProperty(), e -> this.setShowTickMarks(slider.isShowTickMarks(), slider.isShowTickLabels()));
        this.registerChangeListener((ObservableValue)slider.showTickLabelsProperty(), e -> this.setShowTickMarks(slider.isShowTickMarks(), slider.isShowTickLabels()));
        this.registerChangeListener((ObservableValue)slider.majorTickUnitProperty(), e -> {
            if (this.tickLine != null) {
                this.tickLine.setTickUnit(slider.getMajorTickUnit());
                slider.requestLayout();
            }
        });
        this.registerChangeListener((ObservableValue)slider.minorTickCountProperty(), e -> {
            if (this.tickLine != null) {
                this.tickLine.setMinorTickCount(Math.max(slider.getMinorTickCount(), 0) + 1);
                slider.requestLayout();
            }
        });
        this.registerChangeListener((ObservableValue)slider.labelFormatterProperty(), e -> {
            if (this.tickLine != null) {
                if (slider.getLabelFormatter() == null) {
                    this.tickLine.setTickLabelFormatter(null);
                } else {
                    this.tickLine.setTickLabelFormatter(this.stringConverterWrapper);
                    this.tickLine.requestAxisLayout();
                }
            }
        });
        this.registerChangeListener((ObservableValue)slider.snapToTicksProperty(), e -> slider.adjustValue(slider.getValue()));
        this.registerChangeListener((ObservableValue)slider.balanceProperty(), e -> {
            MacosSlider sldr = slider;
            boolean isBalance = sldr.getBalance();
            this.trackProgress.setVisible(!isBalance);
            this.centerLine.setVisible(isBalance);
            if (isBalance) {
                sldr.setValue(sldr.getRange() * 0.5);
            }
            Object var3_3 = null;
        });
        this.stringConverterWrapper = new StringConverter<Number>(){

            public String toString(Number object) {
                return object != null ? slider.getLabelFormatter().toString((Object)object.doubleValue()) : "";
            }

            public Number fromString(String string) {
                return (Number)slider.getLabelFormatter().fromString(string);
            }
        };
    }

    private void init() {
        this.thumb = new StackPane(){

            public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
                switch (attribute) {
                    case VALUE: {
                        return MacosSliderSkin.this.slider.getValue();
                    }
                }
                return super.queryAccessibleAttribute(attribute, parameters);
            }
        };
        this.thumb.getStyleClass().setAll((Object[])new String[]{"thumb"});
        this.thumb.setAccessibleRole(AccessibleRole.THUMB);
        this.centerLine = new Line();
        this.centerLine.getStyleClass().setAll((Object[])new String[]{"center-line"});
        this.track = new StackPane();
        this.track.getStyleClass().setAll((Object[])new String[]{"track"});
        this.trackProgress = new StackPane();
        this.trackProgress.getStyleClass().setAll((Object[])new String[]{"track-progress"});
        MacosSlider sldr = (MacosSlider)this.getSkinnable();
        boolean isBalance = sldr.getBalance();
        this.trackProgress.setVisible(!isBalance);
        if (isBalance) {
            sldr.setValue(sldr.getRange() * 0.5);
        }
        sldr = null;
        this.getChildren().setAll((Object[])new Node[]{this.track, this.centerLine, this.trackProgress, this.thumb});
        this.setShowTickMarks(this.slider.isShowTickMarks(), this.slider.isShowTickLabels());
        this.track.setOnMousePressed(me -> {
            if (!this.thumb.isPressed()) {
                this.trackClicked = true;
                if (this.slider.getOrientation() == Orientation.HORIZONTAL) {
                    this.trackPress((MouseEvent)me, me.getX() / this.trackLength);
                } else {
                    this.trackPress((MouseEvent)me, me.getY() / this.trackLength);
                }
                this.trackClicked = false;
            }
        });
        this.track.setOnMouseDragged(me -> {
            if (!this.thumb.isPressed()) {
                if (this.slider.getOrientation() == Orientation.HORIZONTAL) {
                    this.trackPress((MouseEvent)me, me.getX() / this.trackLength);
                } else {
                    this.trackPress((MouseEvent)me, me.getY() / this.trackLength);
                }
            }
        });
        this.thumb.setOnMousePressed(me -> {
            this.thumbPressed((MouseEvent)me, 0.0);
            this.dragStart = this.thumb.localToParent(me.getX(), me.getY());
            this.preDragThumbPos = (this.slider.getValue() - this.slider.getMin()) / (this.slider.getMax() - this.slider.getMin());
        });
        this.thumb.setOnMouseReleased(me -> this.thumbReleased((MouseEvent)me));
        this.thumb.setOnMouseDragged(me -> {
            Point2D cur = this.thumb.localToParent(me.getX(), me.getY());
            double dragPos = this.slider.getOrientation() == Orientation.HORIZONTAL ? cur.getX() - this.dragStart.getX() : -(cur.getY() - this.dragStart.getY());
            this.thumbDragged((MouseEvent)me, this.preDragThumbPos + dragPos / this.trackLength);
        });
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.slider.getOrientation() == Orientation.HORIZONTAL) {
            return leftInset + this.minTrackLength() + this.thumb.minWidth(-1.0) + rightInset;
        }
        return leftInset + this.thumb.prefWidth(-1.0) + rightInset;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.slider.getOrientation() == Orientation.HORIZONTAL) {
            double axisHeight = this.showTickMarks ? this.tickLine.prefHeight(-1.0) + this.trackToTickGap : 0.0;
            return topInset + this.thumb.prefHeight(-1.0) + axisHeight + bottomInset;
        }
        return topInset + this.minTrackLength() + this.thumb.prefHeight(-1.0) + bottomInset;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.slider.getOrientation() == Orientation.HORIZONTAL) {
            if (this.showTickMarks) {
                return Math.max(140.0, this.tickLine.prefWidth(-1.0));
            }
            return 140.0;
        }
        double axisWidth = this.showTickMarks ? this.tickLine.prefWidth(-1.0) + this.trackToTickGap : 0.0;
        return leftInset + Math.max(this.thumb.prefWidth(-1.0), this.track.prefWidth(-1.0)) + axisWidth + rightInset;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.slider.getOrientation() == Orientation.HORIZONTAL) {
            return topInset + Math.max(this.thumb.prefHeight(-1.0), this.track.prefHeight(-1.0)) + (this.showTickMarks ? this.trackToTickGap + this.tickLine.prefHeight(-1.0) : 0.0) + bottomInset;
        }
        if (this.showTickMarks) {
            return Math.max(140.0, this.tickLine.prefHeight(-1.0));
        }
        return 140.0;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.slider.getOrientation() == Orientation.HORIZONTAL) {
            return Double.MAX_VALUE;
        }
        return this.slider.prefWidth(-1.0);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.slider.getOrientation() == Orientation.HORIZONTAL) {
            return this.slider.prefHeight(width);
        }
        return Double.MAX_VALUE;
    }

    private void setShowTickMarks(boolean ticksVisible, boolean labelsVisible) {
        boolean bl = this.showTickMarks = ticksVisible || labelsVisible;
        if (this.showTickMarks) {
            if (this.tickLine == null) {
                this.tickLine = new NumberAxis();
                this.tickLine.setAutoRanging(false);
                this.tickLine.setSide(this.slider.getOrientation() == Orientation.VERTICAL ? Side.RIGHT : (this.slider.getOrientation() == null ? Side.RIGHT : Side.BOTTOM));
                this.tickLine.setUpperBound(this.slider.getMax());
                this.tickLine.setLowerBound(this.slider.getMin());
                this.tickLine.setTickUnit(this.slider.getMajorTickUnit());
                this.tickLine.setTickMarkVisible(ticksVisible);
                this.tickLine.setTickLabelsVisible(labelsVisible);
                this.tickLine.setMinorTickVisible(ticksVisible);
                this.tickLine.setMinorTickCount(Math.max(this.slider.getMinorTickCount(), 0) + 1);
                if (this.slider.getLabelFormatter() != null) {
                    this.tickLine.setTickLabelFormatter(this.stringConverterWrapper);
                }
                this.getChildren().setAll((Object[])new Node[]{this.tickLine, this.track, this.centerLine, this.trackProgress, this.thumb});
            } else {
                this.tickLine.setTickLabelsVisible(labelsVisible);
                this.tickLine.setTickMarkVisible(ticksVisible);
                this.tickLine.setMinorTickVisible(ticksVisible);
            }
        } else {
            this.getChildren().setAll((Object[])new Node[]{this.track, this.centerLine, this.trackProgress, this.thumb});
        }
        this.slider.requestLayout();
    }

    private void positionThumb(boolean animate) {
        double END_Y;
        if (this.slider.getValue() > this.slider.getMax()) {
            return;
        }
        boolean HORIZONTAL = this.slider.getOrientation() == Orientation.HORIZONTAL;
        final double END_X = HORIZONTAL ? this.trackStart + (this.trackLength * ((this.slider.getValue() - this.slider.getMin()) / (this.slider.getMax() - this.slider.getMin())) - this.thumbWidth / 2.0) : this.thumbLeft;
        double d = END_Y = HORIZONTAL ? this.thumbTop : this.snappedTopInset() + this.trackLength - this.trackLength * ((this.slider.getValue() - this.slider.getMin()) / (this.slider.getMax() - this.slider.getMin()));
        if (animate) {
            final double START_X = this.thumb.getLayoutX();
            final double START_Y = this.thumb.getLayoutY();
            Transition transition = new Transition(){
                {
                    this.setCycleDuration(Duration.millis((double)200.0));
                }

                protected void interpolate(double frac) {
                    if (!Double.isNaN(START_X)) {
                        MacosSliderSkin.this.thumb.setLayoutX(START_X + frac * (END_X - START_X));
                    }
                    if (!Double.isNaN(START_Y)) {
                        MacosSliderSkin.this.thumb.setLayoutY(START_Y + frac * (END_Y - START_Y));
                    }
                }
            };
            transition.play();
        } else {
            this.thumb.setLayoutX(END_X);
            this.thumb.setLayoutY(END_Y);
        }
    }

    private double minTrackLength() {
        return 2.0 * this.thumb.prefWidth(-1.0);
    }

    public void trackPress(MouseEvent e, double position) {
        if (!this.slider.isFocused()) {
            this.slider.requestFocus();
        }
        if (this.slider.getOrientation().equals((Object)Orientation.HORIZONTAL)) {
            this.slider.adjustValue(position * (this.slider.getMax() - this.slider.getMin()) + this.slider.getMin());
        } else {
            this.slider.adjustValue((1.0 - position) * (this.slider.getMax() - this.slider.getMin()) + this.slider.getMin());
        }
    }

    public void thumbPressed(MouseEvent e, double position) {
        if (!this.slider.isFocused()) {
            this.slider.requestFocus();
        }
        this.slider.setValueChanging(true);
    }

    public void thumbDragged(MouseEvent e, double position) {
        this.slider.setValue(Helper.clamp((double)this.slider.getMin(), (double)(position * (this.slider.getMax() - this.slider.getMin()) + this.slider.getMin()), (double)this.slider.getMax()));
    }

    public void thumbReleased(MouseEvent e) {
        this.slider.setValueChanging(false);
        this.slider.adjustValue(this.slider.getValue());
    }

    protected void layoutChildren(double X, double Y, double W, double H) {
        double value = this.slider.getValue();
        double range = Math.abs(this.slider.getMax() - this.slider.getMin());
        double trackRadius = this.track.getBackground() == null ? 0.0 : (this.track.getBackground().getFills().size() > 0 ? ((BackgroundFill)this.track.getBackground().getFills().get(0)).getRadii().getTopLeftHorizontalRadius() : 0.0);
        this.trackProgress.setVisible(!this.slider.isShowTickMarks());
        if (this.slider.getOrientation() == Orientation.HORIZONTAL) {
            this.thumbWidth = this.slider.isShowTickMarks() ? 9.0 : 20.5;
            this.thumbHeight = 20.5;
            this.thumb.resize(this.thumbWidth, this.thumbHeight);
            double tickLineHeight = this.showTickMarks ? this.tickLine.prefHeight(-1.0) : 0.0;
            double trackHeight = this.snapSizeY(this.track.prefHeight(-1.0));
            double trackAreaHeight = Math.max(trackHeight, this.thumbHeight);
            double totalHeightNeeded = trackAreaHeight + (this.showTickMarks ? this.trackToTickGap + tickLineHeight : 0.0);
            double startY = Y + (H - totalHeightNeeded) / 2.0;
            double trackTop = (int)(startY + (trackAreaHeight - trackHeight) / 2.0);
            this.trackLength = this.snapSizeX(W - this.thumbWidth);
            this.trackStart = this.snapPositionX(X + this.thumbWidth / 2.0);
            this.thumbTop = (int)(startY + (trackAreaHeight - this.thumbHeight) / 2.0);
            this.positionThumb(false);
            this.track.resizeRelocate((double)((int)(this.trackStart - trackRadius)), trackTop, (double)((int)(this.trackLength + trackRadius + trackRadius)), trackHeight);
            this.centerLine.setStartX(W * 0.5);
            this.centerLine.setStartY(H * 0.5 - 3.0);
            this.centerLine.setEndX(W * 0.5);
            this.centerLine.setEndY(H * 0.5 + 3.0);
            this.trackProgress.resizeRelocate((double)((int)(this.trackStart - trackRadius)), trackTop, (double)((int)(this.trackLength * (value / range) + trackRadius + trackRadius)), trackHeight);
            if (this.showTickMarks) {
                this.tickLine.setLayoutX(this.trackStart);
                this.tickLine.setLayoutY(this.snapPositionY(trackTop + trackHeight * 0.5 - tickLineHeight * 0.5 + 1.0));
                this.tickLine.resize(this.trackLength, tickLineHeight);
                this.tickLine.requestAxisLayout();
            } else {
                if (this.tickLine != null) {
                    this.tickLine.resize(0.0, 0.0);
                    this.tickLine.requestAxisLayout();
                }
                this.tickLine = null;
            }
        } else {
            this.thumbWidth = 20.0;
            this.thumbHeight = 8.0;
            this.thumb.resize(this.thumbWidth, this.thumbHeight);
            double tickLineWidth = this.showTickMarks ? this.tickLine.prefWidth(-1.0) : 0.0;
            double trackWidth = this.snapSizeX(this.track.prefWidth(-1.0));
            double trackAreaWidth = Math.max(trackWidth, this.thumbWidth);
            double totalWidthNeeded = trackAreaWidth + (this.showTickMarks ? this.trackToTickGap + tickLineWidth : 0.0);
            double startX = X + (W - totalWidthNeeded) / 2.0;
            double trackLeft = (int)(startX + (trackAreaWidth - trackWidth) / 2.0);
            this.trackLength = this.snapSizeY(H - this.thumbHeight);
            this.trackStart = this.snapPositionY(Y + this.thumbHeight / 2.0);
            this.thumbLeft = (int)(startX + (trackAreaWidth - this.thumbWidth) / 2.0);
            this.positionThumb(false);
            this.track.resizeRelocate(trackLeft, (double)((int)(this.trackStart - trackRadius)), trackWidth, (double)((int)(this.trackLength + trackRadius + trackRadius)));
            this.centerLine.setStartX(W * 0.5 - 3.0);
            this.centerLine.setStartY(H * 0.5);
            this.centerLine.setEndX(W * 0.5 + 3.0);
            this.centerLine.setEndY(H * 0.5);
            this.trackProgress.resizeRelocate(trackLeft, (double)((int)(this.trackStart - trackRadius)), trackWidth, (double)((int)(this.trackLength * (value / range) + trackRadius + trackRadius)));
            if (this.showTickMarks) {
                this.tickLine.setLayoutX(trackLeft + trackWidth + this.trackToTickGap);
                this.tickLine.setLayoutY(this.trackStart);
                this.tickLine.resize(tickLineWidth, this.trackLength);
                this.tickLine.requestAxisLayout();
            } else {
                if (this.tickLine != null) {
                    this.tickLine.resize(0.0, 0.0);
                    this.tickLine.requestAxisLayout();
                }
                this.tickLine = null;
            }
        }
    }
}

