/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx;

import eu.hansolo.applefx.MacosControl;
import eu.hansolo.applefx.tools.Helper;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public class MacosToggleButton
extends ToggleButton
implements MacosControl {
    private static final PseudoClass DARK_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dark");
    private boolean _dark;
    private BooleanProperty dark;
    private BooleanBinding showing;

    public MacosToggleButton() {
        this.init();
    }

    public MacosToggleButton(String text) {
        super(text);
        this.init();
    }

    public MacosToggleButton(String text, Node graphic) {
        super(text, graphic);
        this.init();
    }

    private void init() {
        this.getStyleClass().add((Object)"macos-toggle-button");
        this._dark = Helper.isDarkMode();
        this.registerListener();
    }

    private void registerListener() {
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> {
            if (this.isSelected()) {
                e.consume();
            }
        });
        if (this.getScene() != null) {
            this.setupBinding();
        } else {
            this.sceneProperty().addListener((o1, ov1, nv1) -> {
                if (nv1 == null) {
                    return;
                }
                if (this.getScene().getWindow() != null) {
                    this.setupBinding();
                } else {
                    ((Scene)this.sceneProperty().get()).windowProperty().addListener((o2, ov2, nv2) -> {
                        if (nv2 == null) {
                            return;
                        }
                        this.setupBinding();
                    });
                }
            });
        }
    }

    private void setupBinding() {
        this.showing = Bindings.createBooleanBinding(() -> {
            if (this.getScene() != null && this.getScene().getWindow() != null) {
                return this.getScene().getWindow().isShowing();
            }
            return false;
        }, (Observable[])new Observable[]{this.sceneProperty(), this.getScene().windowProperty(), this.getScene().getWindow().showingProperty()});
        this.showing.addListener(o -> {
            if (this.showing.get()) {
                this.getScene().getWindow().addEventFilter(KeyEvent.KEY_PRESSED, e -> {
                    if (e.getCode().equals((Object)KeyCode.SPACE) && this.isSelected()) {
                        e.consume();
                    }
                });
            }
        });
    }

    @Override
    public final boolean isDark() {
        return this.dark == null ? this._dark : this.dark.get();
    }

    @Override
    public final void setDark(boolean dark) {
        if (this.dark == null) {
            this._dark = dark;
            this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, dark);
        } else {
            this.dark.set(dark);
        }
    }

    @Override
    public final BooleanProperty darkProperty() {
        if (this.dark == null) {
            this.dark = new BooleanPropertyBase(){

                protected void invalidated() {
                    MacosToggleButton.this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this.get());
                }

                public Object getBean() {
                    return MacosToggleButton.this;
                }

                public String getName() {
                    return "dark";
                }
            };
        }
        return this.dark;
    }

    public String getUserAgentStylesheet() {
        return MacosToggleButton.class.getResource("apple.css").toExternalForm();
    }
}

