/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx;

import eu.hansolo.applefx.MacosControl;
import eu.hansolo.applefx.MacosToggleButton;
import eu.hansolo.applefx.MacosToggleButtonBarSeparator;
import eu.hansolo.applefx.tools.Helper;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.layout.HBox;

public class MacosToggleButtonBar
extends HBox
implements MacosControl {
    private static final PseudoClass DARK_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dark");
    private boolean _dark;
    private BooleanProperty dark;
    private InvalidationListener selectionListener;

    public MacosToggleButtonBar() {
        this(1.0, new Node[0]);
    }

    public MacosToggleButtonBar(double spacing) {
        this(1.0, new Node[0]);
    }

    public MacosToggleButtonBar(Node ... toggleButtons) {
        this(1.0, toggleButtons);
    }

    public MacosToggleButtonBar(double spacing, Node ... toggleButtons) {
        super(spacing, toggleButtons);
        this.init();
    }

    private void init() {
        this.setSpacing(1.0);
        this.getStyleClass().add((Object)"macos-toggle-button-bar");
        this._dark = Helper.isDarkMode();
        this.selectionListener = e -> this.setSeparatorVisibilities();
        this.registerListeners();
        this.setSeparatorVisibilities();
    }

    private void registerListeners() {
        this.getChildren().forEach(n -> {
            if (n instanceof MacosToggleButton) {
                MacosToggleButton macosToggleButton = (MacosToggleButton)n;
                macosToggleButton.selectedProperty().addListener(this.selectionListener);
            }
        });
        this.getChildren().addListener(c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(n -> {
                        if (n instanceof MacosToggleButton) {
                            MacosToggleButton macosToggleButton = (MacosToggleButton)n;
                            macosToggleButton.selectedProperty().addListener(this.selectionListener);
                        }
                    });
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(n -> {
                    if (n instanceof MacosToggleButton) {
                        MacosToggleButton macosToggleButton = (MacosToggleButton)n;
                        macosToggleButton.selectedProperty().removeListener(this.selectionListener);
                    }
                });
            }
        });
    }

    private void setSeparatorVisibilities() {
        int size = this.getChildren().size();
        boolean wasSelected = false;
        int i = 0;
        while (i < this.getChildren().size()) {
            Node node = (Node)this.getChildren().get(i);
            boolean isMacosToggleButton = node instanceof MacosToggleButton;
            if (isMacosToggleButton && size > 0) {
                Node lastNode;
                MacosToggleButton toggleButton = (MacosToggleButton)node;
                boolean isSelected = toggleButton.isSelected();
                if (i == 0) {
                    Node nextNode = (Node)this.getChildren().get(i + 1);
                    if (nextNode instanceof MacosToggleButtonBarSeparator) {
                        nextNode.setVisible(!isSelected);
                    }
                } else if (i < size - 1) {
                    Node nextNode;
                    lastNode = (Node)this.getChildren().get(i - 1);
                    if (lastNode instanceof MacosToggleButtonBarSeparator) {
                        if (isSelected) {
                            lastNode.setVisible(false);
                        } else {
                            lastNode.setVisible(!wasSelected);
                        }
                    }
                    if ((nextNode = (Node)this.getChildren().get(i + 1)) instanceof MacosToggleButtonBarSeparator) {
                        nextNode.setVisible(!isSelected);
                    }
                } else if (size - 1 == i && (lastNode = (Node)this.getChildren().get(i - 1)) instanceof MacosToggleButtonBarSeparator) {
                    if (isSelected) {
                        lastNode.setVisible(false);
                    } else {
                        lastNode.setVisible(!wasSelected);
                    }
                }
                wasSelected = isSelected;
            }
            ++i;
        }
    }

    @Override
    public final boolean isDark() {
        return this.dark == null ? this._dark : this.dark.get();
    }

    @Override
    public final void setDark(boolean dark) {
        if (this.dark == null) {
            this._dark = dark;
            this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, dark);
        } else {
            this.dark.set(dark);
        }
    }

    @Override
    public final BooleanProperty darkProperty() {
        if (this.dark == null) {
            this.dark = new BooleanPropertyBase(){

                protected void invalidated() {
                    MacosToggleButtonBar.this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this.get());
                }

                public Object getBean() {
                    return MacosToggleButtonBar.this;
                }

                public String getName() {
                    return "dark";
                }
            };
        }
        return this.dark;
    }

    public String getUserAgentStylesheet() {
        return MacosToggleButtonBar.class.getResource("apple.css").toExternalForm();
    }
}

