/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx;

import eu.hansolo.applefx.MacosButton;
import eu.hansolo.applefx.MacosControl;
import eu.hansolo.applefx.tools.Helper;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.Region;

public class MacosToolbarButton
extends Button
implements MacosControl {
    private static final PseudoClass DARK_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dark");
    private boolean _dark;
    private BooleanProperty dark;
    private String svgPath;
    private Region icon;

    public MacosToolbarButton() {
        this("");
    }

    public MacosToolbarButton(String svgPath) {
        super(null);
        this.svgPath = svgPath;
        this.init();
    }

    private void init() {
        this.getStyleClass().add((Object)"macos-toolbar-button");
        this.icon = new Region();
        this.icon.getStyleClass().addAll((Object[])new String[]{"macos-toolbar-button", "icon"});
        if (this.svgPath != null && !this.svgPath.isEmpty()) {
            this.icon.setStyle("-shape: \"" + this.svgPath + "\";");
        }
        this.setGraphic((Node)this.icon);
        this._dark = Helper.isDarkMode();
        this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this._dark);
        this.registerListeners();
    }

    private void registerListeners() {
        this.graphicProperty().addListener((o, ov, nv) -> {
            if (nv instanceof Region) {
                nv.getStyleClass().addAll((Object[])new String[]{"macos-toolbar-button", "icon"});
            } else {
                this.setGraphic(null);
            }
        });
    }

    @Override
    public final boolean isDark() {
        return this.dark == null ? this._dark : this.dark.get();
    }

    @Override
    public final void setDark(boolean dark) {
        if (this.dark == null) {
            this._dark = dark;
            this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, dark);
        } else {
            this.dark.set(dark);
        }
    }

    @Override
    public final BooleanProperty darkProperty() {
        if (this.dark == null) {
            this.dark = new BooleanPropertyBase(){

                protected void invalidated() {
                    MacosToolbarButton.this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this.get());
                }

                public Object getBean() {
                    return MacosToolbarButton.this;
                }

                public String getName() {
                    return "dark";
                }
            };
        }
        return this.dark;
    }

    public void setSvgPath(String svgPath) {
        if (svgPath != null && !svgPath.isEmpty()) {
            this.icon.setStyle("-shape: \"" + svgPath + "\";");
        }
    }

    public String getUserAgentStylesheet() {
        return MacosButton.class.getResource("apple.css").toExternalForm();
    }
}

