/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx.tools;

import eu.hansolo.applefx.tools.MacosAccentColor;
import eu.hansolo.applefx.tools.MacosSystemColor;
import eu.hansolo.jdktools.OperatingSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.paint.Color;

public class Helper {
    public static boolean jproMode = false;
    public static final Map<Integer, Color[]> MACOS_ACCENT_COLOR_MAP = Map.of(-1, new Color[]{MacosSystemColor.GRAPHITE.aqua, MacosSystemColor.GRAPHITE.dark}, 0, new Color[]{MacosSystemColor.RED.aqua, MacosSystemColor.RED.dark}, 1, new Color[]{MacosSystemColor.ORANGE.aqua, MacosSystemColor.ORANGE.dark}, 2, new Color[]{MacosSystemColor.YELLOW.aqua, MacosSystemColor.YELLOW.dark}, 3, new Color[]{MacosSystemColor.GREEN.aqua, MacosSystemColor.GREEN.dark}, 4, new Color[]{MacosSystemColor.BLUE.aqua, MacosSystemColor.BLUE.dark}, 5, new Color[]{MacosSystemColor.PURPLE.aqua, MacosSystemColor.PURPLE.dark}, 6, new Color[]{MacosSystemColor.PINK.aqua, MacosSystemColor.PINK.dark});
    private static final String REGQUERY_UTIL = "reg query ";
    private static final String REGDWORD_TOKEN = "REG_DWORD";
    private static final String DARK_THEME_CMD = "reg query \"HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize\" /v AppsUseLightTheme";

    private Helper() {
    }

    public static final void enableNode(Node node, boolean enable) {
        node.setVisible(enable);
        node.setManaged(enable);
    }

    public static final <T, U> HashMap copy(HashMap<T, U> original) {
        HashMap copy = new HashMap();
        original.entrySet().forEach(entry -> {
            Object v = copy.put(entry.getKey(), entry.getValue());
        });
        return copy;
    }

    public static final double clamp(double min, double max, double value) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static final boolean isDarkMode() {
        if (jproMode) {
            return false;
        }
        switch (eu.hansolo.jdktools.util.Helper.getOperatingSystem()) {
            case WINDOWS: {
                return Helper.isWindowsDarkMode();
            }
            case MACOS: {
                return Helper.isMacOsDarkMode();
            }
        }
        return false;
    }

    private static final boolean isMacOsDarkMode() {
        try {
            String line;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("defaults read -g AppleInterfaceStyle");
            InputStreamReader isr = new InputStreamReader(process.getInputStream());
            BufferedReader rdr = new BufferedReader(isr);
            boolean isDarkMode = false;
            while ((line = rdr.readLine()) != null) {
                if (!line.equals("Dark")) continue;
                isDarkMode = true;
            }
            int rc = process.waitFor();
            return rc == 0 && isDarkMode;
        }
        catch (IOException | InterruptedException exception) {
            return false;
        }
    }

    private static final boolean isWindowsDarkMode() {
        int p;
        String result;
        block3: {
            try {
                Process process = Runtime.getRuntime().exec(DARK_THEME_CMD);
                StreamReader reader = new StreamReader(process.getInputStream());
                reader.start();
                process.waitFor();
                reader.join();
                result = reader.getResult();
                p = result.indexOf(REGDWORD_TOKEN);
                if (p != -1) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        String temp = result.substring(p + REGDWORD_TOKEN.length()).trim();
        return Integer.parseInt(temp.substring("0x".length()), 16) == 0;
    }

    public static final MacosAccentColor getMacosAccentColor() {
        if (jproMode || OperatingSystem.MACOS != eu.hansolo.jdktools.util.Helper.getOperatingSystem()) {
            return MacosAccentColor.MULTI_COLOR;
        }
        Helper.isMacOsDarkMode();
        try {
            String line;
            Integer colorKey = null;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("defaults read -g AppleAccentColor");
            InputStreamReader isr = new InputStreamReader(process.getInputStream());
            BufferedReader rdr = new BufferedReader(isr);
            while ((line = rdr.readLine()) != null) {
                colorKey = Integer.valueOf(line);
            }
            int rc = process.waitFor();
            if (rc == 0) {
                Integer key = colorKey;
                return MacosAccentColor.getAsList().stream().filter(macOSAccentColor -> macOSAccentColor.key == key).findFirst().orElse(MacosAccentColor.MULTI_COLOR);
            }
            return MacosAccentColor.MULTI_COLOR;
        }
        catch (IOException | InterruptedException exception) {
            return MacosAccentColor.MULTI_COLOR;
        }
    }

    public static final Color getMacosAccentColorAsColor() {
        if (OperatingSystem.MACOS != eu.hansolo.jdktools.util.Helper.getOperatingSystem()) {
            return MacosAccentColor.MULTI_COLOR.getColorAqua();
        }
        boolean isDarkMode = Helper.isMacOsDarkMode();
        try {
            String line;
            Integer colorKey = null;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("defaults read -g AppleAccentColor");
            InputStreamReader isr = new InputStreamReader(process.getInputStream());
            BufferedReader rdr = new BufferedReader(isr);
            while ((line = rdr.readLine()) != null) {
                colorKey = Integer.valueOf(line);
            }
            int rc = process.waitFor();
            if (rc == 0) {
                return isDarkMode ? MACOS_ACCENT_COLOR_MAP.get(colorKey)[1] : MACOS_ACCENT_COLOR_MAP.get(colorKey)[0];
            }
            return isDarkMode ? MACOS_ACCENT_COLOR_MAP.get(4)[1] : MACOS_ACCENT_COLOR_MAP.get(4)[0];
        }
        catch (IOException | InterruptedException exception) {
            return isDarkMode ? MACOS_ACCENT_COLOR_MAP.get(4)[1] : MACOS_ACCENT_COLOR_MAP.get(4)[0];
        }
    }

    public static final List<Node> getAllNodes(Parent root) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Helper.addAllDescendents(root, nodes);
        return nodes;
    }

    private static final void addAllDescendents(Parent parent, List<Node> nodes) {
        for (Node node : parent.getChildrenUnmodifiable()) {
            nodes.add(node);
            if (!(node instanceof Parent)) continue;
            Helper.addAllDescendents((Parent)node, nodes);
        }
    }

    static class StreamReader
    extends Thread {
        private final InputStream is;
        private final StringWriter sw;

        StreamReader(InputStream is) {
            this.is = is;
            this.sw = new StringWriter();
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException iOException) {}
        }

        String getResult() {
            return this.sw.toString();
        }
    }
}

