/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx.tools;

import eu.hansolo.applefx.tools.MacosSystemColor;
import eu.hansolo.toolboxfx.HelperFX;
import java.util.Arrays;
import java.util.List;
import javafx.scene.paint.Color;

public enum MacosAccentColor {
    MULTI_COLOR(null, MacosSystemColor.BLUE.aqua, Color.web((String)"#b3d7ff"), HelperFX.getColorWithOpacity((Color)MacosSystemColor.BLUE.aqua, (double)0.25), MacosSystemColor.BLUE.dark, Color.web((String)"#3f638b"), HelperFX.getColorWithOpacity((Color)MacosSystemColor.BLUE.dark, (double)0.25)),
    BLUE(4, MacosSystemColor.BLUE.aqua, Color.web((String)"#b3d7ff"), HelperFX.getColorWithOpacity((Color)MacosSystemColor.BLUE.aqua, (double)0.25), MacosSystemColor.BLUE.dark, Color.web((String)"#3f638b"), HelperFX.getColorWithOpacity((Color)MacosSystemColor.BLUE.dark, (double)0.25)),
    PURPLE(5, MacosSystemColor.PURPLE.aqua, Color.web((String)"#dfc5df"), HelperFX.getColorWithOpacity((Color)MacosSystemColor.PURPLE.aqua, (double)0.25), MacosSystemColor.PURPLE.dark, Color.web((String)"#6f566f"), HelperFX.getColorWithOpacity((Color)MacosSystemColor.PURPLE.dark, (double)0.25)),
    PINK(6, MacosSystemColor.PINK.aqua, Color.web((String)"#fccae2"), HelperFX.getColorWithOpacity((Color)MacosSystemColor.PINK.aqua, (double)0.25), MacosSystemColor.PINK.dark, Color.web((String)"#87566d"), HelperFX.getColorWithOpacity((Color)MacosSystemColor.PINK.dark, (double)0.25)),
    RED(0, MacosSystemColor.RED.aqua, Color.web((String)"#f5c3c5"), HelperFX.getColorWithOpacity((Color)MacosSystemColor.RED.aqua, (double)0.25), MacosSystemColor.RED.dark, Color.web((String)"#8b5758"), HelperFX.getColorWithOpacity((Color)MacosSystemColor.RED.dark, (double)0.25)),
    ORANGE(1, MacosSystemColor.ORANGE.aqua, Color.web((String)"#fcd9bb"), HelperFX.getColorWithOpacity((Color)MacosSystemColor.ORANGE.aqua, (double)0.25), MacosSystemColor.ORANGE.dark, Color.web((String)"#886547"), HelperFX.getColorWithOpacity((Color)MacosSystemColor.ORANGE.dark, (double)0.25)),
    YELLOW(2, MacosSystemColor.YELLOW.aqua, Color.web((String)"#feeebe"), HelperFX.getColorWithOpacity((Color)MacosSystemColor.YELLOW.aqua, (double)0.25), MacosSystemColor.YELLOW.dark, Color.web((String)"#8b7a40"), HelperFX.getColorWithOpacity((Color)MacosSystemColor.YELLOW.dark, (double)0.25)),
    GREEN(3, MacosSystemColor.GREEN.aqua, Color.web((String)"#d0eac7"), HelperFX.getColorWithOpacity((Color)MacosSystemColor.GREEN.aqua, (double)0.25), MacosSystemColor.GREEN.dark, Color.web((String)"#5c7653"), HelperFX.getColorWithOpacity((Color)MacosSystemColor.GREEN.dark, (double)0.25)),
    GRAPHITE(-1, MacosSystemColor.GRAPHITE.aqua, Color.web((String)"#e0e0e0"), HelperFX.getColorWithOpacity((Color)MacosSystemColor.GRAPHITE.aqua, (double)0.25), MacosSystemColor.GRAPHITE.dark, Color.web((String)"#696665"), HelperFX.getColorWithOpacity((Color)MacosSystemColor.GRAPHITE.dark, (double)0.25));

    final Integer key;
    final Color colorAqua;
    final Color colorAquaHighlight;
    final Color colorAquaFocus;
    final Color colorDark;
    final Color colorDarkHighlight;
    final Color colorDarkFocus;

    private MacosAccentColor(Integer key, Color colorAqua, Color colorAquaHighlight, Color colorAquaFocus, Color colorDark, Color colorDarkHighlight, Color colorDarkFocus) {
        this.key = key;
        this.colorAqua = colorAqua;
        this.colorAquaHighlight = colorAquaHighlight;
        this.colorAquaFocus = colorAquaFocus;
        this.colorDark = colorDark;
        this.colorDarkHighlight = colorDarkHighlight;
        this.colorDarkFocus = colorDarkFocus;
    }

    public Integer getKey() {
        return this.key;
    }

    public Color getColorAqua() {
        return this.colorAqua;
    }

    public Color getColorAquaHighlight() {
        return this.colorAquaHighlight;
    }

    public Color getColorAquaFocus() {
        return this.colorAquaFocus;
    }

    public Color getColorDark() {
        return this.colorDark;
    }

    public Color getColorDarkHighlight() {
        return this.colorDarkHighlight;
    }

    public Color getColorDarkFocus() {
        return this.colorDarkFocus;
    }

    public String getAquaStyleClass() {
        switch (this) {
            case MULTI_COLOR: {
                return "-BLUE-AQUA";
            }
        }
        return "-" + this.name() + "-AQUA";
    }

    public String getDarkStyleClass() {
        switch (this) {
            case MULTI_COLOR: {
                return "-BLUE-DARK";
            }
        }
        return "-" + this.name() + "-DARK";
    }

    public String getAquaHighlightStyleClass() {
        switch (this) {
            case MULTI_COLOR: {
                return "-BLUE-AQUA-HIGHLIGHT";
            }
        }
        return "-" + this.name() + "-AQUA-HIGHLIGHT";
    }

    public String getDarkHighlightStyleClass() {
        switch (this) {
            case MULTI_COLOR: {
                return "-BLUE-DARK-HIGHLIGHT";
            }
        }
        return "-" + this.name() + "-DARK-HIGHLIGHT";
    }

    public boolean isGivenColor(Color color) {
        return this.colorAqua.equals((Object)color) || this.colorDark.equals((Object)color);
    }

    public static final List<MacosAccentColor> getAsList() {
        return Arrays.asList(MacosAccentColor.values());
    }

    public static MacosAccentColor fromColor(Color color) {
        MacosAccentColor[] macosAccentColorArray = MacosAccentColor.values();
        int n = macosAccentColorArray.length;
        int n2 = 0;
        while (n2 < n) {
            MacosAccentColor accentColor = macosAccentColorArray[n2];
            if (accentColor.getColorAqua().equals((Object)color) || accentColor.getColorDark().equals((Object)color)) {
                return accentColor;
            }
            ++n2;
        }
        return BLUE;
    }
}

