/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx.tools;

import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;

public class ResizeHelper {
    public static void addResizeListener(Stage stage, double shadowOffset) {
        ResizeListener resizeListener = new ResizeListener(stage, shadowOffset);
        stage.getScene().addEventHandler(MouseEvent.MOUSE_MOVED, (EventHandler)resizeListener);
        stage.getScene().addEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)resizeListener);
        stage.getScene().addEventHandler(MouseEvent.MOUSE_DRAGGED, (EventHandler)resizeListener);
        stage.getScene().addEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)resizeListener);
        stage.getScene().addEventHandler(MouseEvent.MOUSE_EXITED_TARGET, (EventHandler)resizeListener);
        ObservableList children = stage.getScene().getRoot().getChildrenUnmodifiable();
        for (Node child : children) {
            ResizeHelper.addListenerDeeply(child, resizeListener);
        }
    }

    private static void addListenerDeeply(Node node, EventHandler<MouseEvent> listener) {
        node.addEventHandler(MouseEvent.MOUSE_MOVED, listener);
        node.addEventHandler(MouseEvent.MOUSE_PRESSED, listener);
        node.addEventHandler(MouseEvent.MOUSE_DRAGGED, listener);
        node.addEventHandler(MouseEvent.MOUSE_EXITED, listener);
        node.addEventHandler(MouseEvent.MOUSE_EXITED_TARGET, listener);
        if (node instanceof Parent) {
            Parent parent = (Parent)node;
            ObservableList children = parent.getChildrenUnmodifiable();
            for (Node child : children) {
                ResizeHelper.addListenerDeeply(child, listener);
            }
        }
    }

    private static class ResizeListener
    implements EventHandler<MouseEvent> {
        private Stage stage;
        private Cursor cursorEvent = Cursor.DEFAULT;
        private int border = 8;
        private double startX = 0.0;
        private double startY = 0.0;
        private double startScreenX = 0.0;
        private double startScreenY = 0.0;
        private double shadowOffset;

        public ResizeListener(Stage stage, double shadowOffset) {
            this.stage = stage;
            this.shadowOffset = shadowOffset;
        }

        public void handle(MouseEvent e) {
            EventType type = e.getEventType();
            Scene scene = this.stage.getScene();
            double mouseEventX = e.getSceneX();
            double mouseEventY = e.getSceneY();
            double sceneWidth = scene.getWidth() - 2.0 * this.shadowOffset;
            double sceneHeight = scene.getHeight() - 2.0 * this.shadowOffset;
            if (MouseEvent.MOUSE_MOVED.equals(type)) {
                this.cursorEvent = mouseEventX < (double)this.border && mouseEventY < (double)this.border ? Cursor.NW_RESIZE : (mouseEventX < (double)this.border && mouseEventY > sceneHeight - (double)this.border ? Cursor.SW_RESIZE : (mouseEventX > sceneWidth - (double)this.border && mouseEventY < (double)this.border ? Cursor.NE_RESIZE : (mouseEventX > sceneWidth - (double)this.border && mouseEventY > sceneHeight - (double)this.border ? Cursor.SE_RESIZE : (mouseEventX < (double)this.border ? Cursor.W_RESIZE : (mouseEventX > sceneWidth - (double)this.border ? Cursor.E_RESIZE : (mouseEventY < (double)this.border ? Cursor.N_RESIZE : (mouseEventY > sceneHeight - (double)this.border ? Cursor.S_RESIZE : Cursor.DEFAULT)))))));
                scene.setCursor(this.cursorEvent);
            } else if (MouseEvent.MOUSE_EXITED.equals(type) || MouseEvent.MOUSE_EXITED_TARGET.equals(type)) {
                scene.setCursor(Cursor.DEFAULT);
            } else if (MouseEvent.MOUSE_PRESSED.equals(type)) {
                this.startX = this.stage.getWidth() - mouseEventX;
                this.startY = this.stage.getHeight() - mouseEventY;
            } else if (MouseEvent.MOUSE_DRAGGED.equals(type) && !Cursor.DEFAULT.equals(this.cursorEvent)) {
                if (!Cursor.W_RESIZE.equals(this.cursorEvent) && !Cursor.E_RESIZE.equals(this.cursorEvent)) {
                    double minHeight = this.stage.getMinHeight() > (double)(this.border * 2) ? this.stage.getMinHeight() : (double)(this.border * 2);
                    double maxHeight = this.stage.getMaxHeight();
                    if (Cursor.NW_RESIZE.equals(this.cursorEvent) || Cursor.N_RESIZE.equals(this.cursorEvent) || Cursor.NE_RESIZE.equals(this.cursorEvent)) {
                        double newHeight = this.stage.getHeight() - (e.getScreenY() - this.stage.getY());
                        if (newHeight >= minHeight && newHeight <= maxHeight) {
                            this.stage.setHeight(newHeight);
                            this.stage.setY(e.getScreenY());
                        } else {
                            newHeight = Math.min(Math.max(newHeight, minHeight), maxHeight);
                            this.stage.setY(this.stage.getY() + this.stage.getHeight() - newHeight);
                            this.stage.setHeight(newHeight);
                        }
                    } else {
                        this.stage.setHeight(Math.min(Math.max(mouseEventY + this.startY, minHeight), maxHeight));
                    }
                }
                if (!Cursor.N_RESIZE.equals(this.cursorEvent) && !Cursor.S_RESIZE.equals(this.cursorEvent)) {
                    double minWidth = this.stage.getMinWidth() > (double)(this.border * 2) ? this.stage.getMinWidth() : (double)(this.border * 2);
                    double maxWidth = this.stage.getMaxWidth();
                    if (Cursor.NW_RESIZE.equals(this.cursorEvent) || Cursor.W_RESIZE.equals(this.cursorEvent) || Cursor.SW_RESIZE.equals(this.cursorEvent)) {
                        double newWidth = this.stage.getWidth() - (e.getScreenX() - this.stage.getX());
                        if (newWidth >= minWidth && newWidth <= maxWidth) {
                            this.stage.setWidth(newWidth);
                            this.stage.setX(e.getScreenX());
                        } else {
                            newWidth = Math.min(Math.max(newWidth, minWidth), maxWidth);
                            this.stage.setX(this.stage.getX() + this.stage.getWidth() - newWidth);
                            this.stage.setWidth(newWidth);
                        }
                    } else {
                        this.stage.setWidth(Math.min(Math.max(mouseEventX + this.startX, minWidth), maxWidth));
                    }
                }
            }
        }
    }
}

