/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.Axis;
import eu.hansolo.fx.charts.AxisType;
import eu.hansolo.fx.charts.Position;
import eu.hansolo.fx.charts.TickLabelOrientation;
import eu.hansolo.fx.charts.tools.TickLabelFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.paint.Color;
import javafx.util.StringConverter;

public class AxisBuilder<B extends AxisBuilder<B>> {
    private HashMap<String, Property> properties = new LinkedHashMap<String, Property>();
    private Orientation orientation;
    private Position position;

    protected AxisBuilder(Orientation ORIENTATION, Position POSITION) {
        this.orientation = ORIENTATION;
        this.position = POSITION;
    }

    public static final AxisBuilder create(Orientation ORIENTATION, Position POSITION) {
        return new AxisBuilder(ORIENTATION, POSITION);
    }

    public final B minValue(double MIN_VALUE) {
        this.properties.put("minValue", (Property)new SimpleDoubleProperty(MIN_VALUE));
        return (B)this;
    }

    public final B maxValue(double MAX_VALUE) {
        this.properties.put("maxValue", (Property)new SimpleDoubleProperty(MAX_VALUE));
        return (B)this;
    }

    public final B setStart(long EPOCH_SECONDS) {
        if (0L > EPOCH_SECONDS) {
            throw new IllegalArgumentException("Epoch seconds cannot be smaller than 0");
        }
        this.properties.put("start", (Property)new SimpleObjectProperty((Object)LocalDateTime.ofInstant(Instant.ofEpochSecond(EPOCH_SECONDS), ZoneId.systemDefault())));
        return (B)this;
    }

    public final B setStart(long EPOCH_SECONDS, ZoneId ZONE_ID) {
        if (0L > EPOCH_SECONDS || ZONE_ID == null) {
            throw new IllegalArgumentException("Epoch seconds cannot be smaller than 0 and zone id cannot be null");
        }
        this.properties.put("start", (Property)new SimpleObjectProperty((Object)LocalDateTime.ofInstant(Instant.ofEpochSecond(EPOCH_SECONDS), ZONE_ID)));
        return (B)this;
    }

    public final B setStart(Instant INSTANT) {
        if (INSTANT == null) {
            throw new IllegalArgumentException("Instant cannot be null");
        }
        this.properties.put("start", (Property)new SimpleObjectProperty((Object)LocalDateTime.ofInstant(INSTANT, ZoneId.systemDefault())));
        return (B)this;
    }

    public final B setStart(Instant INSTANT, ZoneId ZONE_ID) {
        if (INSTANT == null || ZONE_ID == null) {
            throw new IllegalArgumentException("Instant or zone id cannot be null");
        }
        this.properties.put("start", (Property)new SimpleObjectProperty((Object)LocalDateTime.ofInstant(INSTANT, ZONE_ID)));
        return (B)this;
    }

    public final B start(LocalDateTime DATE_TIME) {
        this.properties.put("start", (Property)new SimpleObjectProperty((Object)DATE_TIME));
        return (B)this;
    }

    public final B setEnd(long EPOCH_SECONDS) {
        if (0L > EPOCH_SECONDS) {
            throw new IllegalArgumentException("Epoch seconds cannot be smaller than 0");
        }
        this.properties.put("end", (Property)new SimpleObjectProperty((Object)LocalDateTime.ofInstant(Instant.ofEpochSecond(EPOCH_SECONDS), ZoneId.systemDefault())));
        return (B)this;
    }

    public final B setEnd(long EPOCH_SECONDS, ZoneId ZONE_ID) {
        if (0L > EPOCH_SECONDS || ZONE_ID == null) {
            throw new IllegalArgumentException("Epoch seconds cannot be smaller than 0 and zone id cannot be null");
        }
        this.properties.put("end", (Property)new SimpleObjectProperty((Object)LocalDateTime.ofInstant(Instant.ofEpochSecond(EPOCH_SECONDS), ZONE_ID)));
        return (B)this;
    }

    public final B setEnd(Instant INSTANT) {
        if (INSTANT == null) {
            throw new IllegalArgumentException("Instant cannot be null");
        }
        this.properties.put("end", (Property)new SimpleObjectProperty((Object)LocalDateTime.ofInstant(INSTANT, ZoneId.systemDefault())));
        return (B)this;
    }

    public final B setEnd(Instant INSTANT, ZoneId ZONE_ID) {
        if (INSTANT == null || ZONE_ID == null) {
            throw new IllegalArgumentException("Instant or zone id cannot be null");
        }
        this.properties.put("end", (Property)new SimpleObjectProperty((Object)LocalDateTime.ofInstant(INSTANT, ZONE_ID)));
        return (B)this;
    }

    public final B end(LocalDateTime DATE_TIME) {
        this.properties.put("end", (Property)new SimpleObjectProperty((Object)DATE_TIME));
        return (B)this;
    }

    public final B autoScale(boolean AUTO) {
        this.properties.put("autoScale", (Property)new SimpleBooleanProperty(AUTO));
        return (B)this;
    }

    public final B title(String TITLE) {
        this.properties.put("title", (Property)new SimpleStringProperty(TITLE));
        return (B)this;
    }

    public final B unit(String UNIT) {
        this.properties.put("unit", (Property)new SimpleStringProperty(UNIT));
        return (B)this;
    }

    public final B type(AxisType TYPE) {
        this.properties.put("axisType", (Property)new SimpleObjectProperty((Object)TYPE));
        return (B)this;
    }

    public final B axisBackgroundColor(Color COLOR) {
        this.properties.put("axisBackgroundColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B axisColor(Color COLOR) {
        this.properties.put("axisColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B tickLabelColor(Color COLOR) {
        this.properties.put("tickLabelColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B titleColor(Color COLOR) {
        this.properties.put("titleColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B tickMarkColor(Color COLOR) {
        this.properties.put("tickMarkColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B minorTickMarkColor(Color COLOR) {
        this.properties.put("minorTickMarkColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B mediumTickMarkColor(Color COLOR) {
        this.properties.put("mediumTickMarkColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B majorTickMarkColor(Color COLOR) {
        this.properties.put("majorTickMarkColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B tickMarksVisible(boolean VISIBLE) {
        this.properties.put("tickMarksVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B minorTickMarksVisible(boolean VISIBLE) {
        this.properties.put("minorTickMarksVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B mediumTickMarksVisible(boolean VISIBLE) {
        this.properties.put("mediumTickMarksVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B majorTickMarksVisible(boolean VISIBLE) {
        this.properties.put("majorTickMarksVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B zeroColor(Color COLOR) {
        this.properties.put("zeroColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B minorTickSpace(double SPACE) {
        this.properties.put("minorTickSpace", (Property)new SimpleDoubleProperty(SPACE));
        return (B)this;
    }

    public final B majorTickSpace(double SPACE) {
        this.properties.put("majorTickSpace", (Property)new SimpleDoubleProperty(SPACE));
        return (B)this;
    }

    public final B tickLabelsVisible(boolean VISIBLE) {
        this.properties.put("tickLabelsVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B onlyFirstAndLastTickLabelVisible(boolean VISIBLE) {
        this.properties.put("onlyFirstAndLastTickLabelVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B locale(Locale LOCALE) {
        this.properties.put("locale", (Property)new SimpleObjectProperty((Object)LOCALE));
        return (B)this;
    }

    public final B decimals(int DECIMALS) {
        this.properties.put("decimals", (Property)new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B tickLabelOrientation(TickLabelOrientation ORIENTATION) {
        this.properties.put("tickLabelOrientation", (Property)new SimpleObjectProperty((Object)ORIENTATION));
        return (B)this;
    }

    public final B tickLabelFormat(TickLabelFormat FORMAT) {
        this.properties.put("tickLabelFormat", (Property)new SimpleObjectProperty((Object)FORMAT));
        return (B)this;
    }

    public final B autoFontSize(boolean AUTO) {
        this.properties.put("autoFontSize", (Property)new SimpleBooleanProperty(AUTO));
        return (B)this;
    }

    public final B tickLabelFontSize(double SIZE) {
        this.properties.put("tickLabelFontSize", (Property)new SimpleDoubleProperty(SIZE));
        return (B)this;
    }

    public final B titleFontSize(double SIZE) {
        this.properties.put("titleFontSize", (Property)new SimpleDoubleProperty(SIZE));
        return (B)this;
    }

    public final B zoneId(ZoneId ID) {
        this.properties.put("zoneId", (Property)new SimpleObjectProperty((Object)ID));
        return (B)this;
    }

    public final B dateTimeFormatPattern(String PATTERN) {
        this.properties.put("dateTimeFormatPattern", (Property)new SimpleStringProperty(PATTERN));
        return (B)this;
    }

    public final B numberFormatter(StringConverter<Number> FORMATTER) {
        this.properties.put("numberFormatter", (Property)new SimpleObjectProperty(FORMATTER));
        return (B)this;
    }

    public final B categories(String ... CATEGORIES) {
        this.properties.put("categoriesArray", (Property)new SimpleObjectProperty((Object)CATEGORIES));
        return (B)this;
    }

    public final B categories(List<String> CATEGORIES) {
        this.properties.put("categoriesList", (Property)new SimpleObjectProperty(CATEGORIES));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final Axis build() {
        Axis CONTROL = new Axis(this.orientation, this.position);
        if (this.properties.keySet().contains("categoriesArray")) {
            CONTROL.setCategories((String[])((ObjectProperty)this.properties.get("categoriesArray")).get());
        }
        if (this.properties.keySet().contains("categoriesList")) {
            CONTROL.setCategories((List)((ObjectProperty)this.properties.get("categoriesList")).get());
        }
        for (String key : this.properties.keySet()) {
            Dimension2D dim;
            if ("prefSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setMinSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setMaxSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                CONTROL.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                CONTROL.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                CONTROL.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                CONTROL.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                CONTROL.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                CONTROL.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                CONTROL.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                CONTROL.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                CONTROL.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                CONTROL.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                CONTROL.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                CONTROL.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("padding".equals(key)) {
                CONTROL.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minValue".equals(key)) {
                CONTROL.setMinValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxValue".equals(key)) {
                CONTROL.setMaxValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("start".equals(key)) {
                CONTROL.setStart((LocalDateTime)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("end".equals(key)) {
                CONTROL.setEnd((LocalDateTime)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("autoScale".equals(key)) {
                CONTROL.setAutoScale(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("title".equals(key)) {
                CONTROL.setTitle((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("unit".equals(key)) {
                CONTROL.setUnit((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("axisType".equals(key)) {
                CONTROL.setType((AxisType)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("axisBackgroundColor".equals(key)) {
                CONTROL.setAxisBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("axisColor".equals(key)) {
                CONTROL.setAxisColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("tickLabelColor".equals(key)) {
                CONTROL.setTickLabelColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("titleColor".equals(key)) {
                CONTROL.setTitleColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("tickMarkColor".equals(key)) {
                CONTROL.setTickMarkColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minorTickMarkColor".equals(key)) {
                CONTROL.setMinorTickMarkColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("mediumTickMarkColor".equals(key)) {
                CONTROL.setMediumTickMarkColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("majorTickMarkColor".equals(key)) {
                CONTROL.setMajorTickMarkColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("tickMarksVisible".equals(key)) {
                CONTROL.setTickMarksVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minorTickMarksVisible".equals(key)) {
                CONTROL.setMinorTickMarksVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("mediumTickMarksVisible".equals(key)) {
                CONTROL.setMediumTickMarksVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("majorTickMarksVisible".equals(key)) {
                CONTROL.setMajorTickMarksVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("zeroColor".equals(key)) {
                CONTROL.setZeroColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minorTickSpace".equals(key)) {
                CONTROL.setMinorTickSpace(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("majorTickSpace".equals(key)) {
                CONTROL.setMajorTickSpace(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("tickLabelsVisible".equals(key)) {
                CONTROL.setTickLabelsVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("onlyFirstAndLastTickLabel".equals(key)) {
                CONTROL.setOnlyFirstAndLastTickLabelVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("local".equals(key)) {
                CONTROL.setLocale((Locale)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("decimals".equals(key)) {
                CONTROL.setDecimals(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("tickLabelOrientation".equals(key)) {
                CONTROL.setTickLabelOrientation((TickLabelOrientation)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("tickLabelFormat".equals(key)) {
                CONTROL.setTickLabelFormat((TickLabelFormat)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("autoFontSize".equals(key)) {
                CONTROL.setAutoFontSize(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("tickLabelFontSize".equals(key)) {
                CONTROL.setTickLabelFontSize(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("titleFontSize".equals(key)) {
                CONTROL.setTitleFontSize(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("zoneId".equals(key)) {
                CONTROL.setZoneId((ZoneId)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("dateTimeFormatPattern".equals(key)) {
                CONTROL.setDateTimeFormatPattern((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"numberFormatter".equals(key)) continue;
            CONTROL.setNumberFormatter((StringConverter<Number>)((StringConverter)((ObjectProperty)this.properties.get(key)).get()));
        }
        return CONTROL;
    }
}

