/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.BubbleGridChart;
import eu.hansolo.fx.charts.data.BubbleGridChartItem;
import eu.hansolo.fx.charts.tools.Order;
import eu.hansolo.fx.charts.tools.Topic;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;

public class BubbleGridChartBuilder<B extends BubbleGridChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected BubbleGridChartBuilder() {
    }

    public static final BubbleGridChartBuilder create() {
        return new BubbleGridChartBuilder();
    }

    public final B items(BubbleGridChartItem ... ITEMS) {
        this.properties.put("itemsArray", (Property)new SimpleObjectProperty((Object)ITEMS));
        return (B)this;
    }

    public final B items(List<BubbleGridChartItem> ITEMS) {
        this.properties.put("itemsList", (Property)new SimpleObjectProperty(ITEMS));
        return (B)this;
    }

    public final B chartBackground(Color COLOR) {
        this.properties.put("chartBackground", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B gridColor(Color COLOR) {
        this.properties.put("gridColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B autoBubbleTextColor(boolean AUTO) {
        this.properties.put("autoBubbleTextColor", (Property)new SimpleBooleanProperty(AUTO));
        return (B)this;
    }

    public final B showGrid(boolean SHOW) {
        this.properties.put("showGrid", (Property)new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B showValues(boolean SHOW) {
        this.properties.put("showValues", (Property)new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B showPercentage(boolean SHOW) {
        this.properties.put("showPercentage", (Property)new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B useXCategoryFill() {
        this.properties.put("useXCategoryFill", null);
        return (B)this;
    }

    public final B useYCategoryFill() {
        this.properties.put("useXCategoryFill", null);
        return (B)this;
    }

    public final B sortCategoryX(Topic TOPIC, Order ORDER) {
        this.properties.put("sortCategoryXTopic", (Property)new SimpleObjectProperty((Object)TOPIC));
        this.properties.put("sortCategoryXOrder", (Property)new SimpleObjectProperty((Object)ORDER));
        return (B)this;
    }

    public final B sortCategoryY(Topic TOPIC, Order ORDER) {
        this.properties.put("sortCategoryYTopic", (Property)new SimpleObjectProperty((Object)TOPIC));
        this.properties.put("sortCategoryYOrder", (Property)new SimpleObjectProperty((Object)ORDER));
        return (B)this;
    }

    public final B useGradientFill(boolean USE) {
        this.properties.put("useGradientFill", (Property)new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B minColor(Color MIN_COLOR) {
        this.properties.put("minColor", (Property)new SimpleObjectProperty((Object)MIN_COLOR));
        return (B)this;
    }

    public final B maxColor(Color MAX_COLOR) {
        this.properties.put("maxColor", (Property)new SimpleObjectProperty((Object)MAX_COLOR));
        return (B)this;
    }

    public final B gradient(LinearGradient GRADIENT) {
        this.properties.put("gradient", (Property)new SimpleObjectProperty((Object)GRADIENT));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final BubbleGridChart build() {
        BubbleGridChart CONTROL = new BubbleGridChart();
        if (this.properties.keySet().contains("itemsArray")) {
            CONTROL.setItems((BubbleGridChartItem[])((ObjectProperty)this.properties.get("itemsArray")).get());
        }
        if (this.properties.keySet().contains("itemsList")) {
            CONTROL.setItems((List)((ObjectProperty)this.properties.get("itemsList")).get());
        }
        for (String key : this.properties.keySet()) {
            Dimension2D dim;
            if ("prefSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setMinSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setMaxSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                CONTROL.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                CONTROL.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                CONTROL.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                CONTROL.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                CONTROL.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                CONTROL.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                CONTROL.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                CONTROL.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                CONTROL.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                CONTROL.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                CONTROL.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                CONTROL.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("padding".equals(key)) {
                CONTROL.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("chartBackground".equals(key)) {
                CONTROL.setChartBackground((Paint)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("textColor".equals(key)) {
                CONTROL.setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("autoBubbleTextColor".equals(key)) {
                CONTROL.setAutoBubbleTextColor(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("gridColor".equals(key)) {
                CONTROL.setGridColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("showGrid".equals(key)) {
                CONTROL.setShowGrid(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("showValues".equals(key)) {
                CONTROL.setShowValues(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("showPercentage".equals(key)) {
                CONTROL.setShowPercentage(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("useXCategoryFill".equals(key)) {
                CONTROL.useXCategoryFill();
                continue;
            }
            if ("useYCategoryFill".equals(key)) {
                CONTROL.useYCategoryFill();
                continue;
            }
            if ("sortCategoryXTopic".equals(key)) {
                CONTROL.sortCategoryX((Topic)((Object)((ObjectProperty)this.properties.get("sortCategoryXTopic")).get()), (Order)((Object)((ObjectProperty)this.properties.get("sortCategoryXOrder")).get()));
                continue;
            }
            if ("sortCategoryYTopic".equals(key)) {
                CONTROL.sortCategoryY((Topic)((Object)((ObjectProperty)this.properties.get("sortCategoryYTopic")).get()), (Order)((Object)((ObjectProperty)this.properties.get("sortCategoryYOrder")).get()));
                continue;
            }
            if ("useGradientFill".equals(key)) {
                CONTROL.setUseGradientFill(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minColor".equals(key)) {
                CONTROL.setMinColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxColor".equals(key)) {
                CONTROL.setMaxColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"gradient".equals(key)) continue;
            CONTROL.setGradient((LinearGradient)((ObjectProperty)this.properties.get(key)).get());
        }
        return CONTROL;
    }
}

