/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.ChartArea;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.event.SelectionEvent;
import eu.hansolo.fx.charts.event.SelectionEventListener;
import eu.hansolo.fx.charts.font.Fonts;
import eu.hansolo.fx.charts.series.ChartItemSeries;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.InfoPopup;
import eu.hansolo.fx.charts.tools.Order;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class NestedBarChart
extends Region
implements ChartArea {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 150.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 2048.0;
    private static final double MAXIMUM_HEIGHT = 2048.0;
    private double size = 150.0;
    private double width = 250.0;
    private double height = 150.0;
    private Paint _chartBackground;
    private ObjectProperty<Paint> chartBackground;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Pane pane;
    private ObservableList<ChartItemSeries<ChartItem>> series;
    private Order _order;
    private ObjectProperty<Order> order;
    private EventHandler<MouseEvent> clickHandler;
    private CopyOnWriteArrayList<SelectionEventListener> listeners;
    private InfoPopup popup;
    private double spacer;
    private boolean _seriesTitleVisible;
    private BooleanProperty seriesTitleVisible;
    private Color _seriesTitleColor;
    private ObjectProperty<Color> seriesTitleColor;

    public NestedBarChart() {
        this(new ArrayList<ChartItemSeries<ChartItem>>(), (Paint)Color.TRANSPARENT);
    }

    public NestedBarChart(ChartItemSeries<ChartItem> ... SERIES) {
        this(Arrays.asList(SERIES), (Paint)Color.TRANSPARENT);
    }

    public NestedBarChart(List<ChartItemSeries<ChartItem>> SERIES) {
        this(SERIES, (Paint)Color.TRANSPARENT);
    }

    public NestedBarChart(List<ChartItemSeries<ChartItem>> SERIES, Paint BACKGROUND) {
        this.series = FXCollections.observableArrayList(SERIES);
        this._order = Order.DESCENDING;
        this._chartBackground = BACKGROUND;
        this.spacer = -1.0;
        this._seriesTitleVisible = false;
        this._seriesTitleColor = null;
        this.clickHandler = e -> this.checkForClick((MouseEvent)e);
        this.listeners = new CopyOnWriteArrayList();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 150.0);
            }
        }
        this.getStyleClass().add((Object)"nested-bar-chart");
        this.popup = new InfoPopup();
        this.canvas = new Canvas(250.0, 150.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.pane = new Pane(new Node[]{this.canvas});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.canvas.addEventHandler(MouseEvent.MOUSE_PRESSED, this.clickHandler);
        this.setOnSelectionEvent(e -> {
            this.popup.update(e);
            this.popup.animatedShow(this.getScene().getWindow());
        });
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 2048.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 2048.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.canvas.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.clickHandler);
    }

    public List<ChartItemSeries<ChartItem>> getSeries() {
        return this.series;
    }

    public void setSeries(ChartItemSeries<ChartItem> ... SERIES) {
        this.setSeries(Arrays.asList(SERIES));
    }

    public void setSeries(List<ChartItemSeries<ChartItem>> SERIES) {
        this.series.clear();
        SERIES.forEach(item -> {
            boolean bl = this.series.add(item);
        });
        this.redraw();
    }

    public void addSeries(ChartItemSeries<ChartItem> SERIES) {
        if (!this.series.contains(SERIES)) {
            this.series.add(SERIES);
            this.redraw();
        }
    }

    public void addSeries(ChartItemSeries<ChartItem> ... SERIES) {
        this.addSeries(Arrays.asList(SERIES));
    }

    public void addSeries(List<ChartItemSeries<ChartItem>> SERIES) {
        SERIES.forEach(item -> this.addSeries((ChartItemSeries<ChartItem>)item));
    }

    public void removeSeries(ChartItemSeries<ChartItem> SERIES) {
        if (this.series.contains(SERIES)) {
            this.series.remove(SERIES);
            this.redraw();
        }
    }

    public void removeSeries(ChartItemSeries<ChartItem> ... SERIES) {
        this.removeSeries(Arrays.asList(SERIES));
    }

    public void removeSeries(List<ChartItemSeries<ChartItem>> SERIES) {
        SERIES.forEach(item -> this.removeSeries((ChartItemSeries<ChartItem>)item));
    }

    public Order getOrder() {
        return this.order == null ? this._order : (Order)((Object)this.order.get());
    }

    public void setOrder(Order ORDER) {
        if (this.order == null) {
            this._order = ORDER;
            this.redraw();
        } else {
            this.order.set((Object)ORDER);
        }
    }

    public ObjectProperty<Order> orderProperty() {
        if (this.order == null) {
            this.order = new ObjectPropertyBase<Order>(this._order){

                protected void invalidated() {
                    NestedBarChart.this.redraw();
                }

                public Object getBean() {
                    return NestedBarChart.this;
                }

                public String getName() {
                    return "order";
                }
            };
            this._order = null;
        }
        return this.order;
    }

    @Override
    public Paint getChartBackground() {
        return this.chartBackground == null ? this._chartBackground : (Paint)this.chartBackground.get();
    }

    @Override
    public void setChartBackground(Paint PAINT) {
        if (this.chartBackground == null) {
            this._chartBackground = PAINT;
            this.redraw();
        } else {
            this.chartBackground.set((Object)PAINT);
        }
    }

    public ObjectProperty<Paint> chartBackgroundProperty() {
        if (this.chartBackground == null) {
            this.chartBackground = new ObjectPropertyBase<Paint>(this._chartBackground){

                protected void invalidated() {
                    NestedBarChart.this.redraw();
                }

                public Object getBean() {
                    return NestedBarChart.this;
                }

                public String getName() {
                    return "chartBackground";
                }
            };
            this._chartBackground = null;
        }
        return this.chartBackground;
    }

    public double getSpacer() {
        return this.spacer;
    }

    public void setSpacer(double SPACER) {
        this.spacer = SPACER;
        this.redraw();
    }

    public void setDefaultSpacer() {
        this.spacer = -1.0;
        this.redraw();
    }

    public boolean isSeriesTitleVisible() {
        return this.seriesTitleVisible == null ? this._seriesTitleVisible : this.seriesTitleVisible.get();
    }

    public void setSeriesTitleVisible(boolean VISIBLE) {
        if (this.seriesTitleVisible == null) {
            this._seriesTitleVisible = VISIBLE;
            this.redraw();
        } else {
            this.seriesTitleVisible.set(VISIBLE);
        }
    }

    public BooleanProperty seriesTitleVisibleProperty() {
        if (this.seriesTitleVisible == null) {
            this.seriesTitleVisible = new BooleanPropertyBase(this._seriesTitleVisible){

                protected void invalidated() {
                    NestedBarChart.this.redraw();
                }

                public Object getBean() {
                    return NestedBarChart.this;
                }

                public String getName() {
                    return "seriesTitleVisible";
                }
            };
        }
        return this.seriesTitleVisible;
    }

    public Color getSeriesTitleColor() {
        return this.seriesTitleColor == null ? this._seriesTitleColor : (Color)this.seriesTitleColor.get();
    }

    public void setSeriesTitleColor(Color COLOR) {
        if (this.seriesTitleColor == null) {
            this._seriesTitleColor = COLOR;
            this.redraw();
        } else {
            this.seriesTitleColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> seriesTitleColor() {
        if (this.seriesTitleColor == null) {
            this.seriesTitleColor = new ObjectPropertyBase<Color>(this._seriesTitleColor){

                protected void invalidated() {
                    NestedBarChart.this.redraw();
                }

                public Object getBean() {
                    return NestedBarChart.this;
                }

                public String getName() {
                    return "seriesTitleColor";
                }
            };
        }
        return this.seriesTitleColor;
    }

    public void checkForClick(MouseEvent EVT) {
        double X = EVT.getX();
        double Y = EVT.getY();
        this.popup.setX(EVT.getScreenX());
        this.popup.setY(EVT.getScreenY() - this.popup.getHeight());
        long noOfBars = this.series.size();
        double defaultSpacer = this.width * 0.05;
        double usedSpacer = this.spacer == -1.0 ? defaultSpacer : this.spacer;
        double mainBarWidth = (this.width - usedSpacer * (double)(noOfBars - 1L)) / (double)noOfBars;
        double maxSum = -1.7976931348623157E308;
        int i = 0;
        while ((long)i < noOfBars) {
            maxSum = Math.max(maxSum, ((ChartItemSeries)this.series.get(i)).getItems().stream().mapToDouble(ChartItem::getValue).sum());
            ++i;
        }
        double stepY = this.height / maxSum;
        ChartItemSeries selectedSeries = null;
        int i2 = 0;
        while ((long)i2 < noOfBars) {
            ChartItemSeries s = (ChartItemSeries)this.series.get(i2);
            int noOfItems = s.getNoOfItems();
            double sumOfItems = s.getItems().stream().mapToDouble(ChartItem::getValue).sum();
            double innerBarWidth = mainBarWidth / (double)noOfItems;
            double minX = (double)i2 * mainBarWidth + (double)i2 * usedSpacer;
            double mainBarHeight = sumOfItems * stepY;
            if (Helper.isInRectangle(X, Y, minX, this.height - mainBarHeight, minX + mainBarWidth, this.height)) {
                selectedSeries = s;
            }
            for (ChartItem item : s.getItems()) {
                double innerBarHeight = item.getValue() * stepY;
                if (Helper.isInRectangle(X, Y, minX, this.height - innerBarHeight, minX + innerBarWidth, this.height)) {
                    this.fireSelectionEvent(new SelectionEvent<ChartItem>(selectedSeries, item));
                    return;
                }
                minX += innerBarWidth;
            }
            ++i2;
        }
        if (selectedSeries != null) {
            this.fireSelectionEvent(new SelectionEvent(selectedSeries));
        }
    }

    private void sortItems(List<ChartItem> ITEMS, Order ORDER) {
        if (Order.ASCENDING == ORDER) {
            Collections.sort(ITEMS, Comparator.comparingDouble(ChartItem::getValue));
        } else {
            Collections.sort(ITEMS, Comparator.comparingDouble(ChartItem::getValue).reversed());
        }
    }

    public void setOnSelectionEvent(SelectionEventListener LISTENER) {
        this.addSelectionEventListener(LISTENER);
    }

    public void addSelectionEventListener(SelectionEventListener LISTENER) {
        if (!this.listeners.contains(LISTENER)) {
            this.listeners.add(LISTENER);
        }
    }

    public void removeSelectionEventListener(SelectionEventListener LISTENER) {
        if (this.listeners.contains(LISTENER)) {
            this.listeners.remove(LISTENER);
        }
    }

    public void removeAllSelectionEventListeners() {
        this.listeners.clear();
    }

    public void fireSelectionEvent(SelectionEvent EVENT) {
        for (SelectionEventListener listener : this.listeners) {
            listener.onSelectionEvent(EVENT);
        }
    }

    private void redraw() {
        this.drawChart();
    }

    private void drawChart() {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.ctx.setFill(this.getChartBackground());
        this.ctx.fillRect(0.0, 0.0, this.width, this.height);
        long noOfBars = this.series.size();
        double defaultSpacer = this.width * 0.025;
        double usedSpacer = this.spacer == -1.0 ? defaultSpacer : this.spacer;
        double mainBarWidth = (this.width - usedSpacer * (double)(noOfBars - 1L)) / (double)noOfBars;
        boolean seriesTitleVisible = this.isSeriesTitleVisible();
        double maxSum = -1.7976931348623157E308;
        int i = 0;
        while ((long)i < noOfBars) {
            maxSum = Math.max(maxSum, ((ChartItemSeries)this.series.get(i)).getItems().stream().mapToDouble(ChartItem::getValue).sum());
            ++i;
        }
        double stepY = this.height / maxSum;
        double fontSize = mainBarWidth * 0.125;
        Font font = Fonts.opensansRegular(fontSize);
        int i2 = 0;
        while ((long)i2 < noOfBars) {
            ChartItemSeries s = (ChartItemSeries)this.series.get(i2);
            int noOfItems = s.getNoOfItems();
            double sumOfItems = s.getSumOfAllItems();
            double innerBarWidth = mainBarWidth / (double)noOfItems;
            double mainBarHeight = sumOfItems * stepY;
            double minX = (double)i2 * mainBarWidth + (double)i2 * usedSpacer;
            this.ctx.setFill(s.getFill());
            this.ctx.fillRect(minX, this.height - mainBarHeight, mainBarWidth, mainBarHeight);
            this.sortItems((List<ChartItem>)s.getItems(), this.getOrder());
            double minMainBarX = minX;
            for (ChartItem item : s.getItems()) {
                double innerBarHeight = item.getValue() * stepY;
                this.ctx.setFill((Paint)(s.getItems().size() == 1 ? s.getFill() : item.getFill()));
                this.ctx.fillRect(minX, this.height - innerBarHeight, innerBarWidth, innerBarHeight);
                minX += innerBarWidth;
            }
            if (seriesTitleVisible) {
                this.ctx.save();
                this.ctx.setTextBaseline(VPos.CENTER);
                this.ctx.setTextAlign(TextAlignment.CENTER);
                this.ctx.setFill((Paint)(this.getSeriesTitleColor() == null ? s.getTextFill() : this.getSeriesTitleColor()));
                this.ctx.setFill((Paint)this.getSeriesTitleColor());
                this.ctx.setFont(font);
                if (mainBarHeight <= 2.0 * fontSize) {
                    this.ctx.fillText(s.getName(), minMainBarX + mainBarWidth * 0.5, this.height - mainBarHeight - fontSize - mainBarWidth * 0.01, mainBarWidth);
                } else {
                    this.ctx.fillText(s.getName(), minMainBarX + mainBarWidth * 0.5, this.height - mainBarHeight + fontSize + mainBarWidth * 0.01, mainBarWidth);
                }
                this.ctx.restore();
            }
            ++i2;
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.pane.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.canvas.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.redraw();
        }
    }
}

