/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.XYPane;
import eu.hansolo.fx.charts.data.XYItem;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Region;

public class PolarChart<T extends XYItem>
extends Region {
    private static final double PREFERRED_WIDTH = 400.0;
    private static final double PREFERRED_HEIGHT = 400.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 4096.0;
    private static final double MAXIMUM_HEIGHT = 4096.0;
    private double size;
    private double width;
    private double height;
    private XYPane<T> xyPane;
    private String _title;
    private StringProperty title;
    private String _subTitle;
    private StringProperty subTitle;
    private AnchorPane pane;

    public PolarChart(XYPane<T> XY_PANE) {
        if (XY_PANE == null) {
            throw new IllegalArgumentException("XYPane has not to be null");
        }
        if (!XY_PANE.containsPolarChart()) {
            throw new IllegalArgumentException("No Polar chart in XYPane");
        }
        this.xyPane = XY_PANE;
        this.width = 400.0;
        this.height = 400.0;
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(400.0, 400.0);
            }
        }
        this.pane = new AnchorPane(new Node[]{this.xyPane});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 4096.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 4096.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public String getTitle() {
        return this.title == null ? this._title : (String)this.title.get();
    }

    public void setTitle(String TITLE) {
        if (this.title == null) {
            this._title = TITLE;
            this.xyPane.redraw();
        } else {
            this.title.set((Object)TITLE);
        }
    }

    public StringProperty titleProperty() {
        if (this.title == null) {
            this.title = new StringPropertyBase(this._title){

                protected void invalidated() {
                    PolarChart.this.xyPane.redraw();
                }

                public Object getBean() {
                    return PolarChart.this;
                }

                public String getName() {
                    return "title";
                }
            };
            this._title = null;
        }
        return this.title;
    }

    public String getSubTitle() {
        return this.subTitle == null ? this._subTitle : (String)this.subTitle.get();
    }

    public void setSubTitle(String SUB_TITLE) {
        if (this.subTitle == null) {
            this._subTitle = SUB_TITLE;
            this.xyPane.redraw();
        } else {
            this.subTitle.set((Object)SUB_TITLE);
        }
    }

    public StringProperty subTitleProperty() {
        if (this.subTitle == null) {
            this.subTitle = new StringPropertyBase(this._subTitle){

                protected void invalidated() {
                    PolarChart.this.xyPane.redraw();
                }

                public Object getBean() {
                    return PolarChart.this;
                }

                public String getName() {
                    return "subTitle";
                }
            };
            this._subTitle = null;
        }
        return this.subTitle;
    }

    public XYPane<T> getXYPane() {
        return this.xyPane;
    }

    public void refresh() {
        this.xyPane.redraw();
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.setPrefSize(this.size, this.size);
            this.pane.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            this.xyPane.setMaxSize(this.size, this.size);
            this.xyPane.setPrefSize(this.size, this.size);
        }
    }
}

