/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.Axis;
import eu.hansolo.fx.charts.Grid;
import eu.hansolo.fx.charts.Position;
import eu.hansolo.fx.charts.XYPane;
import eu.hansolo.fx.charts.data.XYItem;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

@DefaultProperty(value="children")
public class XYChart<T extends XYItem>
extends Region {
    private static final double PREFERRED_WIDTH = 400.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 4096.0;
    private static final double MAXIMUM_HEIGHT = 4096.0;
    private double width;
    private double height;
    private ObservableList<XYPane<T>> xyPanes;
    private List<Axis> axis;
    private Axis yAxisL;
    private Axis yAxisC;
    private Axis yAxisR;
    private Axis xAxisT;
    private Axis xAxisC;
    private Axis xAxisB;
    private double topAxisHeight;
    private double rightAxisWidth;
    private double bottomAxisHeight;
    private double leftAxisWidth;
    private Grid grid;
    private boolean hasLeftYAxis;
    private boolean hasCenterYAxis;
    private boolean hasRightYAxis;
    private boolean hasTopXAxis;
    private boolean hasCenterXAxis;
    private boolean hasBottomXAxis;
    private String _title;
    private StringProperty title;
    private String _subTitle;
    private StringProperty subTitle;
    private AnchorPane pane;
    private BooleanBinding showing;

    public XYChart(XYPane<T> XY_PANE, Axis ... AXIS) {
        this(List.of(XY_PANE), (Grid)null, AXIS);
    }

    public XYChart(XYPane<T> XY_PANE, Grid GRID, Axis ... AXIS) {
        this(List.of(XY_PANE), GRID, AXIS);
    }

    public XYChart(List<XYPane<T>> XY_PANES, Axis ... AXIS) {
        this(XY_PANES, (Grid)null, AXIS);
    }

    public XYChart(List<XYPane<T>> XY_PANES, Grid GRID, Axis ... AXIS) {
        if (XY_PANES == null) {
            throw new IllegalArgumentException("XYPanes cannot be null");
        }
        long noOfPolarCharts = XY_PANES.stream().filter(xyPane -> xyPane.containsPolarChart()).count();
        if (noOfPolarCharts > 0L) {
            throw new IllegalArgumentException("XYPane contains Polar chart type");
        }
        this.xyPanes = FXCollections.observableList(new LinkedList<XYPane<T>>(XY_PANES));
        this.axis = Arrays.asList(AXIS);
        this.grid = GRID;
        this.width = 400.0;
        this.height = 250.0;
        this.checkReferenceZero();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(400.0, 250.0);
            }
        }
        this.checkForAxis();
        if (this.xyPanes.size() > 1) {
            this.xyPanes.forEach(xyPane -> xyPane.setChartBackground((Paint)Color.TRANSPARENT));
        }
        this.adjustChartRange();
        this.adjustAxisAnchors();
        this.pane = new AnchorPane();
        this.xyPanes.forEach(xyPane -> {
            boolean bl = this.pane.getChildren().add(xyPane);
        });
        this.pane.getChildren().addAll(this.axis);
        this.setGrid(this.grid);
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.xyPanes.addListener(c -> {
            if (this.xyPanes.size() > 1) {
                this.xyPanes.forEach(xyPane -> xyPane.setChartBackground((Paint)Color.TRANSPARENT));
            }
            this.checkReferenceZero();
            this.refresh();
        });
        if (this.getScene() != null) {
            this.setupBinding();
        } else {
            this.sceneProperty().addListener((o1, ov1, nv1) -> {
                if (nv1 == null) {
                    return;
                }
                if (this.getScene().getWindow() != null) {
                    this.setupBinding();
                } else {
                    ((Scene)this.sceneProperty().get()).windowProperty().addListener((o2, ov2, nv2) -> {
                        if (nv2 == null) {
                            return;
                        }
                        this.setupBinding();
                    });
                }
            });
        }
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 4096.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 4096.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.xyPanes.forEach(xyPane -> xyPane.dispose());
    }

    public String getTitle() {
        return this.title == null ? this._title : (String)this.title.get();
    }

    public void setTitle(String TITLE) {
        if (this.title == null) {
            this._title = TITLE;
            this.xyPanes.forEach(xyPane -> xyPane.redraw());
        } else {
            this.title.set((Object)TITLE);
        }
    }

    public StringProperty titleProperty() {
        if (this.title == null) {
            this.title = new StringPropertyBase(this._title){

                protected void invalidated() {
                    XYChart.this.xyPanes.forEach(xyPane -> xyPane.redraw());
                }

                public Object getBean() {
                    return XYChart.this;
                }

                public String getName() {
                    return "title";
                }
            };
            this._title = null;
        }
        return this.title;
    }

    public String getSubTitle() {
        return this.subTitle == null ? this._subTitle : (String)this.subTitle.get();
    }

    public void setSubTitle(String SUB_TITLE) {
        if (this.subTitle == null) {
            this._subTitle = SUB_TITLE;
            this.xyPanes.forEach(xyPane -> xyPane.redraw());
        } else {
            this.subTitle.set((Object)SUB_TITLE);
        }
    }

    public StringProperty subTitleProperty() {
        if (this.subTitle == null) {
            this.subTitle = new StringPropertyBase(this._subTitle){

                protected void invalidated() {
                    XYChart.this.xyPanes.forEach(xyPane -> xyPane.redraw());
                }

                public Object getBean() {
                    return XYChart.this;
                }

                public String getName() {
                    return "subTitle";
                }
            };
            this._subTitle = null;
        }
        return this.subTitle;
    }

    public boolean isReferenceZero() {
        if (this.xyPanes.size() > 0) {
            return ((XYPane)this.xyPanes.get(0)).isReferenceZero();
        }
        return true;
    }

    public void setReferenceZero(boolean IS_ZERO) {
        this.xyPanes.forEach(xyPane -> xyPane.setReferenceZero(IS_ZERO));
    }

    public void setGrid(Grid GRID) {
        if (GRID == null) {
            return;
        }
        if (this.grid != null) {
            this.pane.getChildren().remove((Object)this.grid);
        }
        this.grid = GRID;
        this.pane.getChildren().add(0, (Object)this.grid);
        this.adjustGridAnchors();
    }

    public XYPane<T> getXYPane() {
        return this.xyPanes.size() > 0 ? (XYPane)this.xyPanes.get(0) : null;
    }

    public List<XYPane<T>> getXYPanes() {
        return this.xyPanes;
    }

    public void addXYPane(XYPane<T> xyPane) {
        this.xyPanes.add(xyPane);
    }

    public void removeXYPane(XYPane<T> xyPane) {
        this.xyPanes.remove(xyPane);
    }

    public void refresh() {
        this.xyPanes.forEach(xyPane -> xyPane.redraw());
    }

    private void checkForAxis() {
        this.axis.forEach(axis -> {
            Position position = axis.getPosition();
            block0 : switch (axis.getOrientation()) {
                case HORIZONTAL: {
                    switch (position) {
                        case TOP: {
                            this.hasTopXAxis = true;
                            this.topAxisHeight = axis.getPrefHeight();
                            this.xAxisT = axis;
                            break block0;
                        }
                        case CENTER: {
                            this.hasCenterXAxis = true;
                            this.xAxisC = axis;
                            break block0;
                        }
                        case BOTTOM: {
                            this.hasBottomXAxis = true;
                            this.bottomAxisHeight = axis.getPrefHeight();
                            this.xAxisB = axis;
                            break block0;
                        }
                    }
                    this.hasTopXAxis = false;
                    this.hasCenterXAxis = false;
                    this.hasBottomXAxis = false;
                    break;
                }
                case VERTICAL: {
                    switch (position) {
                        case LEFT: {
                            this.hasLeftYAxis = true;
                            this.leftAxisWidth = axis.getPrefWidth();
                            this.yAxisL = axis;
                            break block0;
                        }
                        case CENTER: {
                            this.hasCenterYAxis = true;
                            this.yAxisC = axis;
                            break block0;
                        }
                        case RIGHT: {
                            this.hasRightYAxis = true;
                            this.rightAxisWidth = axis.getPrefWidth();
                            this.yAxisR = axis;
                            break block0;
                        }
                    }
                    this.hasLeftYAxis = false;
                    this.hasCenterYAxis = false;
                    this.hasRightYAxis = false;
                }
            }
        });
    }

    private void adjustChartRange() {
        this.xyPanes.forEach(xyPane -> {
            if (this.hasBottomXAxis) {
                xyPane.lowerBoundXProperty().bind((ObservableValue)this.xAxisB.minValueProperty());
                xyPane.upperBoundXProperty().bind((ObservableValue)this.xAxisB.maxValueProperty());
            } else if (this.hasTopXAxis) {
                xyPane.lowerBoundXProperty().bind((ObservableValue)this.xAxisT.minValueProperty());
                xyPane.upperBoundXProperty().bind((ObservableValue)this.xAxisT.maxValueProperty());
            } else if (this.hasCenterXAxis) {
                xyPane.lowerBoundXProperty().bind((ObservableValue)this.xAxisC.minValueProperty());
                xyPane.upperBoundXProperty().bind((ObservableValue)this.xAxisC.maxValueProperty());
            }
            if (this.hasLeftYAxis) {
                xyPane.lowerBoundYProperty().bind((ObservableValue)this.yAxisL.minValueProperty());
                xyPane.upperBoundYProperty().bind((ObservableValue)this.yAxisL.maxValueProperty());
            } else if (this.hasRightYAxis) {
                xyPane.lowerBoundYProperty().bind((ObservableValue)this.yAxisR.minValueProperty());
                xyPane.upperBoundYProperty().bind((ObservableValue)this.yAxisR.maxValueProperty());
            } else if (this.hasCenterYAxis) {
                xyPane.lowerBoundYProperty().bind((ObservableValue)this.yAxisC.minValueProperty());
                xyPane.upperBoundYProperty().bind((ObservableValue)this.yAxisC.maxValueProperty());
            }
        });
    }

    private void adjustAxisAnchors() {
        this.xyPanes.forEach(xyPane -> this.axis.forEach(axis -> {
            if (Orientation.HORIZONTAL == axis.getOrientation()) {
                AnchorPane.setLeftAnchor((Node)axis, (Double)(this.hasLeftYAxis ? this.leftAxisWidth : 0.0));
                AnchorPane.setRightAnchor((Node)axis, (Double)(this.hasRightYAxis ? this.rightAxisWidth : 0.0));
                AnchorPane.setLeftAnchor((Node)xyPane, (Double)(this.hasLeftYAxis ? this.leftAxisWidth : 0.0));
                AnchorPane.setRightAnchor((Node)xyPane, (Double)(this.hasRightYAxis ? this.rightAxisWidth : 0.0));
            } else {
                AnchorPane.setTopAnchor((Node)axis, (Double)(this.hasTopXAxis ? this.topAxisHeight : 0.0));
                AnchorPane.setBottomAnchor((Node)axis, (Double)(this.hasBottomXAxis ? this.bottomAxisHeight : 0.0));
                AnchorPane.setTopAnchor((Node)xyPane, (Double)(this.hasTopXAxis ? this.topAxisHeight : 0.0));
                AnchorPane.setBottomAnchor((Node)xyPane, (Double)(this.hasBottomXAxis ? this.bottomAxisHeight : 0.0));
            }
        }));
    }

    private void adjustCenterAxisAnchors() {
        if (this.hasCenterYAxis) {
            if (this.hasBottomXAxis) {
                if (this.hasLeftYAxis) {
                    AnchorPane.setLeftAnchor((Node)this.yAxisC, (Double)(this.xAxisB.getZeroPosition() + this.yAxisL.getWidth()));
                } else if (this.hasRightYAxis) {
                    AnchorPane.setLeftAnchor((Node)this.yAxisC, (Double)this.xAxisB.getZeroPosition());
                } else if (this.hasCenterXAxis) {
                    AnchorPane.setLeftAnchor((Node)this.yAxisC, (Double)this.xAxisC.getZeroPosition());
                }
            } else if (this.hasLeftYAxis) {
                AnchorPane.setLeftAnchor((Node)this.yAxisC, (Double)(this.xAxisT.getZeroPosition() + this.yAxisL.getWidth()));
            } else if (this.hasRightYAxis) {
                AnchorPane.setLeftAnchor((Node)this.yAxisC, (Double)this.xAxisT.getZeroPosition());
            } else if (this.hasCenterXAxis) {
                AnchorPane.setLeftAnchor((Node)this.yAxisC, (Double)this.xAxisC.getZeroPosition());
            }
        }
        if (this.hasCenterXAxis) {
            if (this.hasLeftYAxis) {
                if (this.hasTopXAxis) {
                    AnchorPane.setTopAnchor((Node)this.xAxisC, (Double)(this.yAxisL.getZeroPosition() + this.xAxisT.getHeight()));
                } else if (this.hasBottomXAxis) {
                    AnchorPane.setTopAnchor((Node)this.xAxisC, (Double)this.yAxisL.getZeroPosition());
                } else if (this.hasCenterYAxis) {
                    AnchorPane.setTopAnchor((Node)this.xAxisC, (Double)this.yAxisC.getZeroPosition());
                }
            } else if (this.hasTopXAxis) {
                AnchorPane.setTopAnchor((Node)this.xAxisC, (Double)(this.yAxisR.getZeroPosition() + this.xAxisT.getHeight()));
            } else if (this.hasBottomXAxis) {
                AnchorPane.setTopAnchor((Node)this.xAxisC, (Double)this.yAxisR.getZeroPosition());
            } else if (this.hasCenterYAxis) {
                AnchorPane.setTopAnchor((Node)this.xAxisC, (Double)this.yAxisC.getZeroPosition());
            }
        }
    }

    private void adjustGridAnchors() {
        if (this.grid == null) {
            return;
        }
        AnchorPane.setLeftAnchor((Node)this.grid, (Double)(this.hasLeftYAxis ? this.leftAxisWidth : 0.0));
        AnchorPane.setRightAnchor((Node)this.grid, (Double)(this.hasRightYAxis ? this.rightAxisWidth : 0.0));
        AnchorPane.setTopAnchor((Node)this.grid, (Double)(this.hasTopXAxis ? this.topAxisHeight : 0.0));
        AnchorPane.setBottomAnchor((Node)this.grid, (Double)(this.hasBottomXAxis ? this.bottomAxisHeight : 0.0));
    }

    private void setupBinding() {
        this.showing = Bindings.selectBoolean((ObservableValue)this.sceneProperty(), (String[])new String[]{"window", "showing"});
        this.showing.addListener((o, ov, nv) -> {
            if (nv.booleanValue()) {
                this.adjustCenterAxisAnchors();
            }
        });
    }

    private void checkReferenceZero() {
        boolean isReferenceZero = true;
        if (this.xyPanes.size() > 0) {
            isReferenceZero = ((XYPane)this.xyPanes.get(0)).isReferenceZero();
        }
        this.setReferenceZero(isReferenceZero);
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.pane.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.adjustCenterAxisAnchors();
        }
    }
}

