/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.data;

import eu.hansolo.fx.charts.data.Item;
import eu.hansolo.fx.charts.event.TreeNodeEvent;
import eu.hansolo.fx.charts.event.TreeNodeEventListener;
import eu.hansolo.fx.charts.event.TreeNodeEventType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class TreeNode<T extends Item> {
    private final TreeNodeEvent<T> PARENT_CHANGED = new TreeNodeEvent(this, TreeNodeEventType.PARENT_CHANGED);
    private final TreeNodeEvent<T> CHILDREN_CHANGED = new TreeNodeEvent(this, TreeNodeEventType.CHILDREN_CHANGED);
    private T item;
    private TreeNode<T> parent;
    private TreeNode<T> myRoot;
    private TreeNode<T> treeRoot;
    private int depth;
    private final ObservableList<TreeNode<T>> children;
    private List<TreeNodeEventListener<T>> listeners;

    public TreeNode(T ITEM) {
        this(ITEM, null);
    }

    public TreeNode(T ITEM, TreeNode<T> PARENT) {
        this.item = ITEM;
        this.parent = PARENT;
        this.depth = -1;
        this.children = FXCollections.observableArrayList();
        this.listeners = new CopyOnWriteArrayList<TreeNodeEventListener<T>>();
        this.init();
    }

    private void init() {
        if (this.parent != null) {
            this.parent.getChildren().add(this);
        }
        this.children.addListener(c -> {
            while (c.next()) {
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(TreeNode::removeAllTreeNodeEventListeners);
            }
            this.getTreeRoot().fireTreeNodeEvent(this.CHILDREN_CHANGED);
        });
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public void removeParent() {
        this.parent = null;
        this.myRoot = null;
        this.treeRoot = null;
        this.depth = -1;
        this.getTreeRoot().fireTreeNodeEvent(this.PARENT_CHANGED);
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public void setParent(TreeNode<T> PARENT) {
        if (PARENT != null) {
            PARENT.addNode(this);
        }
        this.parent = PARENT;
        this.myRoot = null;
        this.treeRoot = null;
        this.depth = -1;
        this.getTreeRoot().fireTreeNodeEvent(this.PARENT_CHANGED);
    }

    public T getItem() {
        return this.item;
    }

    public void setItem(T ITEM) {
        this.item = ITEM;
    }

    public List<TreeNode<T>> getChildrenUnmodifiable() {
        return Collections.unmodifiableList(this.children);
    }

    public List<TreeNode<T>> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeNode<T>> CHILDREN) {
        this.children.setAll(new LinkedHashSet<TreeNode<T>>(CHILDREN));
    }

    public void addNode(T ITEM) {
        TreeNode<T> child = new TreeNode<T>(ITEM);
        child.setParent(this);
        this.children.add(child);
    }

    public void addNode(TreeNode<T> NODE) {
        if (this.children.contains(NODE)) {
            return;
        }
        NODE.setParent(this);
        this.children.add(NODE);
    }

    public void removeNode(TreeNode<T> NODE) {
        this.children.remove(NODE);
    }

    public void addNodes(TreeNode<T> ... NODES) {
        this.addNodes(Arrays.asList(NODES));
    }

    public void addNodes(List<TreeNode<T>> NODES) {
        NODES.forEach(this::addNode);
    }

    public void removeNodes(TreeNode<T> ... NODES) {
        this.removeNodes(Arrays.asList(NODES));
    }

    public void removeNodes(List<TreeNode<T>> NODES) {
        NODES.forEach(this::removeNode);
    }

    public void removeAllNodes() {
        this.children.clear();
    }

    public Stream<TreeNode<T>> stream() {
        if (this.isLeaf()) {
            return Stream.of(this);
        }
        return this.getChildren().stream().map(TreeNode::stream).reduce(Stream.of(this), Stream::concat);
    }

    public Stream<TreeNode<T>> lazyStream() {
        if (this.isLeaf()) {
            return Stream.of(this);
        }
        return Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(TreeNode::stream));
    }

    public Stream<TreeNode<T>> flattened() {
        return Stream.concat(Stream.of(this), this.children.stream().flatMap(TreeNode::flattened));
    }

    public List<TreeNode<T>> getAll() {
        return this.flattened().collect(Collectors.toList());
    }

    public List<T> getAllData() {
        return this.flattened().map(TreeNode::getItem).collect(Collectors.toList());
    }

    public int getNoOfNodes() {
        return (int)this.flattened().map(TreeNode::getItem).count();
    }

    public int getNoOfLeafNodes() {
        return (int)this.flattened().filter(TreeNode::isLeaf).map(TreeNode::getItem).count();
    }

    public boolean contains(TreeNode<T> NODE) {
        return this.flattened().anyMatch(n -> n.equals(NODE));
    }

    public boolean containsData(T ITEM) {
        return this.flattened().anyMatch(n -> n.item.equals(ITEM));
    }

    public TreeNode<T> getMyRoot() {
        if (this.myRoot == null) {
            this.myRoot = this.getParent() != null && this.getParent().isRoot() ? this : this.getMyRoot(this.getParent());
        }
        return this.myRoot;
    }

    private TreeNode<T> getMyRoot(TreeNode<T> NODE) {
        if (NODE.getParent().isRoot()) {
            return NODE;
        }
        return this.getMyRoot(NODE.getParent());
    }

    public TreeNode<T> getTreeRoot() {
        if (this.treeRoot == null) {
            this.treeRoot = this.isRoot() ? this : this.getTreeRoot(this.getParent());
        }
        return this.treeRoot;
    }

    private TreeNode<T> getTreeRoot(TreeNode<T> NODE) {
        if (NODE.isRoot()) {
            return NODE;
        }
        return this.getTreeRoot(NODE.getParent());
    }

    public int getDepth() {
        if (this.depth == -1) {
            this.depth = this.isRoot() ? 0 : this.getDepth(this.getParent(), 0);
        }
        return this.depth;
    }

    private int getDepth(TreeNode<T> NODE, int depth) {
        ++depth;
        if (NODE.isRoot()) {
            return depth;
        }
        return this.getDepth(NODE.getParent(), depth);
    }

    public int getMaxLevel() {
        return this.getTreeRoot().stream().map(TreeNode::getDepth).max(Comparator.naturalOrder()).orElse(0);
    }

    public List<TreeNode<T>> getSiblings() {
        return this.getParent() == null ? new ArrayList() : this.getParent().getChildren();
    }

    public List<TreeNode<T>> nodesAtSameLevel() {
        int LEVEL = this.getDepth();
        return this.getTreeRoot().stream().filter(node -> node.getDepth() == LEVEL).collect(Collectors.toList());
    }

    public void setOnTreeNodeEvent(TreeNodeEventListener<T> LISTENER) {
        this.addTreeNodeEventListener(LISTENER);
    }

    public void addTreeNodeEventListener(TreeNodeEventListener<T> LISTENER) {
        if (!this.listeners.contains(LISTENER)) {
            this.listeners.add(LISTENER);
        }
    }

    public void removeTreeNodeEventListener(TreeNodeEventListener<T> LISTENER) {
        this.listeners.remove(LISTENER);
    }

    public void removeAllTreeNodeEventListeners() {
        this.listeners.clear();
    }

    public void fireTreeNodeEvent(TreeNodeEvent<T> EVENT) {
        for (TreeNodeEventListener<T> listener : this.listeners) {
            listener.onTreeNodeEvent(EVENT);
        }
    }
}

