/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.data;

import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.data.XYItem;
import eu.hansolo.fx.charts.event.ItemEvent;
import eu.hansolo.fx.charts.event.ItemEventListener;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.scene.paint.Color;

public class XYChartItem
implements XYItem,
Comparable<XYChartItem> {
    private final ItemEvent ITEM_EVENT = new ItemEvent<XYChartItem>(this);
    private CopyOnWriteArrayList<ItemEventListener> listeners;
    private double _x;
    private DoubleProperty x;
    private double _y;
    private DoubleProperty y;
    private String _name;
    private StringProperty name;
    private Color _fill;
    private ObjectProperty<Color> fill;
    private Color _stroke;
    private ObjectProperty<Color> stroke;
    private Symbol _symbol;
    private ObjectProperty<Symbol> symbol;
    private boolean _isEmpty;
    private BooleanProperty isEmpty;
    private String _tooltipText;
    private StringProperty tooltipText;

    public XYChartItem() {
        this(0.0, 0.0, "", Color.RED, Color.TRANSPARENT, Symbol.NONE, "", false);
    }

    public XYChartItem(boolean IS_EMPTY) {
        this(0.0, 0.0, "", Color.RED, Color.TRANSPARENT, Symbol.NONE, "", IS_EMPTY);
    }

    public XYChartItem(double X, double Y) {
        this(X, Y, "", Color.RED, Color.TRANSPARENT, Symbol.NONE, "", false);
    }

    public XYChartItem(double X, double Y, boolean IS_EMPTY) {
        this(X, Y, "", Color.RED, Color.TRANSPARENT, Symbol.NONE, "", IS_EMPTY);
    }

    public XYChartItem(double X, double Y, Color FILL) {
        this(X, Y, "", FILL, Color.TRANSPARENT, Symbol.NONE, "", false);
    }

    public XYChartItem(double X, double Y, Color FILL, String TOOLTIP) {
        this(X, Y, "", FILL, Color.TRANSPARENT, Symbol.NONE, TOOLTIP, false);
    }

    public XYChartItem(double X, double Y, Color FILL, boolean IS_EMPTY) {
        this(X, Y, "", FILL, Color.TRANSPARENT, Symbol.NONE, "", IS_EMPTY);
    }

    public XYChartItem(double X, double Y, Color FILL, String TOOLTIP, boolean IS_EMPTY) {
        this(X, Y, "", FILL, Color.TRANSPARENT, Symbol.NONE, TOOLTIP, IS_EMPTY);
    }

    public XYChartItem(double X, double Y, String NAME) {
        this(X, Y, NAME, Color.RED, Color.TRANSPARENT, Symbol.NONE, "", false);
    }

    public XYChartItem(double X, double Y, String NAME, String TOOLTIP) {
        this(X, Y, NAME, Color.RED, Color.TRANSPARENT, Symbol.NONE, TOOLTIP, false);
    }

    public XYChartItem(double X, double Y, String NAME, boolean IS_EMPTY) {
        this(X, Y, NAME, Color.RED, Color.TRANSPARENT, Symbol.NONE, "", IS_EMPTY);
    }

    public XYChartItem(double X, double Y, String NAME, String TOOLTIP, boolean IS_EMPTY) {
        this(X, Y, NAME, Color.RED, Color.TRANSPARENT, Symbol.NONE, TOOLTIP, IS_EMPTY);
    }

    public XYChartItem(double X, double Y, String NAME, Color FILL) {
        this(X, Y, NAME, FILL, Color.TRANSPARENT, Symbol.NONE, "", false);
    }

    public XYChartItem(double X, double Y, String NAME, Color FILL, String TOOLTIP) {
        this(X, Y, NAME, FILL, Color.TRANSPARENT, Symbol.NONE, TOOLTIP, false);
    }

    public XYChartItem(double X, double Y, String NAME, Color FILL, boolean IS_EMPTY) {
        this(X, Y, NAME, FILL, Color.TRANSPARENT, Symbol.NONE, "", IS_EMPTY);
    }

    public XYChartItem(double X, double Y, String NAME, Color FILL, String TOOLTIP, boolean IS_EMPTY) {
        this(X, Y, NAME, FILL, Color.TRANSPARENT, Symbol.NONE, TOOLTIP, IS_EMPTY);
    }

    public XYChartItem(double X, double Y, String NAME, Color FILL, Color STROKE, Symbol SYMBOL) {
        this(X, Y, NAME, FILL, STROKE, SYMBOL, false);
    }

    public XYChartItem(double X, double Y, String NAME, Color FILL, Color STROKE, Symbol SYMBOL, boolean IS_EMPTY) {
        this(X, Y, NAME, FILL, STROKE, SYMBOL, "", IS_EMPTY);
    }

    public XYChartItem(double X, double Y, String NAME, Color FILL, Color STROKE, Symbol SYMBOL, String TOOLTIP, boolean IS_EMPTY) {
        this._x = X;
        this._y = Y;
        this._name = NAME;
        this._fill = FILL;
        this._stroke = STROKE;
        this._symbol = SYMBOL;
        this._isEmpty = IS_EMPTY;
        this._tooltipText = TOOLTIP;
        this.listeners = new CopyOnWriteArrayList();
    }

    @Override
    public double getX() {
        return this.x == null ? this._x : this.x.get();
    }

    @Override
    public void setX(double X) {
        if (this.x == null) {
            this._x = X;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.x.set(X);
        }
    }

    @Override
    public DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(this._x){

                protected void invalidated() {
                    XYChartItem.this.fireItemEvent(XYChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return XYChartItem.this;
                }

                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    @Override
    public double getY() {
        return this.y == null ? this._y : this.y.get();
    }

    @Override
    public void setY(double Y) {
        if (this.y == null) {
            this._y = Y;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.y.set(Y);
        }
    }

    @Override
    public DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(this._y){

                protected void invalidated() {
                    XYChartItem.this.fireItemEvent(XYChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return XYChartItem.this;
                }

                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    @Override
    public String getName() {
        return this.name == null ? this._name : (String)this.name.get();
    }

    public void setName(String NAME) {
        if (this.name == null) {
            this._name = NAME;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.name.set((Object)NAME);
        }
    }

    public StringProperty nameProperty() {
        if (this.name == null) {
            this.name = new StringPropertyBase(this._name){

                protected void invalidated() {
                    XYChartItem.this.fireItemEvent(XYChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return XYChartItem.this;
                }

                public String getName() {
                    return "name";
                }
            };
            this._name = null;
        }
        return this.name;
    }

    @Override
    public Color getFill() {
        return this.fill == null ? this._fill : (Color)this.fill.get();
    }

    public void setFill(Color FILL) {
        if (this.fill == null) {
            this._fill = FILL;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.fill.set((Object)FILL);
        }
    }

    public ObjectProperty<Color> fillProperty() {
        if (this.fill == null) {
            this.fill = new ObjectPropertyBase<Color>(this._fill){

                protected void invalidated() {
                    XYChartItem.this.fireItemEvent(XYChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return XYChartItem.this;
                }

                public String getName() {
                    return "fill";
                }
            };
            this._fill = null;
        }
        return this.fill;
    }

    @Override
    public Color getStroke() {
        return this.stroke == null ? this._stroke : (Color)this.stroke.get();
    }

    public void setStroke(Color STROKE) {
        if (this.stroke == null) {
            this._stroke = STROKE;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.stroke.set((Object)STROKE);
        }
    }

    public ObjectProperty<Color> strokeProperty() {
        if (this.stroke == null) {
            this.stroke = new ObjectPropertyBase<Color>(this._stroke){

                protected void invalidated() {
                    XYChartItem.this.fireItemEvent(XYChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return XYChartItem.this;
                }

                public String getName() {
                    return "stroke";
                }
            };
            this._stroke = null;
        }
        return this.stroke;
    }

    @Override
    public Symbol getSymbol() {
        return this.symbol == null ? this._symbol : (Symbol)((Object)this.symbol.get());
    }

    @Override
    public void setSymbol(Symbol SYMBOL) {
        if (this.symbol == null) {
            this._symbol = SYMBOL;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.symbol.set((Object)SYMBOL);
        }
    }

    public ObjectProperty<Symbol> symbolProperty() {
        if (this.symbol == null) {
            this.symbol = new ObjectPropertyBase<Symbol>(this._symbol){

                protected void invalidated() {
                    XYChartItem.this.fireItemEvent(XYChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return XYChartItem.this;
                }

                public String getName() {
                    return "symbol";
                }
            };
            this._symbol = null;
        }
        return this.symbol;
    }

    @Override
    public String getTooltipText() {
        return this.tooltipText == null ? this._tooltipText : (String)this.tooltipText.get();
    }

    @Override
    public void setTooltipText(String TOOLTIP) {
        if (this.tooltipText == null) {
            this._tooltipText = TOOLTIP;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.tooltipText.set((Object)TOOLTIP);
        }
    }

    @Override
    public StringProperty tooltipTextProperty() {
        if (this.tooltipText == null) {
            this.tooltipText = new StringPropertyBase(this._tooltipText){

                protected void invalidated() {
                    XYChartItem.this.fireItemEvent(XYChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return XYChartItem.this;
                }

                public String getName() {
                    return "tooltip";
                }
            };
            this._tooltipText = null;
        }
        return this.tooltipText;
    }

    @Override
    public boolean isEmptyItem() {
        return this.isEmpty == null ? this._isEmpty : this.isEmpty.get();
    }

    public void setIsEmpty(boolean isEmpty) {
        if (this.isEmpty == null) {
            this._isEmpty = isEmpty;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.isEmpty.set(isEmpty);
        }
    }

    public BooleanProperty isEmptyProperty() {
        if (this.isEmpty == null) {
            this.isEmpty = new BooleanPropertyBase(this._isEmpty){

                protected void invalidated() {
                    XYChartItem.this.fireItemEvent(XYChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return XYChartItem.this;
                }

                public String getName() {
                    return "isEmpty";
                }
            };
        }
        return this.isEmpty;
    }

    public void setOnItemEvent(ItemEventListener LISTENER) {
        this.addItemEventListener(LISTENER);
    }

    public void addItemEventListener(ItemEventListener LISTENER) {
        if (!this.listeners.contains(LISTENER)) {
            this.listeners.add(LISTENER);
        }
    }

    public void removeItemEventListener(ItemEventListener LISTENER) {
        if (this.listeners.contains(LISTENER)) {
            this.listeners.remove(LISTENER);
        }
    }

    public void fireItemEvent(ItemEvent EVENT) {
        for (ItemEventListener listener : this.listeners) {
            listener.onItemEvent(EVENT);
        }
    }

    public String toString() {
        return "{\n" + "  \"name\":\"" + this.getName() + "\",\n" + "  \"x\":" + this.getX() + ",\n" + "  \"y\":" + this.getY() + ",\n" + "  \"symbol\":\"" + this.getSymbol().name() + "\"\n" + "}";
    }

    @Override
    public int compareTo(XYChartItem ITEM) {
        return Double.compare(this.getX(), ITEM.getX());
    }
}

