/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.event;

import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.event.EventType;
import eu.hansolo.fx.charts.series.ChartItemSeries;

public class SelectionEvent<T extends ChartItem> {
    private final ChartItemSeries<T> SERIES;
    private final T ITEM;
    private final EventType TYPE;

    public SelectionEvent(T ITEM) {
        this(null, ITEM, EventType.SELECTED);
    }

    public SelectionEvent(ChartItemSeries<T> SERIES) {
        this(SERIES, null, EventType.SELECTED);
    }

    public SelectionEvent(ChartItemSeries<T> SERIES, T ITEM) {
        this(SERIES, ITEM, EventType.SELECTED);
    }

    public SelectionEvent(ChartItemSeries<T> SERIES, T ITEM, EventType TYPE) {
        this.SERIES = SERIES;
        this.ITEM = ITEM;
        this.TYPE = TYPE;
    }

    public ChartItemSeries<T> getSeries() {
        return this.SERIES;
    }

    public T getItem() {
        return this.ITEM;
    }

    public EventType getEventType() {
        return this.TYPE;
    }

    public String toString() {
        String ret;
        if (this.SERIES == null) {
            if (this.ITEM == null) {
                String string = "{}";
            }
            ret = "{\n" + "  \"item\"  :\"" + ((ChartItem)this.ITEM).getName() + "\",\n" + "  \"value\" :" + ((ChartItem)this.ITEM).getValue() + "\n" + "}";
        } else {
            ret = this.ITEM == null ? "{\n" + "  \"series\":\"" + this.SERIES.getName() + "\",\n" + "  \"sum\"   :" + this.SERIES.getSumOfAllItems() + "\n" + "}" : "{\n" + "  \"series\":\"" + this.SERIES.getName() + "\",\n" + "  \"sum\"   :" + this.SERIES.getSumOfAllItems() + ",\n" + "  \"item\"  :\"" + ((ChartItem)this.ITEM).getName() + "\",\n" + "  \"value\" :" + ((ChartItem)this.ITEM).getValue() + "\n" + "}";
        }
        return ret;
    }
}

