/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.heatmap;

import eu.hansolo.fx.charts.heatmap.HeatMapSpot;
import eu.hansolo.fx.charts.heatmap.OpacityDistribution;
import eu.hansolo.fx.charts.tools.ColorMapping;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.Point;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.Interpolator;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javax.imageio.ImageIO;

public class HeatMap
extends ImageView {
    private static final SnapshotParameters SNAPSHOT_PARAMETERS = new SnapshotParameters();
    private List<HeatMapSpot> spotList;
    private Map<String, Image> spotImages;
    private ColorMapping colorMapping;
    private LinearGradient mappingGradient;
    private boolean fadeColors;
    private double radius;
    private OpacityDistribution opacityDistribution;
    private Image spotImage;
    private Canvas monochrome;
    private GraphicsContext ctx;
    private WritableImage monochromeImage;
    private WritableImage heatMap;

    public HeatMap() {
        this(100.0, 100.0, ColorMapping.LIME_YELLOW_RED, 15.5, true, 0.5, OpacityDistribution.CUSTOM);
    }

    public HeatMap(double WIDTH, double HEIGHT) {
        this(WIDTH, HEIGHT, ColorMapping.LIME_YELLOW_RED, 15.5, true, 0.5, OpacityDistribution.CUSTOM);
    }

    public HeatMap(double WIDTH, double HEIGHT, ColorMapping COLOR_MAPPING) {
        this(WIDTH, HEIGHT, COLOR_MAPPING, 15.5, true, 0.5, OpacityDistribution.CUSTOM);
    }

    public HeatMap(double WIDTH, double HEIGHT, ColorMapping COLOR_MAPPING, double SPOT_RADIUS) {
        this(WIDTH, HEIGHT, COLOR_MAPPING, SPOT_RADIUS, true, 0.5, OpacityDistribution.CUSTOM);
    }

    public HeatMap(double WIDTH, double HEIGHT, ColorMapping COLOR_MAPPING, double SPOT_RADIUS, boolean FADE_COLORS, double HEAT_MAP_OPACITY, OpacityDistribution OPACITY_DISTRIBUTION) {
        SNAPSHOT_PARAMETERS.setFill((Paint)Color.TRANSPARENT);
        this.spotList = new ArrayList<HeatMapSpot>();
        this.spotImages = new HashMap<String, Image>();
        this.colorMapping = COLOR_MAPPING;
        this.mappingGradient = this.colorMapping.getGradient();
        this.fadeColors = FADE_COLORS;
        this.radius = SPOT_RADIUS;
        this.opacityDistribution = OPACITY_DISTRIBUTION;
        this.spotImage = this.createSpotImage(this.radius, this.opacityDistribution);
        this.monochrome = new Canvas(WIDTH, HEIGHT);
        this.ctx = this.monochrome.getGraphicsContext2D();
        this.monochromeImage = new WritableImage((int)WIDTH, (int)HEIGHT);
        this.setImage((Image)this.heatMap);
        this.setMouseTransparent(true);
        this.setOpacity(HEAT_MAP_OPACITY);
        this.registerListeners();
    }

    public void registerListeners() {
        this.fitWidthProperty().addListener(o -> this.resize());
        this.fitHeightProperty().addListener(o -> this.resize());
    }

    public void addSpots(Point ... SPOTS) {
        this.addSpots(Arrays.asList(SPOTS));
    }

    public void addSpots(List<Point> SPOTS) {
        SPOTS.forEach(spot -> {
            this.spotList.add(new HeatMapSpot(spot.getX(), spot.getY(), this.radius, this.opacityDistribution));
            this.ctx.drawImage(this.spotImage, spot.getX() - this.radius, spot.getY() - this.radius);
        });
        this.updateHeatMap();
    }

    public void addSpot(double X, double Y) {
        this.addSpot(X, Y, this.spotImage, this.radius, this.radius);
    }

    public void addSpot(double X, double Y, double OFFSET_X, double OFFSET_Y, double RADIUS, OpacityDistribution OPACITY_GRADIENT) {
        this.spotImage = this.createSpotImage(RADIUS, OPACITY_GRADIENT);
        this.addSpot(X, Y, this.spotImage, OFFSET_X, OFFSET_Y);
    }

    public void addSpot(double X, double Y, Image EVENT_IMAGE, double OFFSET_X, double OFFSET_Y) {
        this.spotList.add(new HeatMapSpot(X, Y, this.radius, this.opacityDistribution));
        this.ctx.drawImage(EVENT_IMAGE, X - OFFSET_X, Y - OFFSET_Y);
        this.updateHeatMap();
    }

    public void clearHeatMap() {
        this.spotList.clear();
        this.ctx.clearRect(0.0, 0.0, this.monochrome.getWidth(), this.monochrome.getHeight());
        this.monochromeImage = new WritableImage(this.monochrome.widthProperty().intValue(), this.monochrome.heightProperty().intValue());
        this.updateHeatMap();
    }

    public ColorMapping getColorMapping() {
        return this.colorMapping;
    }

    public void setColorMapping(ColorMapping COLOR_MAPPING) {
        this.colorMapping = COLOR_MAPPING;
        this.mappingGradient = COLOR_MAPPING.getGradient();
        this.updateHeatMap();
    }

    public boolean isFadeColors() {
        return this.fadeColors;
    }

    public void setFadeColors(boolean FADE_COLORS) {
        this.fadeColors = FADE_COLORS;
        this.updateHeatMap();
    }

    public double getSpotRadius() {
        return this.radius;
    }

    public void setSpotRadius(double RADIUS) {
        this.radius = RADIUS < 1.0 ? 1.0 : RADIUS;
        this.spotImage = this.createSpotImage(this.radius, this.opacityDistribution);
    }

    public OpacityDistribution getOpacityDistribution() {
        return this.opacityDistribution;
    }

    public void setOpacityDistribution(OpacityDistribution OPACITY_DISTRIBUTION) {
        this.opacityDistribution = OPACITY_DISTRIBUTION;
        this.spotImage = this.createSpotImage(this.radius, this.opacityDistribution);
    }

    public void setSize(double WIDTH, double HEIGHT) {
        this.setFitWidth(WIDTH);
        this.setFitHeight(HEIGHT);
    }

    public void saveAsPng(String FILE_NAME) {
        this.saveAsPng((Node)this, String.valueOf(FILE_NAME) + ".png");
    }

    public void saveAsPng(Node NODE, String FILE_NAME) {
        new Thread(() -> Platform.runLater(() -> {
            String TARGET = String.valueOf(System.getProperty("user.home")) + "/Desktop/" + FILE_NAME + ".png";
            try {
                ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)NODE.snapshot(SNAPSHOT_PARAMETERS, null), null), "png", new File(TARGET));
            }
            catch (IOException iOException) {}
        })).start();
    }

    public Image createSpotImage(double RADIUS, OpacityDistribution OPACITY_DISTRIBUTION) {
        Double radius = RADIUS < 1.0 ? 1.0 : RADIUS;
        if (this.spotImages.containsKey(String.valueOf(OPACITY_DISTRIBUTION.name()) + radius)) {
            return this.spotImages.get(String.valueOf(OPACITY_DISTRIBUTION.name()) + radius);
        }
        Stop[] stops = new Stop[11];
        int i = 0;
        while (i < 11) {
            stops[i] = new Stop((double)i * 0.1, Color.rgb((int)255, (int)255, (int)255, (double)OPACITY_DISTRIBUTION.getDistribution()[i]));
            ++i;
        }
        int size = (int)(radius * 2.0);
        WritableImage raster = new WritableImage(size, size);
        PixelWriter pixelWriter = raster.getPixelWriter();
        double maxDistFactor = 1.0 / radius;
        int y = 0;
        while (y < size) {
            int x = 0;
            while (x < size) {
                double deltaX = radius - (double)x;
                double deltaY = radius - (double)y;
                double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
                double fraction = maxDistFactor * distance;
                int i2 = 0;
                while (i2 < 10) {
                    if (Double.compare(fraction, stops[i2].getOffset()) >= 0 && Double.compare(fraction, stops[i2 + 1].getOffset()) <= 0) {
                        Color pixelColor = (Color)Interpolator.LINEAR.interpolate((Object)stops[i2].getColor(), (Object)stops[i2 + 1].getColor(), (fraction - stops[i2].getOffset()) / 0.1);
                        pixelWriter.setColor(x, y, pixelColor);
                        break;
                    }
                    ++i2;
                }
                ++x;
            }
            ++y;
        }
        this.spotImages.put(String.valueOf(OPACITY_DISTRIBUTION.name()) + radius, (Image)raster);
        return raster;
    }

    public void updateMonochromeMap(OpacityDistribution OPACITY_GRADIENT) {
        this.ctx.clearRect(0.0, 0.0, this.monochrome.getWidth(), this.monochrome.getHeight());
        this.spotList.forEach(spot -> {
            spot.setOpacityDistribution(OPACITY_GRADIENT);
            this.ctx.drawImage(this.createSpotImage(spot.getRadius(), spot.getOpacityDistribution()), spot.getX() - spot.getRadius() * 0.5, spot.getY() - spot.getRadius() * 0.5);
        });
        this.updateHeatMap();
    }

    private void updateHeatMap() {
        this.monochrome.snapshot(SNAPSHOT_PARAMETERS, this.monochromeImage);
        int width = this.monochromeImage.widthProperty().intValue();
        int height = this.monochromeImage.heightProperty().intValue();
        this.heatMap = new WritableImage(width, height);
        PixelWriter pixelWriter = this.heatMap.getPixelWriter();
        PixelReader pixelReader = this.monochromeImage.getPixelReader();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                Color colorFromMonoChromeImage = pixelReader.getColor(x, y);
                double brightness = colorFromMonoChromeImage.getOpacity();
                Color mappedColor = Helper.getColorAt(this.mappingGradient, brightness);
                pixelWriter.setColor(x, y, this.fadeColors ? Color.color((double)mappedColor.getRed(), (double)mappedColor.getGreen(), (double)mappedColor.getBlue(), (double)brightness) : mappedColor);
                ++x;
            }
            ++y;
        }
        this.setImage((Image)this.heatMap);
    }

    private void resize() {
        double width = this.getFitWidth();
        double height = this.getFitHeight();
        this.monochrome.setWidth(width);
        this.monochrome.setHeight(height);
        if (width > 0.0 && height > 0.0) {
            this.monochromeImage = new WritableImage(this.monochrome.widthProperty().intValue(), this.monochrome.heightProperty().intValue());
            this.updateHeatMap();
        }
    }
}

