/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.series;

import eu.hansolo.fx.charts.ChartType;
import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.data.Item;
import eu.hansolo.fx.charts.data.XYChartItem;
import eu.hansolo.fx.charts.event.EventType;
import eu.hansolo.fx.charts.event.ItemEventListener;
import eu.hansolo.fx.charts.event.SeriesEvent;
import eu.hansolo.fx.charts.event.SeriesEventListener;
import eu.hansolo.fx.charts.tools.Helper;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.LongProperty;
import javafx.beans.property.LongPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public abstract class Series<T extends Item> {
    public final SeriesEvent UPDATE_EVENT = new SeriesEvent(this, EventType.UPDATE);
    protected String _name;
    protected StringProperty name;
    protected Paint _fill;
    protected ObjectProperty<Paint> fill;
    protected Paint _stroke;
    protected ObjectProperty<Paint> stroke;
    protected Color _textFill;
    protected ObjectProperty<Color> textFill;
    protected Color _symbolFill;
    protected ObjectProperty<Color> symbolFill;
    protected Color _symbolStroke;
    protected ObjectProperty<Color> symbolStroke;
    protected Symbol _symbol;
    protected ObjectProperty<Symbol> symbol;
    protected boolean _symbolsVisible;
    protected BooleanProperty symbolsVisible;
    protected double _symbolSize;
    protected DoubleProperty symbolSize;
    protected double _strokeWidth;
    protected DoubleProperty strokeWidth;
    protected boolean _animated;
    protected BooleanProperty animated;
    protected long _animationDuration;
    protected LongProperty animationDuration;
    protected boolean _withWrapping;
    protected BooleanProperty withWrapping;
    protected ChartType chartType;
    protected ObservableList<T> items;
    private CopyOnWriteArrayList<SeriesEventListener> listeners;
    private ListChangeListener<T> itemListener;
    private ItemEventListener itemEventListener;

    public Series() {
        this(null, ChartType.SCATTER, "", (Paint)Color.TRANSPARENT, (Paint)Color.BLACK, Color.BLACK, Color.BLACK, Symbol.CIRCLE);
    }

    public Series(T ... ITEMS) {
        this(Arrays.asList(ITEMS), ChartType.SCATTER, "", (Paint)Color.TRANSPARENT, (Paint)Color.BLACK, Color.BLACK, Color.BLACK, Symbol.CIRCLE);
    }

    public Series(ChartType TYPE, T ... ITEMS) {
        this(Arrays.asList(ITEMS), TYPE, "", (Paint)Color.TRANSPARENT, (Paint)Color.BLACK, Color.BLACK, Color.BLACK, Symbol.CIRCLE);
    }

    public Series(List<T> ITEMS, ChartType TYPE) {
        this(ITEMS, TYPE, "", (Paint)Color.TRANSPARENT, (Paint)Color.BLACK, Color.BLACK, Color.BLACK, Symbol.CIRCLE);
    }

    public Series(ChartType TYPE, String NAME, T ... ITEMS) {
        this(Arrays.asList(ITEMS), TYPE, NAME, (Paint)Color.TRANSPARENT, (Paint)Color.BLACK, Color.BLACK, Color.BLACK, Symbol.CIRCLE);
    }

    public Series(List<T> ITEMS, ChartType TYPE, String NAME) {
        this(ITEMS, TYPE, NAME, (Paint)Color.TRANSPARENT, (Paint)Color.BLACK, Color.BLACK, Color.BLACK, Symbol.CIRCLE);
    }

    public Series(List<T> ITEMS, ChartType TYPE, String NAME, Symbol SYMBOL) {
        this(ITEMS, TYPE, NAME, (Paint)Color.TRANSPARENT, (Paint)Color.BLACK, Color.BLACK, Color.BLACK, SYMBOL);
    }

    public Series(ChartType TYPE, String NAME, Paint FILL, Paint STROKE, Symbol SYMBOL, T ... ITEMS) {
        this(Arrays.asList(ITEMS), TYPE, NAME, FILL, STROKE, Color.BLACK, Color.BLACK, SYMBOL);
    }

    public Series(List<T> ITEMS, ChartType TYPE, String NAME, Paint FILL, Paint STROKE, Symbol SYMBOL) {
        this(ITEMS, TYPE, NAME, FILL, STROKE, Color.BLACK, Color.BLACK, SYMBOL);
    }

    public Series(List<T> ITEMS, ChartType TYPE, String NAME, Paint FILL, Paint STROKE, Color SYMBOL_FILL, Color SYMBOL_STROKE, Symbol SYMBOL) {
        this._name = NAME;
        this._fill = FILL;
        this._stroke = STROKE;
        this._textFill = Color.BLACK;
        this._symbolFill = SYMBOL_FILL;
        this._symbolStroke = SYMBOL_STROKE;
        this._symbol = SYMBOL;
        this._symbolsVisible = true;
        this._symbolSize = -1.0;
        this._strokeWidth = -1.0;
        this._animated = false;
        this._animationDuration = 800L;
        this._withWrapping = false;
        this.chartType = TYPE;
        this.items = FXCollections.observableArrayList();
        this.itemListener = change -> this.fireSeriesEvent(this.UPDATE_EVENT);
        this.itemEventListener = e -> this.fireSeriesEvent(this.UPDATE_EVENT);
        this.listeners = new CopyOnWriteArrayList();
        if (ITEMS != null) {
            this.items.setAll(ITEMS);
        }
        this.registerListeners();
    }

    private void registerListeners() {
        this.items.addListener(new ListChangeListener<T>(){

            public void onChanged(ListChangeListener.Change<? extends T> c) {
                while (c.next()) {
                    if (c.wasAdded()) {
                        c.getAddedSubList().forEach(item -> {
                            if (item instanceof XYChartItem) {
                                XYChartItem xyChartItem = (XYChartItem)item;
                                xyChartItem.addItemEventListener(Series.this.itemEventListener);
                            }
                        });
                        continue;
                    }
                    if (!c.wasRemoved()) continue;
                    c.getRemoved().forEach(item -> {
                        if (item instanceof XYChartItem) {
                            XYChartItem xyChartItem = (XYChartItem)item;
                            xyChartItem.removeItemEventListener(Series.this.itemEventListener);
                        }
                    });
                }
            }
        });
        this.items.addListener(this.itemListener);
    }

    public ObservableList<T> getItems() {
        return this.items;
    }

    public void setItems(Collection<T> ITEMS) {
        this.items.setAll(ITEMS);
    }

    public void setItems(T ... ITEMS) {
        this.setItems(Arrays.asList(ITEMS));
    }

    public void setItems(List<T> ITEMS) {
        this.items.setAll(ITEMS);
    }

    public String getName() {
        return this.name == null ? this._name : (String)this.name.get();
    }

    public void setName(String NAME) {
        if (this.name == null) {
            this._name = NAME;
            this.fireSeriesEvent(this.UPDATE_EVENT);
        } else {
            this.name.set((Object)NAME);
        }
    }

    public StringProperty nameProperty() {
        if (this.name == null) {
            this.name = new StringPropertyBase(this._name){

                protected void invalidated() {
                    Series.this.fireSeriesEvent(Series.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "name";
                }
            };
            this._name = null;
        }
        return this.name;
    }

    public Paint getFill() {
        return this.fill == null ? this._fill : (Paint)this.fill.get();
    }

    public void setFill(Paint PAINT) {
        if (this.fill == null) {
            this._fill = PAINT;
            this.refresh();
        } else {
            this.fill.set((Object)PAINT);
        }
    }

    public ObjectProperty<Paint> fillProperty() {
        if (this.fill == null) {
            this.fill = new ObjectPropertyBase<Paint>(this._fill){

                protected void invalidated() {
                    Series.this.refresh();
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "fill";
                }
            };
            this._fill = null;
        }
        return this.fill;
    }

    public Paint getStroke() {
        return this.stroke == null ? this._stroke : (Paint)this.stroke.get();
    }

    public void setStroke(Paint PAINT) {
        if (this.stroke == null) {
            this._stroke = PAINT;
            this.refresh();
        } else {
            this.stroke.set((Object)PAINT);
        }
    }

    public ObjectProperty<Paint> strokeProperty() {
        if (this.stroke == null) {
            this.stroke = new ObjectPropertyBase<Paint>(this._stroke){

                protected void invalidated() {
                    Series.this.refresh();
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "stroke";
                }
            };
            this._stroke = null;
        }
        return this.stroke;
    }

    public Color getTextFill() {
        return this.textFill == null ? this._textFill : (Color)this.textFill.get();
    }

    public void setTextFill(Color COLOR) {
        if (this.textFill == null) {
            this._textFill = COLOR;
            this.refresh();
        } else {
            this.textFill.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> textFillProperty() {
        if (this.textFill == null) {
            this.textFill = new ObjectPropertyBase<Color>(this._textFill){

                protected void invalidated() {
                    Series.this.refresh();
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "textFill";
                }
            };
            this._textFill = null;
        }
        return this.textFill;
    }

    public Color getSymbolFill() {
        return this.symbolFill == null ? this._symbolFill : (Color)this.symbolFill.get();
    }

    public void setSymbolFill(Color COLOR) {
        if (this.symbolFill == null) {
            this._symbolFill = COLOR;
            this.refresh();
        } else {
            this.symbolFill.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> symbolFillProperty() {
        if (this.symbolFill == null) {
            this.symbolFill = new ObjectPropertyBase<Color>(this._symbolFill){

                protected void invalidated() {
                    Series.this.refresh();
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "symbolFill";
                }
            };
            this._symbolFill = null;
        }
        return this.symbolFill;
    }

    public Color getSymbolStroke() {
        return this.symbolStroke == null ? this._symbolStroke : (Color)this.symbolStroke.get();
    }

    public void setSymbolStroke(Color COLOR) {
        if (this.symbolStroke == null) {
            this._symbolStroke = COLOR;
            this.refresh();
        } else {
            this.symbolStroke.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> symbolStrokeProperty() {
        if (this.symbolStroke == null) {
            this.symbolStroke = new ObjectPropertyBase<Color>(this._symbolStroke){

                protected void invalidated() {
                    Series.this.refresh();
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "symbolStroke";
                }
            };
            this._symbolStroke = null;
        }
        return this.symbolStroke;
    }

    public Symbol getSymbol() {
        return this.symbol == null ? this._symbol : (Symbol)((Object)this.symbol.get());
    }

    public void setSymbol(Symbol SYMBOL) {
        if (this.symbol == null) {
            this._symbol = SYMBOL;
            this.fireSeriesEvent(this.UPDATE_EVENT);
        } else {
            this.symbol.set((Object)SYMBOL);
        }
    }

    public ObjectProperty<Symbol> symbolProperty() {
        if (this.symbol == null) {
            this.symbol = new ObjectPropertyBase<Symbol>(this._symbol){

                protected void invalidated() {
                    Series.this.fireSeriesEvent(Series.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "symbol";
                }
            };
            this._symbol = null;
        }
        return this.symbol;
    }

    public boolean getSymbolsVisible() {
        return this.symbolsVisible == null ? this._symbolsVisible : this.symbolsVisible.get();
    }

    public void setSymbolsVisible(boolean VISIBLE) {
        if (this.symbolsVisible == null) {
            this._symbolsVisible = VISIBLE;
            this.fireSeriesEvent(this.UPDATE_EVENT);
        } else {
            this.symbolsVisible.set(VISIBLE);
        }
    }

    public BooleanProperty symbolsVisibleProperty() {
        if (this.symbolsVisible == null) {
            this.symbolsVisible = new BooleanPropertyBase(this._symbolsVisible){

                protected void invalidated() {
                    Series.this.fireSeriesEvent(Series.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "symbolsVisible";
                }
            };
        }
        return this.symbolsVisible;
    }

    public ChartType getChartType() {
        return this.chartType;
    }

    public void setChartType(ChartType TYPE) {
        this.chartType = TYPE;
        this.refresh();
    }

    public double getSymbolSize() {
        return this.symbolSize == null ? this._symbolSize : this.symbolSize.get();
    }

    public void setSymbolSize(double SIZE) {
        if (this.symbolSize == null) {
            this._symbolSize = Helper.clamp(1.0, 24.0, SIZE);
            this.fireSeriesEvent(this.UPDATE_EVENT);
        } else {
            this.symbolSize.set(SIZE);
        }
    }

    public DoubleProperty symbolSizeProperty() {
        if (this.symbolSize == null) {
            this.symbolSize = new DoublePropertyBase(this._symbolSize){

                protected void invalidated() {
                    this.set(Helper.clamp(1.0, 24.0, this.get()));
                    Series.this.fireSeriesEvent(Series.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "symbolSize";
                }
            };
        }
        return this.symbolSize;
    }

    public double getStrokeWidth() {
        return this.strokeWidth == null ? this._strokeWidth : this.strokeWidth.get();
    }

    public void setStrokeWidth(double WIDTH) {
        if (this.strokeWidth == null) {
            this._strokeWidth = Helper.clamp(1.0, 24.0, WIDTH);
            this.fireSeriesEvent(this.UPDATE_EVENT);
        } else {
            this.strokeWidth.set(WIDTH);
        }
    }

    public DoubleProperty strokeWidthProperty() {
        if (this.strokeWidth == null) {
            this.strokeWidth = new DoublePropertyBase(this._strokeWidth){

                protected void invalidated() {
                    this.set(Helper.clamp(1.0, 24.0, this.get()));
                    Series.this.fireSeriesEvent(Series.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "strokeWidth";
                }
            };
        }
        return this.strokeWidth;
    }

    public boolean isAnimated() {
        return this.animated == null ? this._animated : this.animated.get();
    }

    public void setAnimated(boolean ANIMATED) {
        if (this.animated == null) {
            this._animated = ANIMATED;
        } else {
            this.animated.set(ANIMATED);
        }
    }

    public BooleanProperty animatedProperty() {
        if (this.animated == null) {
            this.animated = new BooleanPropertyBase(this._animated){

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "animated";
                }
            };
        }
        return this.animated;
    }

    public long getAnimationDuration() {
        return this.animationDuration == null ? this._animationDuration : this.animationDuration.get();
    }

    public void setAnimationDuration(long DURATION) {
        if (this.animationDuration == null) {
            this._animationDuration = Helper.clamp(10L, 10000L, DURATION);
        } else {
            this.animationDuration.set(Helper.clamp(10L, 10000L, DURATION));
        }
    }

    public LongProperty animationDurationProperty() {
        if (this.animationDuration == null) {
            this.animationDuration = new LongPropertyBase(this._animationDuration){

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "animationDuration";
                }
            };
        }
        return this.animationDuration;
    }

    public boolean isWithWrapping() {
        return this.withWrapping == null ? this._withWrapping : this.withWrapping.get();
    }

    public void setWithWrapping(boolean WITH_WRAPPING) {
        if (this.withWrapping == null) {
            this._withWrapping = WITH_WRAPPING;
            this.fireSeriesEvent(this.UPDATE_EVENT);
        } else {
            this.withWrapping.set(WITH_WRAPPING);
        }
    }

    public BooleanProperty withWrappingProperty() {
        if (this.withWrapping == null) {
            this.withWrapping = new BooleanPropertyBase(this._withWrapping){

                protected void invalidated() {
                    Series.this.fireSeriesEvent(Series.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "withWrapping";
                }
            };
        }
        return this.symbolsVisible;
    }

    public int getNoOfItems() {
        return this.items.size();
    }

    public void dispose() {
        this.items.remove(this.itemListener);
    }

    public void refresh() {
        this.fireSeriesEvent(this.UPDATE_EVENT);
    }

    public void setOnSeriesEvent(SeriesEventListener LISTENER) {
        this.addSeriesEventListener(LISTENER);
    }

    public void addSeriesEventListener(SeriesEventListener LISTENER) {
        if (!this.listeners.contains(LISTENER)) {
            this.listeners.add(LISTENER);
        }
    }

    public void removeSeriesEventListener(SeriesEventListener LISTENER) {
        if (this.listeners.contains(LISTENER)) {
            this.listeners.remove(LISTENER);
        }
    }

    public void fireSeriesEvent(SeriesEvent EVENT) {
        for (SeriesEventListener listener : this.listeners) {
            listener.onModelEvent(EVENT);
        }
    }
}

