/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.tools;

public class Point
implements Comparable<Point> {
    private double x;
    private double y;
    private boolean empty;

    public Point() {
        this(0.0, 0.0, false);
    }

    public Point(boolean IS_EMPTY) {
        this(0.0, 0.0, IS_EMPTY);
    }

    public Point(double X, double Y) {
        this(X, Y, false);
    }

    public Point(double X, double Y, boolean IS_EMPTY) {
        this.x = X;
        this.y = Y;
        this.empty = IS_EMPTY;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double X) {
        this.x = X;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double Y) {
        this.y = Y;
    }

    public void set(double X, double Y) {
        this.x = X;
        this.y = Y;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean isEmpty) {
        this.empty = isEmpty;
    }

    public double distanceTo(Point P) {
        return Point.distance(P.getX(), P.getY(), this.x, this.y);
    }

    public double distanceTo(double X, double Y) {
        return Point.distance(X, Y, this.x, this.y);
    }

    public static double distance(Point P1, Point P2) {
        return Point.distance(P1.getX(), P1.getY(), P2.getX(), P2.getY());
    }

    public static double distance(double X1, double Y1, double X2, double Y2) {
        double deltaX = X2 - X1;
        double deltaY = Y2 - Y1;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    @Override
    public int compareTo(Point POINT) {
        return this.x != POINT.getX() ? Double.compare(this.x, POINT.x) : Double.compare(this.y, POINT.y);
    }

    public String toString() {
        return "x: " + this.x + ", y: " + this.y;
    }
}

