/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.voronoi;

public class VPoint {
    private double[] coordinates;

    public VPoint(double ... coords) {
        this.coordinates = new double[coords.length];
        System.arraycopy(coords, 0, this.coordinates, 0, coords.length);
    }

    public double getCoordinates(int i) {
        return this.coordinates[i];
    }

    public int getDimension() {
        return this.coordinates.length;
    }

    public int checkDimension(VPoint p) {
        int len = this.coordinates.length;
        if (len != p.coordinates.length) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        return len;
    }

    public VPoint extend(double ... coords) {
        double[] result = new double[this.coordinates.length + coords.length];
        System.arraycopy(this.coordinates, 0, result, 0, this.coordinates.length);
        System.arraycopy(coords, 0, result, this.coordinates.length, coords.length);
        return new VPoint(result);
    }

    public double dotProduct(VPoint p) {
        int len = this.checkDimension(p);
        double sum = 0.0;
        int i = 0;
        while (i < len) {
            sum += this.coordinates[i] * p.coordinates[i];
            ++i;
        }
        return sum;
    }

    public double magnitude() {
        return Math.sqrt(this.dotProduct(this));
    }

    public VPoint subtract(VPoint p) {
        int len = this.checkDimension(p);
        double[] coords = new double[len];
        int i = 0;
        while (i < len) {
            coords[i] = this.coordinates[i] - p.coordinates[i];
            ++i;
        }
        return new VPoint(coords);
    }

    public VPoint add(VPoint p) {
        int len = this.checkDimension(p);
        double[] coords = new double[len];
        int i = 0;
        while (i < len) {
            coords[i] = this.coordinates[i] + p.coordinates[i];
            ++i;
        }
        return new VPoint(coords);
    }

    public double angle(VPoint p) {
        return Math.acos(this.dotProduct(p) / (this.magnitude() * p.magnitude()));
    }

    public VPoint bisector(VPoint point) {
        this.checkDimension(point);
        VPoint diff = this.subtract(point);
        VPoint sum = this.add(point);
        double dot = diff.dotProduct(sum);
        return diff.extend(-dot / 2.0);
    }

    public static String toString(VPoint[] matrix) {
        StringBuilder buf = new StringBuilder("{");
        VPoint[] vPointArray = matrix;
        int n = matrix.length;
        int n2 = 0;
        while (n2 < n) {
            VPoint row = vPointArray[n2];
            buf.append(" " + row);
            ++n2;
        }
        buf.append(" }");
        return buf.toString();
    }

    public static double determinant(VPoint[] matrix) {
        if (matrix.length != matrix[0].getDimension()) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        boolean[] columns = new boolean[matrix.length];
        int i = 0;
        while (i < matrix.length) {
            columns[i] = true;
            ++i;
        }
        try {
            return VPoint.determinant(matrix, 0, columns);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Matrix is wrong shape");
        }
    }

    private static double determinant(VPoint[] matrix, int row, boolean[] cols) {
        if (row == matrix.length) {
            return 1.0;
        }
        double sum = 0.0;
        int sign = 1;
        int col = 0;
        while (col < cols.length) {
            if (cols[col]) {
                cols[col] = false;
                sum += (double)sign * matrix[row].coordinates[col] * VPoint.determinant(matrix, row + 1, cols);
                cols[col] = true;
                sign = -sign;
            }
            ++col;
        }
        return sum;
    }

    public static VPoint cross(VPoint[] matrix) {
        int len = matrix.length + 1;
        if (len != matrix[0].getDimension()) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        boolean[] columns = new boolean[len];
        int i = 0;
        while (i < len) {
            columns[i] = true;
            ++i;
        }
        double[] result = new double[len];
        int sign = 1;
        try {
            int i2 = 0;
            while (i2 < len) {
                columns[i2] = false;
                result[i2] = (double)sign * VPoint.determinant(matrix, 0, columns);
                columns[i2] = true;
                sign = -sign;
                ++i2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Matrix is wrong shape");
        }
        return new VPoint(result);
    }

    public static double content(VPoint[] simplex) {
        VPoint[] matrix = new VPoint[simplex.length];
        int i = 0;
        while (i < matrix.length) {
            matrix[i] = simplex[i].extend(1.0);
            ++i;
        }
        int fact = 1;
        int i2 = 1;
        while (i2 < matrix.length) {
            fact *= i2;
            ++i2;
        }
        return VPoint.determinant(matrix) / (double)fact;
    }

    public int[] relation(VPoint[] simplex) {
        int dim = simplex.length - 1;
        if (this.getDimension() != dim) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        VPoint[] matrix = new VPoint[dim + 1];
        double[] coords = new double[dim + 2];
        int j = 0;
        while (j < coords.length) {
            coords[j] = 1.0;
            ++j;
        }
        matrix[0] = new VPoint(coords);
        int i = 0;
        while (i < dim) {
            coords[0] = this.coordinates[i];
            int j2 = 0;
            while (j2 < simplex.length) {
                coords[j2 + 1] = simplex[j2].coordinates[i];
                ++j2;
            }
            matrix[i + 1] = new VPoint(coords);
            ++i;
        }
        VPoint vector = VPoint.cross(matrix);
        double content = vector.coordinates[0];
        int[] result = new int[dim + 1];
        int i2 = 0;
        while (i2 < result.length) {
            double value = vector.coordinates[i2 + 1];
            result[i2] = Math.abs(value) <= 1.0E-6 * Math.abs(content) ? 0 : (value < 0.0 ? -1 : 1);
            ++i2;
        }
        if (content < 0.0) {
            i2 = 0;
            while (i2 < result.length) {
                result[i2] = -result[i2];
                ++i2;
            }
        }
        if (content == 0.0) {
            i2 = 0;
            while (i2 < result.length) {
                result[i2] = Math.abs(result[i2]);
                ++i2;
            }
        }
        return result;
    }

    public VPoint isOutside(VPoint[] simplex) {
        int[] result = this.relation(simplex);
        int i = 0;
        while (i < result.length) {
            if (result[i] > 0) {
                return simplex[i];
            }
            ++i;
        }
        return null;
    }

    public VPoint isOn(VPoint[] simplex) {
        int[] result = this.relation(simplex);
        VPoint witness = null;
        int i = 0;
        while (i < result.length) {
            if (result[i] == 0) {
                witness = simplex[i];
            } else if (result[i] > 0) {
                return null;
            }
            ++i;
        }
        return witness;
    }

    public boolean isInside(VPoint[] simplex) {
        int[] result;
        int[] nArray = result = this.relation(simplex);
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            int r = nArray[n2];
            if (r >= 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int vsCircumCircle(VPoint[] simplex) {
        int result;
        VPoint[] matrix = new VPoint[simplex.length + 1];
        int i = 0;
        while (i < simplex.length) {
            matrix[i] = simplex[i].extend(1.0, simplex[i].dotProduct(simplex[i]));
            ++i;
        }
        matrix[simplex.length] = this.extend(1.0, this.dotProduct(this));
        double d = VPoint.determinant(matrix);
        int n = d < 0.0 ? -1 : (result = d > 0.0 ? 1 : 0);
        if (VPoint.content(simplex) < 0.0) {
            result = -result;
        }
        return result;
    }

    public static VPoint circumcenter(VPoint[] simplex) {
        int dim = simplex[0].getDimension();
        if (simplex.length - 1 != dim) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        VPoint[] matrix = new VPoint[dim];
        int i = 0;
        while (i < dim) {
            matrix[i] = simplex[i].bisector(simplex[i + 1]);
            ++i;
        }
        VPoint hCenter = VPoint.cross(matrix);
        double last = hCenter.coordinates[dim];
        double[] result = new double[dim];
        int i2 = 0;
        while (i2 < dim) {
            result[i2] = hCenter.coordinates[i2] / last;
            ++i2;
        }
        return new VPoint(result);
    }

    public boolean equals(Object other) {
        if (!(other instanceof VPoint)) {
            return false;
        }
        VPoint p = (VPoint)other;
        if (this.coordinates.length != p.coordinates.length) {
            return false;
        }
        int i = 0;
        while (i < this.coordinates.length) {
            if (this.coordinates[i] != p.coordinates[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        double[] dArray = this.coordinates;
        int n = this.coordinates.length;
        int n2 = 0;
        while (n2 < n) {
            double c = dArray[n2];
            long bits = Double.doubleToLongBits(c);
            hash = 31 * hash ^ (int)(bits ^ bits >> 32);
            ++n2;
        }
        return hash;
    }

    public String toString() {
        if (this.coordinates.length == 0) {
            return "Point()";
        }
        String result = "Point(" + this.coordinates[0];
        int i = 1;
        while (i < this.coordinates.length) {
            result = String.valueOf(result) + "," + this.coordinates[i];
            ++i;
        }
        result = String.valueOf(result) + ")";
        return result;
    }
}

