/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.voronoi;

import eu.hansolo.fx.charts.voronoi.VPoint;
import eu.hansolo.fx.charts.voronoi.VoronoiChart;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;

public class VoronoiChartBuilder<B extends VoronoiChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected VoronoiChartBuilder() {
    }

    public static final VoronoiChartBuilder create() {
        return new VoronoiChartBuilder();
    }

    public final B points(List<VPoint> POINTS) {
        this.properties.put("points", (Property)new SimpleObjectProperty(POINTS));
        return (B)this;
    }

    public final B pointsVisible(boolean VISIBLE) {
        this.properties.put("pointsVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B pointColor(Color COLOR) {
        this.properties.put("pointColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B fillRegions(boolean FILL) {
        this.properties.put("fillRegions", (Property)new SimpleBooleanProperty(FILL));
        return (B)this;
    }

    public final B borderColor(Color COLOR) {
        this.properties.put("borderColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B type(VoronoiChart.Type TYPE) {
        this.properties.put("type", (Property)new SimpleObjectProperty((Object)TYPE));
        return (B)this;
    }

    public final B multiColor(boolean MULTICOLOR) {
        this.properties.put("multiColor", (Property)new SimpleBooleanProperty(MULTICOLOR));
        return (B)this;
    }

    public final B voronoiColor(Color COLOR) {
        this.properties.put("voronoiColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B delaunayColor(Color COLOR) {
        this.properties.put("delaunayColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B interactive(boolean INTERACTIVE) {
        this.properties.put("interactive", (Property)new SimpleBooleanProperty(INTERACTIVE));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final VoronoiChart build() {
        VoronoiChart chart = this.properties.containsKey("points") ? new VoronoiChart((List)((ObjectProperty)this.properties.get("points")).get()) : new VoronoiChart();
        for (String key : this.properties.keySet()) {
            Dimension2D dim;
            if ("prefSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                chart.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                chart.setMinSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                chart.setMaxSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                chart.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                chart.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                chart.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                chart.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                chart.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                chart.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                chart.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                chart.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                chart.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                chart.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                chart.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                chart.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("padding".equals(key)) {
                chart.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("pointsVisible".equals(key)) {
                chart.setPointsVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("pointColor".equals(key)) {
                chart.setPointColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("fillRegions".equals(key)) {
                chart.setFillRegions(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("borderColor".equals(key)) {
                chart.setBorderColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("type".equals(key)) {
                chart.setType((VoronoiChart.Type)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("multiColor".equals(key)) {
                chart.setMulticolor(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("voronoiColor".equals(key)) {
                chart.setVoronoiColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("delaunayColor".equals(key)) {
                chart.setDelaunayColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"interactive".equals(key)) continue;
            chart.setInteractive(((BooleanProperty)this.properties.get(key)).get());
        }
        return chart;
    }
}

