/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.world;

import eu.hansolo.fx.charts.data.MapConnection;
import eu.hansolo.fx.charts.data.WeightedMapPoints;
import eu.hansolo.fx.charts.heatmap.OpacityDistribution;
import eu.hansolo.fx.charts.tools.ColorMapping;
import eu.hansolo.fx.charts.tools.Location;
import eu.hansolo.fx.charts.tools.MapPoint;
import eu.hansolo.fx.charts.world.World;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;

public class WorldBuilder<B extends WorldBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();
    private World.Resolution resolution = World.Resolution.HI_RES;

    protected WorldBuilder() {
    }

    public static final WorldBuilder create() {
        return new WorldBuilder();
    }

    public final B resolution(World.Resolution RESOLUTION) {
        this.resolution = RESOLUTION;
        return (B)this;
    }

    public final B backgroundColor(Color COLOR) {
        this.properties.put("backgroundColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B fillColor(Color COLOR) {
        this.properties.put("fillColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B strokeColor(Color COLOR) {
        this.properties.put("strokeColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B hoverColor(Color COLOR) {
        this.properties.put("hoverColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B pressedColor(Color COLOR) {
        this.properties.put("pressedColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B selectedColor(Color COLOR) {
        this.properties.put("selectedColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B locationColor(Color COLOR) {
        this.properties.put("locationColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B hoverEnabled(boolean ENABLED) {
        this.properties.put("hoverEnabled", (Property)new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B selectionEnabled(boolean ENABLED) {
        this.properties.put("selectionEnabled", (Property)new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B zoomEnabled(boolean ENABLED) {
        this.properties.put("zoomEnabled", (Property)new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B mouseEnterHandler(EventHandler<MouseEvent> HANDLER) {
        this.properties.put("mouseEnterHandler", (Property)new SimpleObjectProperty(HANDLER));
        return (B)this;
    }

    public final B mousePressHandler(EventHandler<MouseEvent> HANDLER) {
        this.properties.put("mousePressHandler", (Property)new SimpleObjectProperty(HANDLER));
        return (B)this;
    }

    public final B mouseReleaseHandler(EventHandler<MouseEvent> HANDLER) {
        this.properties.put("mouseReleaseHandler", (Property)new SimpleObjectProperty(HANDLER));
        return (B)this;
    }

    public final B mouseExitHandler(EventHandler<MouseEvent> HANDLER) {
        this.properties.put("mouseExitHandler", (Property)new SimpleObjectProperty(HANDLER));
        return (B)this;
    }

    public final B locations(Location ... LOCATIONS) {
        this.properties.put("locations", (Property)new SimpleObjectProperty((Object)LOCATIONS));
        return (B)this;
    }

    public final B showLocations(boolean VISIBLE) {
        this.properties.put("showLocations", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B colorMapping(ColorMapping COLOR_MAPPING) {
        this.properties.put("colorMapping", (Property)new SimpleObjectProperty((Object)COLOR_MAPPING));
        return (B)this;
    }

    public final B eventRadius(double EVENT_RADIUS) {
        this.properties.put("eventRadius", (Property)new SimpleDoubleProperty(EVENT_RADIUS));
        return (B)this;
    }

    public final B fadeColors(boolean FADE_COLORS) {
        this.properties.put("fadeColors", (Property)new SimpleBooleanProperty(FADE_COLORS));
        return (B)this;
    }

    public final B heatMapOpacity(double HEAT_MAP_OPACITY) {
        this.properties.put("heatMapOpacity", (Property)new SimpleDoubleProperty(HEAT_MAP_OPACITY));
        return (B)this;
    }

    public final B opacityDistribution(OpacityDistribution OPACITY_DISTRIBUTION) {
        this.properties.put("opacityDistribution", (Property)new SimpleObjectProperty((Object)OPACITY_DISTRIBUTION));
        return (B)this;
    }

    public final B mapPoints(List<MapPoint> MAP_POINTS) {
        this.properties.put("mapPoints", (Property)new SimpleObjectProperty(MAP_POINTS));
        return (B)this;
    }

    public final B mapConnections(List<MapConnection> MAP_CONNECTIONS) {
        this.properties.put("mapConnections", (Property)new SimpleObjectProperty(MAP_CONNECTIONS));
        return (B)this;
    }

    public final B weightedMapPoints(WeightedMapPoints WEIGHTED) {
        this.properties.put("weightedMapPoints", (Property)new SimpleObjectProperty((Object)WEIGHTED));
        return (B)this;
    }

    public final B weightedMapConnections(boolean WEIGHTED) {
        this.properties.put("weightedMapConnections", (Property)new SimpleBooleanProperty(WEIGHTED));
        return (B)this;
    }

    public final B mapPointTextVisible(boolean VISIBLE) {
        this.properties.put("mapPointTextVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B connectionWidth(double WIDTH) {
        this.properties.put("connectionWidth", (Property)new SimpleDoubleProperty(WIDTH));
        return (B)this;
    }

    public final B arrowsVisible(boolean VISIBLE) {
        this.properties.put("arrowsVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B drawImagePath(boolean DRAW) {
        this.properties.put("drawImagePath", (Property)new SimpleBooleanProperty(DRAW));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final World build() {
        ColorMapping colorMapping = this.properties.containsKey("colorMapping") ? (ColorMapping)((Object)((ObjectProperty)this.properties.get("colorMapping")).get()) : ColorMapping.INFRARED_3;
        double eventRadius = this.properties.containsKey("eventRadius") ? ((DoubleProperty)this.properties.get("eventRadius")).get() : 5.0;
        boolean fadeColors = this.properties.containsKey("fadeColors") ? ((BooleanProperty)this.properties.get("fadeColors")).get() : false;
        double heatMapOpacity = this.properties.containsKey("heatMapOpacity") ? ((DoubleProperty)this.properties.get("heatMapOpacity")).get() : 0.5;
        OpacityDistribution opacityDistribution = this.properties.containsKey("opacityDistribution") ? (OpacityDistribution)((Object)((ObjectProperty)this.properties.get("opacityDistribution")).get()) : OpacityDistribution.EXPONENTIAL;
        World CONTROL = new World(this.resolution, colorMapping, eventRadius, fadeColors, opacityDistribution, heatMapOpacity);
        for (String key : this.properties.keySet()) {
            Dimension2D dim;
            if ("prefSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setMinSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setMaxSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                CONTROL.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                CONTROL.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                CONTROL.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                CONTROL.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                CONTROL.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                CONTROL.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                CONTROL.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                CONTROL.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                CONTROL.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                CONTROL.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                CONTROL.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                CONTROL.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("padding".equals(key)) {
                CONTROL.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("backgroundColor".equals(key)) {
                CONTROL.setBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("fillColor".equals(key)) {
                CONTROL.setFillColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("strokeColor".equals(key)) {
                CONTROL.setStrokeColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("hoverColor".equals(key)) {
                CONTROL.setHoverColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("pressedColor".equals(key)) {
                CONTROL.setPressedColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("selectedColor".equals(key)) {
                CONTROL.setSelectedColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("locationColor".equals(key)) {
                CONTROL.setLocationColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("hoverEnabled".equals(key)) {
                CONTROL.setHoverEnabled(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("selectionEnabled".equals(key)) {
                CONTROL.setSelectionEnabled(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("zoomEnabled".equals(key)) {
                CONTROL.setZoomEnabled(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("mouseEnterHandler".equals(key)) {
                CONTROL.setMouseEnterHandler((EventHandler<MouseEvent>)((EventHandler)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("mousePressHandler".equals(key)) {
                CONTROL.setMousePressHandler((EventHandler<MouseEvent>)((EventHandler)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("mouseReleaseHandler".equals(key)) {
                CONTROL.setMouseReleaseHandler((EventHandler<MouseEvent>)((EventHandler)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("mouseExitHandler".equals(key)) {
                CONTROL.setMouseExitHandler((EventHandler<MouseEvent>)((EventHandler)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("locations".equals(key)) {
                CONTROL.addLocations((Location[])((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("showLocations".equals(key)) {
                CONTROL.showLocations(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("mapPoints".equals(key)) {
                CONTROL.setMapPoints((List)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("mapConnections".equals(key)) {
                CONTROL.setMapConnections((List)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("weightedMapPoints".equals(key)) {
                CONTROL.setWeightedMapPoints((WeightedMapPoints)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("weightedMapConnections".equals(key)) {
                CONTROL.setWeightedMapConnections(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("mapPointTextVisible".equals(key)) {
                CONTROL.setMapPointTextVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("textColor".equals(key)) {
                CONTROL.setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("connectionWidth".equals(key)) {
                CONTROL.setConnectionWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("arrowsVisible".equals(key)) {
                CONTROL.setArrowsVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"drawImagePath".equals(key)) continue;
            CONTROL.setDrawImagePath(((BooleanProperty)this.properties.get(key)).get());
        }
        return CONTROL;
    }
}

